/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc;

import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequest;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class JsonRpcRequestCreator {
    private final JsonMapper jsonMapper;
    private static final String TOOLS_SLASH_CALL = "tools/call";

    JsonRpcRequestCreator(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public JsonRpcRequest create(JsonObject jsonObject) {
        return this.createWithFilter(jsonObject, null);
    }

    public JsonRpcRequest mcpCreate(JsonObject jsonObject) {
        return this.remap(this.createWithFilter(jsonObject, "_meta", "cursor"));
    }

    private JsonRpcRequest remap(JsonRpcRequest jsonRpcRequest) {
        if (jsonRpcRequest.getMethod().equalsIgnoreCase(TOOLS_SLASH_CALL)) {
            Map params = jsonRpcRequest.getParams();
            String mappedName = (String)params.remove("name");
            Map mappedParams = (Map)params.remove("arguments");
            JsonRpcRequest mapped = new JsonRpcRequest(this.jsonMapper);
            mapped.setId(jsonRpcRequest.getId());
            mapped.setJsonrpc(jsonRpcRequest.getJsonrpc());
            mapped.setMethod(mappedName);
            if (mappedParams != null && !mappedParams.isEmpty()) {
                mapped.setParams(mappedParams);
            }
            return mapped;
        }
        return jsonRpcRequest;
    }

    public String toJson(JsonRpcRequest jsonRpcRequest) {
        return this.jsonMapper.toString(jsonRpcRequest, true);
    }

    private JsonRpcRequest createWithFilter(JsonObject jsonObject, String ... filter) {
        JsonRpcRequest jsonRpcRequest = new JsonRpcRequest(this.jsonMapper);
        if (jsonObject.containsKey("id")) {
            jsonRpcRequest.setId(jsonObject.getInteger("id"));
        }
        if (jsonObject.containsKey("jsonrpc")) {
            jsonRpcRequest.setJsonrpc(jsonObject.getString("jsonrpc"));
        }
        jsonRpcRequest.setMethod(jsonObject.getString("method"));
        if (jsonObject.containsKey("params")) {
            Map map = jsonObject.getJsonObject("params").getMap();
            if (filter != null) {
                for (String p : filter) {
                    map.remove(p);
                }
            }
            jsonRpcRequest.setParams(map);
        }
        return jsonRpcRequest;
    }
}

