/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.CracSupport;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;

public final class RunnerClassLoader
extends ClassLoader {
    private final Map<String, ClassLoadingResource[]> resourceDirectoryMap;
    private final Set<String> parentFirstPackages;
    private final Set<String> nonExistentResources;
    private final List<String> fullyIndexedDirectories;
    private final Map<String, ClassLoadingResource[]> directlyIndexedResourcesIndexMap;
    private final ClassLoadingResource generatedBytecodeClassLoadingResource;
    private final Set<String> generatedBytecode;
    private final ClassLoadingResource transformedBytecodeClassLoadingResource;
    private final Set<String> transformedBytecode;
    private final ClassLoadingResource[] currentlyBufferedResources = new ClassLoadingResource[4];
    private boolean postBootPhase = false;
    private final CracResource resource;

    RunnerClassLoader(ClassLoader parent, Map<String, ClassLoadingResource[]> resourceDirectoryMap, Set<String> parentFirstPackages, Set<String> nonExistentResources, List<String> fullyIndexedDirectories, Map<String, ClassLoadingResource[]> directlyIndexedResourcesIndexMap, ClassLoadingResource generatedBytecodeClassLoadingResource, Set<String> generatedBytecode, ClassLoadingResource transformedBytecodeClassLoadingResource, Set<String> transformedBytecode) {
        super(parent);
        this.resourceDirectoryMap = resourceDirectoryMap;
        this.parentFirstPackages = parentFirstPackages;
        this.nonExistentResources = nonExistentResources;
        this.fullyIndexedDirectories = fullyIndexedDirectories;
        this.directlyIndexedResourcesIndexMap = directlyIndexedResourcesIndexMap;
        this.generatedBytecodeClassLoadingResource = generatedBytecodeClassLoadingResource;
        this.generatedBytecode = generatedBytecode;
        this.transformedBytecodeClassLoadingResource = transformedBytecodeClassLoadingResource;
        this.transformedBytecode = transformedBytecode;
        if (CracSupport.isEnabled()) {
            this.resource = new CracResource();
            Core.getGlobalContext().register((Resource)this.resource);
        } else {
            this.resource = null;
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoadingResource[] resources;
        Class<?> loaded;
        if (ClassLoaderHelper.isInJdkPackage((String)name)) {
            return this.getParent().loadClass(name);
        }
        String packageName = this.getPackageNameFromClassName(name);
        if (this.parentFirstPackages.contains(packageName)) {
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((loaded = this.findLoadedClass(name)) != null) {
            return loaded;
        }
        if (packageName == null) {
            resources = this.resourceDirectoryMap.get("");
        } else {
            String dirName = packageName.replace('.', '/');
            resources = this.resourceDirectoryMap.get(dirName);
        }
        if (resources != null) {
            String classResource = ClassLoaderHelper.fromClassNameToResourceName((String)name);
            for (ClassLoadingResource resource : resources) {
                if (resource == this.generatedBytecodeClassLoadingResource && !this.generatedBytecode.contains(classResource) || resource == this.transformedBytecodeClassLoadingResource && !this.transformedBytecode.contains(classResource)) continue;
                this.accessingResource(resource);
                byte[] data = resource.getResourceData(classResource);
                if (data == null) continue;
                this.definePackage(packageName, resources);
                return this.defineClass(name, data, resource);
            }
        }
        return this.getParent().loadClass(name);
    }

    private void definePackage(String pkgName, ClassLoadingResource[] resources) {
        block7: {
            if (pkgName != null && this.getDefinedPackage(pkgName) == null) {
                for (ClassLoadingResource classPathElement : resources) {
                    block6: {
                        ManifestInfo mf = classPathElement.getManifestInfo();
                        if (mf == null) continue;
                        try {
                            this.definePackage(pkgName, mf.getSpecTitle(), mf.getSpecVersion(), mf.getSpecVendor(), mf.getImplTitle(), mf.getImplVersion(), mf.getImplVendor(), null);
                        }
                        catch (IllegalArgumentException e) {
                            Package loaded = this.getDefinedPackage(pkgName);
                            if (loaded != null) break block6;
                            throw e;
                        }
                    }
                    return;
                }
                try {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException e) {
                    Package loaded = this.getDefinedPackage(pkgName);
                    if (loaded != null) break block7;
                    throw e;
                }
            }
        }
    }

    private Class<?> defineClass(String name, byte[] data, ClassLoadingResource resource) {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        try {
            return this.defineClass(name, data, 0, data.length, resource.getProtectionDomain());
        }
        catch (LinkageError e) {
            loaded = this.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessingResource(ClassLoadingResource resource) {
        ClassLoadingResource[] classLoadingResourceArray = this.currentlyBufferedResources;
        synchronized (this.currentlyBufferedResources) {
            if (!this.postBootPhase) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            if (this.currentlyBufferedResources[0] == resource) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            for (int i = 1; i < this.currentlyBufferedResources.length; ++i) {
                ClassLoadingResource currentI = this.currentlyBufferedResources[i];
                if (currentI != resource && currentI != null) continue;
                this.bubbleUpCachedResource(resource, i);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            ClassLoadingResource toEvict = this.currentlyBufferedResources[this.currentlyBufferedResources.length - 1];
            this.bubbleUpCachedResource(resource, this.currentlyBufferedResources.length - 1);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            toEvict.resetInternalCaches();
            return;
        }
    }

    private void bubbleUpCachedResource(ClassLoadingResource resource, int i) {
        for (int j = i; j > 0; --j) {
            this.currentlyBufferedResources[j] = this.currentlyBufferedResources[j - 1];
        }
        this.currentlyBufferedResources[0] = resource;
    }

    @Override
    protected URL findResource(String name) {
        if (this.nonExistentResources.contains(name = this.sanitizeName(name))) {
            return null;
        }
        ClassLoadingResource[] resources = this.getClassLoadingResources(name);
        if (resources == null) {
            return null;
        }
        for (ClassLoadingResource resource : resources) {
            this.accessingResource(resource);
            URL data = resource.getResourceURL(name);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private String sanitizeName(String name) {
        if (name.length() > 0 && name.charAt(0) == '/') {
            return name.substring(1);
        }
        return name;
    }

    private ClassLoadingResource[] getClassLoadingResources(String name) {
        ClassLoadingResource[] resources = this.directlyIndexedResourcesIndexMap.get(name);
        if (resources != null) {
            return resources;
        }
        String dirName = this.getDirNameFromResourceName(name);
        if (dirName == null) {
            dirName = "";
        }
        if (!dirName.equals(name) && this.fullyIndexedDirectories.contains(dirName)) {
            if (dirName.isEmpty()) {
                return this.resourceDirectoryMap.get(name);
            }
            return null;
        }
        resources = this.resourceDirectoryMap.get(dirName);
        if (resources == null) {
            resources = this.resourceDirectoryMap.get(name);
        }
        return resources;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        if (this.nonExistentResources.contains(name = this.sanitizeName(name))) {
            return Collections.emptyEnumeration();
        }
        ClassLoadingResource[] resources = this.getClassLoadingResources(name);
        if (resources == null) {
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoadingResource resource : resources) {
            this.accessingResource(resource);
            URL data = resource.getResourceURL(name);
            if (data == null) continue;
            urls.add(data);
        }
        return Collections.enumeration(urls);
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    private String getDirNameFromResourceName(String resourceName) {
        int index = resourceName.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return resourceName.substring(0, index);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void close() {
        for (Map.Entry<String, ClassLoadingResource[]> entry : this.resourceDirectoryMap.entrySet()) {
            for (ClassLoadingResource i : entry.getValue()) {
                i.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInternalCaches() {
        ClassLoadingResource[] classLoadingResourceArray = this.currentlyBufferedResources;
        synchronized (this.currentlyBufferedResources) {
            for (Map.Entry<String, ClassLoadingResource[]> entry : this.resourceDirectoryMap.entrySet()) {
                for (ClassLoadingResource i : entry.getValue()) {
                    i.resetInternalCaches();
                }
            }
            this.postBootPhase = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return 1;
    }

    static {
        RunnerClassLoader.registerAsParallelCapable();
    }

    class CracResource
    implements Resource {
        CracResource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCheckpoint(Context<? extends Resource> ctx) {
            ClassLoadingResource[] classLoadingResourceArray = RunnerClassLoader.this.currentlyBufferedResources;
            synchronized (RunnerClassLoader.this.currentlyBufferedResources) {
                for (int i = 0; i < RunnerClassLoader.this.currentlyBufferedResources.length; ++i) {
                    if (RunnerClassLoader.this.currentlyBufferedResources[i] == null) continue;
                    RunnerClassLoader.this.currentlyBufferedResources[i].resetInternalCaches();
                    RunnerClassLoader.this.currentlyBufferedResources[i] = null;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void afterRestore(Context<? extends Resource> ctx) {
        }
    }
}

