/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Collection;
import java.util.function.Supplier;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.jspecify.annotations.NullMarked;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.lazy.Lazy;
import org.gradle.tooling.Failure;
import org.gradle.tooling.FetchModelResult;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.consumer.parameters.BuildProgressListenerAdapter;
import org.gradle.tooling.internal.protocol.InternalFailure;

@NullMarked
public class DefaultFetchModelResult<M>
implements FetchModelResult<M> {
    private final @Nullable M model;
    private final Lazy<Collection<? extends Failure>> failures;

    private DefaultFetchModelResult(@Nullable M model, Supplier<Collection<? extends Failure>> failures) {
        this.model = model;
        this.failures = Lazy.locking().of(failures);
    }

    @Override
    public @Nullable M getModel() {
        return this.model;
    }

    @Override
    public Collection<? extends Failure> getFailures() {
        return (Collection)this.failures.get();
    }

    public static <M> DefaultFetchModelResult<M> of(@Nullable M model, Collection<? extends InternalFailure> failures) {
        return new DefaultFetchModelResult<M>(model, () -> BuildProgressListenerAdapter.toFailures(failures));
    }

    public static <M> DefaultFetchModelResult<M> success(M model) {
        return new DefaultFetchModelResult<M>(model, ImmutableList::of);
    }

    public static <M> DefaultFetchModelResult<M> failure(Exception exception) {
        return new DefaultFetchModelResult<Object>(null, () -> ImmutableList.of(DefaultFailure.fromThrowable(exception)));
    }
}

