/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet;

import io.undertow.servlet.UndertowServletLogger;
import jakarta.servlet.UnavailableException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class UndertowServletLogger_$logger
extends DelegatingBasicLogger
implements UndertowServletLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowServletLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public UndertowServletLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void stoppingServletDueToPermanentUnavailability(String servlet, UnavailableException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.stoppingServletDueToPermanentUnavailability$str(), (Object)servlet);
    }

    protected String stoppingServletDueToPermanentUnavailability$str() {
        return "UT015002: Stopping servlet %s due to permanent unavailability";
    }

    @Override
    public final void stoppingServletUntilDueToTemporaryUnavailability(String name, Date till, UnavailableException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.stoppingServletUntilDueToTemporaryUnavailability$str(), (Object)name, (Object)till);
    }

    protected String stoppingServletUntilDueToTemporaryUnavailability$str() {
        return "UT015003: Stopping servlet %s till %s due to temporary unavailability";
    }

    @Override
    public final void errorInvokingListener(String method, Class<?> listenerClass, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorInvokingListener$str(), (Object)method, listenerClass);
    }

    protected String errorInvokingListener$str() {
        return "UT015005: Error invoking method %s on listener %s";
    }

    @Override
    public final void ioExceptionDispatchingAsyncEvent(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.ioExceptionDispatchingAsyncEvent$str(), new Object[0]);
    }

    protected String ioExceptionDispatchingAsyncEvent$str() {
        return "UT015006: IOException dispatching async event";
    }

    @Override
    public final void servletStackTracesAll(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.servletStackTracesAll$str(), (Object)deploymentName);
    }

    protected String servletStackTracesAll$str() {
        return "UT015007: Stack trace on error enabled for deployment %s, please do not enable for production use";
    }

    @Override
    public final void failedtoLoadPersistentSessions(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedtoLoadPersistentSessions$str(), new Object[0]);
    }

    protected String failedtoLoadPersistentSessions$str() {
        return "UT015008: Failed to load development mode persistent sessions";
    }

    @Override
    public final void failedToPersistSessionAttribute(String attributeName, Object value, String sessionID, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistSessionAttribute$str(), (Object)attributeName, value, (Object)sessionID);
    }

    protected String failedToPersistSessionAttribute$str() {
        return "UT015009: Failed to persist session attribute %s with value %s for session %s";
    }

    @Override
    public final void failedToPersistSessions(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToPersistSessions$str(), new Object[0]);
    }

    protected String failedToPersistSessions$str() {
        return "UT015010: Failed to persist sessions";
    }

    @Override
    public final void errorGeneratingErrorPage(String originalErrorPage, Object originalException, int code, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorGeneratingErrorPage$str(), (Object)originalErrorPage, originalException, (Object)code);
    }

    protected String errorGeneratingErrorPage$str() {
        return "UT015012: Failed to generate error page %s for original exception: %s. Generating error page resulted in a %s.";
    }

    @Override
    public final void errorReadingRewriteConfiguration(IOException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorReadingRewriteConfiguration$str(), new Object[0]);
    }

    protected String errorReadingRewriteConfiguration$str() {
        return "UT015014: Error reading rewrite configuration";
    }

    protected String invalidRewriteConfiguration$str() {
        return "UT015015: Error reading rewrite configuration: %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteConfiguration(String line) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteConfiguration$str(), line));
        UndertowServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidRewriteMap$str() {
        return "UT015016: Invalid rewrite map class: %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteMap(String className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteMap$str(), className));
        UndertowServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRewriteFlags2$str() {
        return "UT015017: Error reading rewrite flags in line %s as %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteFlags(String line, String flags) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteFlags2$str(), line, flags));
        UndertowServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidRewriteFlags1$str() {
        return "UT015018: Error reading rewrite flags in line %s";
    }

    @Override
    public final IllegalArgumentException invalidRewriteFlags(String line) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRewriteFlags1$str(), line));
        UndertowServletLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToDestroy(Object object, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToDestroy$str(), object);
    }

    protected String failedToDestroy$str() {
        return "UT015019: Failed to destroy %s";
    }

    @Override
    public final void unsecuredMethodsOnPath(String path, Set<String> missing) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unsecuredMethodsOnPath$str(), (Object)path, missing);
    }

    protected String unsecuredMethodsOnPath$str() {
        return "UT015020: Path %s is secured for some HTTP methods, however it is not secured for %s";
    }

    @Override
    public final void failureDispatchingAsyncEvent(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failureDispatchingAsyncEvent$str(), new Object[0]);
    }

    protected String failureDispatchingAsyncEvent$str() {
        return "UT015021: Failure dispatching async event";
    }
}

