/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StaticFieldGetViaHandle;
import io.quarkus.gizmo2.impl.StaticFieldSet;
import io.quarkus.gizmo2.impl.StaticFieldSetViaHandle;
import java.lang.constant.ClassDesc;

public final class StaticFieldVarImpl
extends AssignableImpl
implements StaticFieldVar {
    private final FieldDesc desc;
    private final GenericType genericType;

    public StaticFieldVarImpl(FieldDesc desc, GenericType genericType) {
        this.desc = desc;
        this.genericType = genericType;
    }

    @Override
    public FieldDesc desc() {
        return this.desc;
    }

    @Override
    public ClassDesc type() {
        return this.desc.type();
    }

    @Override
    public GenericType genericType() {
        return this.genericType;
    }

    @Override
    public boolean bound() {
        return false;
    }

    @Override
    Item emitGet(BlockCreatorImpl block, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared -> this.asBound();
            default -> new StaticFieldGetViaHandle(this, mode);
        };
    }

    @Override
    Item emitSet(BlockCreatorImpl block, Item value, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared -> new StaticFieldSet(this, value);
            default -> new StaticFieldSetViaHandle(this, mode, value);
        };
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.getstatic(this.owner(), this.name(), this.type());
    }
}

