/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.GenericArrayTypeImpl;
import io.quarkus.arc.impl.ParameterizedTypeImpl;
import io.quarkus.arc.impl.TypeVariableImpl;
import io.quarkus.arc.impl.TypeVariableReferenceImpl;
import io.quarkus.arc.impl.WildcardTypeImpl;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.smallrye.common.annotation.SuppressForbidden;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class RuntimeTypeCreator {
    private final BlockCreator bc;
    private final IndexView index;
    private final Var cache;
    private final Var tccl;

    public static RuntimeTypeCreator of(BlockCreator bc) {
        Objects.requireNonNull(bc);
        return new RuntimeTypeCreator(bc, null, null, null);
    }

    public RuntimeTypeCreator withIndex(IndexView index) {
        Objects.requireNonNull(index);
        return new RuntimeTypeCreator(this.bc, index, this.cache, this.tccl);
    }

    public RuntimeTypeCreator withCache(Var cache) {
        Objects.requireNonNull(cache);
        return new RuntimeTypeCreator(this.bc, this.index, cache, this.tccl);
    }

    public RuntimeTypeCreator withTCCL(Var tccl) {
        Objects.requireNonNull(tccl);
        return new RuntimeTypeCreator(this.bc, this.index, this.cache, tccl);
    }

    private RuntimeTypeCreator(BlockCreator bc, IndexView index, Var cache, Var tccl) {
        this.bc = bc;
        this.index = index;
        this.cache = cache;
        this.tccl = tccl;
    }

    public LocalVar create(org.jboss.jandex.Type type) {
        Objects.requireNonNull(type);
        LocalVar result = this.bc.localVar("type", (Expr)Const.ofNull(Type.class));
        TypeVariables typeVariables = new TypeVariables();
        this.create(type, result, this.bc, typeVariables);
        typeVariables.patchTypeVariableReferences(this.bc);
        return result;
    }

    private void create(org.jboss.jandex.Type btType, LocalVar rtType, BlockCreator bc, TypeVariables typeVariables) {
        if (this.cache != null) {
            LocalVar rtCachedType = this.getFromCache(bc, btType);
            bc.ifElse(bc.eq((Expr)rtCachedType, (Expr)Const.ofNull(Type.class)), b1 -> this.doCreate(btType, rtType, (BlockCreator)b1, typeVariables), b1 -> b1.set((Assignable)rtType, (Expr)rtCachedType));
        } else {
            this.doCreate(btType, rtType, bc, typeVariables);
        }
    }

    private void doCreate(org.jboss.jandex.Type btType, LocalVar rtType, BlockCreator bc, TypeVariables typeVariables) {
        if (Type.Kind.VOID.equals((Object)btType.kind())) {
            bc.set((Assignable)rtType, Const.of(Void.TYPE));
        } else if (Type.Kind.PRIMITIVE.equals((Object)btType.kind())) {
            bc.set((Assignable)rtType, switch (btType.asPrimitiveType().primitive()) {
                default -> throw new IncompatibleClassChangeError();
                case PrimitiveType.Primitive.BOOLEAN -> Const.of(Boolean.TYPE);
                case PrimitiveType.Primitive.BYTE -> Const.of(Byte.TYPE);
                case PrimitiveType.Primitive.SHORT -> Const.of(Short.TYPE);
                case PrimitiveType.Primitive.INT -> Const.of(Integer.TYPE);
                case PrimitiveType.Primitive.LONG -> Const.of(Long.TYPE);
                case PrimitiveType.Primitive.FLOAT -> Const.of(Float.TYPE);
                case PrimitiveType.Primitive.DOUBLE -> Const.of(Double.TYPE);
                case PrimitiveType.Primitive.CHAR -> Const.of(Character.TYPE);
            });
        } else if (Type.Kind.CLASS.equals((Object)btType.kind())) {
            ClassType btClass = btType.asClassType();
            bc.set((Assignable)rtType, this.doLoadClass(btClass.name().toString(), bc));
            this.putToCache(bc, btType, rtType);
        } else if (Type.Kind.ARRAY.equals((Object)btType.kind())) {
            ArrayType btArray = btType.asArrayType();
            org.jboss.jandex.Type btElementType = btArray.elementType();
            if (btElementType.kind() == Type.Kind.PRIMITIVE || btElementType.kind() == Type.Kind.CLASS) {
                bc.set((Assignable)rtType, this.doLoadClass(btArray.name().toString(), bc));
            } else {
                org.jboss.jandex.Type btComponentType = btType.asArrayType().componentType();
                LocalVar rtComponentType = bc.localVar("component", (Expr)Const.ofNull(Type.class));
                this.create(btComponentType, rtComponentType, bc, typeVariables);
                bc.set((Assignable)rtType, bc.new_(ConstructorDesc.of(GenericArrayTypeImpl.class, (Class[])new Class[]{Type.class}), (Expr)rtComponentType));
            }
            this.putToCache(bc, btType, rtType);
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)btType.kind())) {
            ClassInfo btGenericClass;
            ParameterizedType btParamType = btType.asParameterizedType();
            LocalVar rtTypeArgs = bc.localVar("typeArgs", bc.newArray(Type.class, btParamType.arguments(), btTypeArg -> {
                LocalVar rtTypeArg = bc.localVar("typeArg", (Expr)Const.ofNull(Type.class));
                this.create((org.jboss.jandex.Type)btTypeArg, rtTypeArg, bc, typeVariables);
                return rtTypeArg;
            }));
            ClassType btGenericType = ClassType.create((DotName)btParamType.name());
            LocalVar rtGenericType = bc.localVar("genericType", this.doLoadClass(btGenericType.name().toString(), bc));
            LocalVar rtOwner = bc.localVar("owner", (Expr)Const.ofNull(Type.class));
            if (btParamType.owner() != null) {
                this.create(btParamType.owner(), rtOwner, bc, typeVariables);
            } else if (this.index != null && (btGenericClass = this.index.getClassByName(btParamType.name())) != null && btGenericClass.enclosingClass() != null) {
                ClassType btOwner = ClassType.create((DotName)btGenericClass.enclosingClass());
                this.create((org.jboss.jandex.Type)btOwner, rtOwner, bc, typeVariables);
            }
            bc.set((Assignable)rtType, bc.new_(ConstructorDesc.of(ParameterizedTypeImpl.class, (Class[])new Class[]{Type.class, Type[].class, Type.class}), new Expr[]{rtGenericType, rtTypeArgs, rtOwner}));
            this.putToCache(bc, (org.jboss.jandex.Type)btParamType, rtType);
        } else if (Type.Kind.TYPE_VARIABLE.equals((Object)btType.kind())) {
            TypeVariable btTypeVar = btType.asTypeVariable();
            String btIdentifier = btTypeVar.identifier();
            LocalVar rtTypeVar = typeVariables.getTypeVariable(btIdentifier);
            if (rtTypeVar == null) {
                bc.set((Assignable)rtType, bc.new_(ConstructorDesc.of(TypeVariableImpl.class, (Class[])new Class[]{String.class, Type[].class}), (Expr)Const.of((String)btIdentifier), bc.newArray(Type.class, btTypeVar.bounds(), btBound -> {
                    LocalVar rtBound = bc.localVar("bound", (Expr)Const.ofNull(Type.class));
                    this.create((org.jboss.jandex.Type)btBound, rtBound, bc, typeVariables);
                    return rtBound;
                })));
                typeVariables.setTypeVariable(btIdentifier, rtType);
                this.putToCache(bc, (org.jboss.jandex.Type)btTypeVar, rtType);
            } else {
                bc.set((Assignable)rtType, (Expr)rtTypeVar);
            }
        } else if (Type.Kind.TYPE_VARIABLE_REFERENCE.equals((Object)btType.kind())) {
            String btIdentifier = btType.asTypeVariableReference().identifier();
            LocalVar rtTypeVarRef = typeVariables.getTypeVariableReference(btIdentifier);
            if (rtTypeVarRef == null) {
                bc.set((Assignable)rtType, bc.new_(ConstructorDesc.of(TypeVariableReferenceImpl.class, (Class[])new Class[]{String.class}), (Expr)Const.of((String)btIdentifier)));
                typeVariables.setTypeVariableReference(btIdentifier, rtType);
            } else {
                bc.set((Assignable)rtType, (Expr)rtTypeVarRef);
            }
        } else if (Type.Kind.WILDCARD_TYPE.equals((Object)btType.kind())) {
            org.jboss.jandex.WildcardType btWildcard = btType.asWildcardType();
            if (btWildcard.superBound() == null) {
                org.jboss.jandex.Type btUpperBound = btWildcard.extendsBound();
                LocalVar rtUpperBound = bc.localVar("upperBound", (Expr)Const.ofNull(Type.class));
                this.create(btUpperBound, rtUpperBound, bc, typeVariables);
                bc.set((Assignable)rtType, bc.invokeStatic(MethodDesc.of(WildcardTypeImpl.class, (String)"withUpperBound", WildcardType.class, (Class[])new Class[]{Type.class}), (Expr)rtUpperBound));
            } else {
                org.jboss.jandex.Type btLowerBound = btWildcard.superBound();
                LocalVar rtLowerBound = bc.localVar("lowerBound", (Expr)Const.ofNull(Type.class));
                this.create(btLowerBound, rtLowerBound, bc, typeVariables);
                bc.set((Assignable)rtType, bc.invokeStatic(MethodDesc.of(WildcardTypeImpl.class, (String)"withLowerBound", WildcardType.class, (Class[])new Class[]{Type.class}), (Expr)rtLowerBound));
            }
            this.putToCache(bc, (org.jboss.jandex.Type)btWildcard, rtType);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(btType.kind()) + ", " + String.valueOf(btType));
        }
    }

    @SuppressForbidden(reason="Using Type.toString() to build a cache key")
    private LocalVar getFromCache(BlockCreator bc, org.jboss.jandex.Type type) {
        if (this.cache == null) {
            return null;
        }
        return bc.localVar("cachedType", Type.class, bc.withMap((Expr)this.cache).get((Expr)Const.of((String)(String.valueOf(type.kind()) + ":" + String.valueOf(type)))));
    }

    @SuppressForbidden(reason="Using Type.toString() to build a cache key")
    private void putToCache(BlockCreator bc, org.jboss.jandex.Type type, LocalVar value) {
        if (this.cache == null) {
            return;
        }
        bc.withMap((Expr)this.cache).put((Expr)Const.of((String)(String.valueOf(type.kind()) + ":" + String.valueOf(type))), (Expr)value);
    }

    private Expr doLoadClass(String className, BlockCreator bc) {
        if (className.startsWith("java.")) {
            return Const.of((ClassDesc)ClassDesc.of(className));
        }
        Var cl = this.tccl != null ? this.tccl : bc.invokeVirtual(MethodDescs.THREAD_GET_TCCL, bc.currentThread());
        return bc.invokeStatic(MethodDescs.CL_FOR_NAME, new Expr[]{Const.of((String)className), Const.of((boolean)false), cl});
    }

    private static final class TypeVariables {
        private final Map<String, LocalVar> typeVariables = new HashMap<String, LocalVar>();
        private final Map<String, LocalVar> typeVariableReferences = new HashMap<String, LocalVar>();

        private TypeVariables() {
        }

        LocalVar getTypeVariable(String identifier) {
            return this.typeVariables.get(identifier);
        }

        void setTypeVariable(String identifier, LocalVar localVar) {
            this.typeVariables.put(identifier, localVar);
        }

        LocalVar getTypeVariableReference(String identifier) {
            return this.typeVariableReferences.get(identifier);
        }

        void setTypeVariableReference(String identifier, LocalVar localVar) {
            this.typeVariableReferences.put(identifier, localVar);
        }

        void patchTypeVariableReferences(BlockCreator bc) {
            this.typeVariableReferences.forEach((identifier, reference) -> {
                LocalVar typeVar = this.typeVariables.get(identifier);
                if (typeVar != null) {
                    bc.invokeVirtual(MethodDesc.of(TypeVariableReferenceImpl.class, (String)"setDelegate", Void.TYPE, (Class[])new Class[]{TypeVariableImpl.class}), (Expr)reference, (Expr)typeVar);
                }
            });
        }
    }
}

