/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.InactiveBeanException;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableDecorator;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.DecoratorDelegateProvider;
import io.quarkus.arc.impl.InitializedInterceptor;
import io.quarkus.arc.impl.SyntheticCreationalContextImpl;
import io.quarkus.arc.impl.UncaughtExceptions;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DecoratorGenerator;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescs;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.RuntimeTypeCreator;
import io.quarkus.arc.processor.SubclassGenerator;
import io.quarkus.arc.processor.SyntheticComponentsUtil;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Reflection2Gizmo;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.ModifierFlag;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.IllegalProductException;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.literal.InjectLiteral;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.jandex.gizmo2.StringBuilderGen;
import org.jboss.logging.Logger;

public class BeanGenerator
extends AbstractGenerator {
    static final String BEAN_SUFFIX = "_Bean";
    static final String PRODUCER_METHOD_SUFFIX = "_ProducerMethod";
    static final String PRODUCER_FIELD_SUFFIX = "_ProducerField";
    protected static final String FIELD_NAME_DECLARING_PROVIDER_SUPPLIER = "declaringProviderSupplier";
    protected static final String FIELD_NAME_BEAN_TYPES = "types";
    protected static final String FIELD_NAME_QUALIFIERS = "qualifiers";
    protected static final String FIELD_NAME_STEREOTYPES = "stereotypes";
    protected static final String FIELD_NAME_PROXY = "proxy";
    protected final AnnotationLiteralProcessor annotationLiterals;
    protected final Predicate<DotName> applicationClassPredicate;
    protected final BeanProcessor.PrivateMembersCollector privateMembers;
    protected final Set<String> existingClasses;
    protected final Map<BeanInfo, String> beanToGeneratedName;
    protected final Map<BeanInfo, String> beanToGeneratedBaseName;
    protected final Predicate<DotName> injectionPointAnnotationsPredicate;
    protected final List<Function<BeanInfo, Consumer<BlockCreator>>> suppressConditionGenerators;

    public BeanGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate, List<Function<BeanInfo, Consumer<BlockCreator>>> suppressConditionGenerators) {
        super(generateSources, reflectionRegistration);
        this.annotationLiterals = annotationLiterals;
        this.applicationClassPredicate = applicationClassPredicate;
        this.privateMembers = privateMembers;
        this.existingClasses = existingClasses;
        this.beanToGeneratedName = beanToGeneratedName;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        this.suppressConditionGenerators = suppressConditionGenerators;
        this.beanToGeneratedBaseName = new HashMap<BeanInfo, String>();
    }

    void precomputeGeneratedName(BeanInfo bean) {
        if (bean.isClassBean()) {
            this.generateClassBeanName(bean);
        } else if (bean.isProducerMethod()) {
            this.generateProducerMethodBeanName(bean);
        } else if (bean.isProducerField()) {
            this.generateProducerFieldBeanName(bean);
        } else if (bean.isSynthetic()) {
            this.generateSyntheticBeanName(bean);
        }
    }

    private void generateClassBeanName(BeanInfo bean) {
        ClassInfo beanClass = bean.getTarget().get().asClass();
        String baseName = beanClass.name().withoutPackagePrefix();
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = DotNames.packagePrefix(bean.getProviderType().name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
    }

    private void generateProducerMethodBeanName(BeanInfo bean) {
        MethodInfo producerMethod = bean.getTarget().get().asMethod();
        ClassInfo declaringClass = producerMethod.declaringClass();
        String declaringClassBase = declaringClass.name().withoutPackagePrefix();
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(producerMethod.name()).append("_").append(producerMethod.returnType().name());
        for (org.jboss.jandex.Type parameterType : producerMethod.parameterTypes()) {
            sigBuilder.append(parameterType.name());
        }
        String baseName = declaringClassBase + "_ProducerMethod_" + producerMethod.name() + "_" + Hashes.sha1_base64(sigBuilder.toString());
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = DotNames.packagePrefix(declaringClass.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
    }

    private void generateProducerFieldBeanName(BeanInfo bean) {
        FieldInfo producerField = bean.getTarget().get().asField();
        ClassInfo declaringClass = producerField.declaringClass();
        String declaringClassBase = declaringClass.name().withoutPackagePrefix();
        String baseName = declaringClassBase + "_ProducerField_" + producerField.name();
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = DotNames.packagePrefix(declaringClass.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
    }

    private void generateSyntheticBeanName(BeanInfo bean) {
        String baseName = bean.getImplClazz().name().withoutPackagePrefix() + "_" + bean.getIdentifier() + "_Synthetic";
        this.beanToGeneratedBaseName.put(bean, baseName);
        String targetPackage = bean.getTargetPackageName();
        this.beanToGeneratedName.put(bean, BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX));
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean) {
        ClassInfo clazz;
        if (bean.isClassBean()) {
            clazz = bean.getTarget().get().asClass();
        } else if (bean.isProducerMethod()) {
            clazz = bean.getTarget().get().asMethod().declaringClass();
        } else if (bean.isProducerField()) {
            clazz = bean.getTarget().get().asField().declaringClass();
        } else if (bean.isSynthetic()) {
            clazz = bean.getImplClazz();
        } else {
            throw new IllegalArgumentException("Unknown bean type: " + String.valueOf(bean));
        }
        ProviderType providerType = new ProviderType(bean.getProviderType());
        String baseName = this.beanToGeneratedBaseName.get(bean);
        String targetPackage = bean.isSynthetic() ? bean.getTargetPackageName() : DotNames.packagePrefix(bean.isProducer() ? clazz.name() : providerType.name());
        String generatedName = this.beanToGeneratedName.get(bean);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(clazz.name()) || bean.isForceApplicationClass() || bean.hasBoundDecoratorWhichIsApplicationClass(this.applicationClassPredicate);
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        Gizmo gizmo = BeanGenerator.gizmo(classOutput);
        this.generateBean(gizmo, bean, generatedName, baseName, targetPackage, isApplicationClass, providerType);
        return classOutput.getResources();
    }

    private void generateBean(Gizmo gizmo, BeanInfo bean, String generatedName, String baseName, String targetPackage, boolean isApplicationClass, ProviderType providerType) {
        gizmo.class_(generatedName, cc -> {
            cc.implements_(InjectableBean.class);
            cc.implements_(Supplier.class);
            FieldDesc beanTypesField = cc.field(FIELD_NAME_BEAN_TYPES, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Set.class);
            });
            FieldDesc qualifiersField = null;
            if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
                qualifiersField = cc.field(FIELD_NAME_QUALIFIERS, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Set.class);
                });
            }
            FieldDesc stereotypesField = null;
            if (!bean.getStereotypes().isEmpty()) {
                stereotypesField = cc.field(FIELD_NAME_STEREOTYPES, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Set.class);
                });
            }
            FieldDesc declaringProviderSupplierField = null;
            if (bean.isProducer()) {
                declaringProviderSupplierField = cc.field(FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Supplier.class);
                });
            }
            if (bean.getScope().isNormal()) {
                this.generateProxy((ClassCreator)cc, bean, baseName);
            }
            HashMap<InjectionPointInfo, FieldDesc> injectionPointToProviderSupplierField = new HashMap<InjectionPointInfo, FieldDesc>();
            HashMap<InterceptorInfo, FieldDesc> interceptorToProviderSupplierField = new HashMap<InterceptorInfo, FieldDesc>();
            HashMap<DecoratorInfo, FieldDesc> decoratorToProviderSupplierField = new HashMap<DecoratorInfo, FieldDesc>();
            this.generateProviderFields(bean, (ClassCreator)cc, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderSupplierField, (Map<InterceptorInfo, FieldDesc>)interceptorToProviderSupplierField, (Map<DecoratorInfo, FieldDesc>)decoratorToProviderSupplierField);
            this.generateConstructor((ClassCreator)cc, bean, beanTypesField, qualifiersField, stereotypesField, declaringProviderSupplierField, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderSupplierField, (Map<InterceptorInfo, FieldDesc>)interceptorToProviderSupplierField, (Map<DecoratorInfo, FieldDesc>)decoratorToProviderSupplierField, bean.isSynthetic() ? bc -> SyntheticComponentsUtil.addParamsFieldAndInit(cc, bc, bean.getParams(), this.annotationLiterals, bean.getDeployment().getBeanArchiveIndex()) : bc -> {});
            this.generateCreate((ClassCreator)cc, bean, providerType, baseName, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderSupplierField, (Map<InterceptorInfo, FieldDesc>)interceptorToProviderSupplierField, (Map<DecoratorInfo, FieldDesc>)decoratorToProviderSupplierField, targetPackage, isApplicationClass);
            if (bean.hasDestroyLogic()) {
                this.generateDestroy((ClassCreator)cc, bean, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderSupplierField, isApplicationClass, baseName, targetPackage);
            }
            this.generateSupplierGet((ClassCreator)cc);
            this.generateInjectableReferenceProviderGet(bean, (ClassCreator)cc, baseName);
            this.generateGetIdentifier((ClassCreator)cc, bean);
            this.generateGetTypes(beanTypesField, (ClassCreator)cc);
            if (!BuiltinScope.isDefault(bean.getScope())) {
                this.generateGetScope((ClassCreator)cc, bean);
            }
            if (qualifiersField != null) {
                this.generateGetQualifiers((ClassCreator)cc, qualifiersField);
            }
            this.generateIsAlternative((ClassCreator)cc, bean);
            this.generateGetPriority((ClassCreator)cc, bean);
            if (bean.isProducer()) {
                this.generateGetDeclaringBean((ClassCreator)cc, declaringProviderSupplierField);
            }
            if (stereotypesField != null) {
                this.generateGetStereotypes((ClassCreator)cc, stereotypesField);
            }
            this.generateGetBeanClass((ClassCreator)cc, bean);
            if (bean.isProducer() || bean.isSynthetic()) {
                this.generateGetImplementationClass((ClassCreator)cc, bean);
            }
            this.generateGetName((ClassCreator)cc, bean);
            if (bean.isDefaultBean()) {
                this.generateIsDefaultBean((ClassCreator)cc, bean);
            }
            this.generateGetKind((ClassCreator)cc, bean);
            this.generateIsSuppressed((ClassCreator)cc, bean);
            this.generateGetInjectionPoints((ClassCreator)cc, bean);
            this.generateEquals((ClassCreator)cc, bean);
            this.generateHashCode((ClassCreator)cc, bean);
            this.generateToString((ClassCreator)cc);
        });
    }

    private void generateProxy(ClassCreator cc, BeanInfo bean, String baseName) {
        if (bean.getDeployment().hasRuntimeDeferredUnproxyableError(bean)) {
            return;
        }
        ClassDesc proxyType = this.getClientProxyType(bean, baseName);
        FieldDesc proxyField = cc.field(FIELD_NAME_PROXY, fc -> {
            fc.private_();
            fc.volatile_();
            fc.setType(proxyType);
        });
        cc.method(FIELD_NAME_PROXY, mc -> {
            mc.private_();
            mc.returning(proxyType);
            mc.body(b0 -> {
                LocalVar proxy = b0.localVar(FIELD_NAME_PROXY, (Expr)cc.this_().field(proxyField));
                b0.ifNull((Expr)proxy, b1 -> {
                    b1.set((Assignable)proxy, b1.new_(proxyType, (Expr)Const.of((String)bean.getIdentifier())));
                    b1.set((Assignable)cc.this_().field(proxyField), (Expr)proxy);
                });
                b0.return_((Expr)proxy);
            });
        });
    }

    protected void generateProviderFields(BeanInfo bean, ClassCreator cc, Map<InjectionPointInfo, FieldDesc> injectionPointToProvider, Map<InterceptorInfo, FieldDesc> interceptorToProvider, Map<DecoratorInfo, FieldDesc> decoratorToProvider) {
        FieldDesc field;
        int providerIdx = 1;
        for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
            field = cc.field("injectProviderSupplier" + providerIdx++, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Supplier.class);
            });
            injectionPointToProvider.put(injectionPoint, field);
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                field = cc.field("disposerProviderSupplier" + providerIdx++, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Supplier.class);
                });
                injectionPointToProvider.put(injectionPoint, field);
            }
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            field = cc.field("interceptorProviderSupplier" + providerIdx++, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Supplier.class);
            });
            interceptorToProvider.put(interceptor, field);
        }
        for (DecoratorInfo decorator : bean.getBoundDecorators()) {
            field = cc.field("decoratorProviderSupplier" + providerIdx++, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Supplier.class);
            });
            decoratorToProvider.put(decorator, field);
        }
    }

    protected void generateConstructor(ClassCreator cc, BeanInfo bean, FieldDesc beanTypesField, FieldDesc qualifiersField, FieldDesc stereotypesField, FieldDesc declaringProviderSupplierField, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, Map<InterceptorInfo, FieldDesc> interceptorToProviderField, Map<DecoratorInfo, FieldDesc> decoratorToProviderSupplierField, Consumer<BlockCreator> additionalCode) {
        cc.constructor(mc -> {
            int i;
            ArrayList<ParamVar> params = new ArrayList<ParamVar>();
            if (bean.isProducer()) {
                params.add(mc.parameter("declaringBean", Reflection2Gizmo.classDescOf(Supplier.class)));
            }
            int ipIdx = 0;
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                if (injectionPoint.isDelegate() || BuiltinBean.resolve(injectionPoint) != null) continue;
                params.add(mc.parameter("injectionPoint" + ipIdx++, Reflection2Gizmo.classDescOf(Supplier.class)));
            }
            if (bean.getDisposer() != null) {
                ipIdx = 0;
                for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                    if (BuiltinBean.resolve(injectionPoint) != null) continue;
                    params.add(mc.parameter("disposerInjectionPoint" + ipIdx++, Supplier.class));
                }
            }
            for (i = 0; i < interceptorToProviderField.size(); ++i) {
                params.add(mc.parameter("interceptorProvider" + i, Supplier.class));
            }
            for (i = 0; i < decoratorToProviderSupplierField.size(); ++i) {
                params.add(mc.parameter("decoratorProvider" + i, Supplier.class));
            }
            mc.body(bc -> {
                bc.invokeSpecial(MethodDescs.OBJECT_CONSTRUCTOR, (Expr)cc.this_());
                LocalVar tccl = bc.localVar("tccl", bc.invokeVirtual(MethodDescs.THREAD_GET_TCCL, bc.currentThread()));
                RuntimeTypeCreator rttc = RuntimeTypeCreator.of(bc).withTCCL((Var)tccl);
                Expr typesArray = bc.newArray(Object.class, bean.getTypes().stream().map(type -> {
                    try {
                        return rttc.create((org.jboss.jandex.Type)type);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Unable to construct type for " + String.valueOf(bean) + ": " + e.getMessage());
                    }
                }).toList());
                bc.set((Assignable)cc.this_().field(beanTypesField), bc.invokeStatic(MethodDescs.SETS_OF, typesArray));
                if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
                    Expr qualifiersArray = bc.newArray(Object.class, bean.getQualifiers().stream().map(qualifier -> {
                        BuiltinQualifier builtinQualifier = BuiltinQualifier.of(qualifier);
                        if (builtinQualifier != null) {
                            return builtinQualifier.getLiteralInstance();
                        }
                        ClassInfo qualifierClass = bean.getDeployment().getQualifier(qualifier.name());
                        return this.annotationLiterals.create((BlockCreator)bc, qualifierClass, (AnnotationInstance)qualifier);
                    }).toList());
                    bc.set((Assignable)cc.this_().field(qualifiersField), bc.invokeStatic(MethodDescs.SETS_OF, qualifiersArray));
                }
                if (!bean.getStereotypes().isEmpty()) {
                    Expr stereotypesArray = bc.newArray(Object.class, bean.getStereotypes().stream().map(stereotype -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)stereotype.getTarget()))).toList());
                    bc.set((Assignable)cc.this_().field(stereotypesField), bc.invokeStatic(MethodDescs.SETS_OF, stereotypesArray));
                }
                int paramIdx = 0;
                if (bean.isProducer()) {
                    bc.set((Assignable)cc.this_().field(declaringProviderSupplierField), (Expr)params.get(paramIdx++));
                }
                ArrayList<InjectionPointInfo> allInjectionPoints = new ArrayList<InjectionPointInfo>(bean.getAllInjectionPoints());
                if (bean.getDisposer() != null) {
                    allInjectionPoints.addAll(bean.getDisposer().getInjection().injectionPoints);
                }
                for (InjectionPointInfo injectionPoint : allInjectionPoints) {
                    if (injectionPoint.isDelegate()) {
                        Expr delegateProvider = bc.new_(DecoratorDelegateProvider.class);
                        Expr delegateProviderSupplier = bc.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, delegateProvider);
                        bc.set((Assignable)cc.this_().field((FieldDesc)injectionPointToProviderField.get(injectionPoint)), delegateProviderSupplier);
                        continue;
                    }
                    if (injectionPoint.getResolvedBean() == null) {
                        BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
                        builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(bean.getDeployment(), bean, injectionPoint, cc, (BlockCreator)bc, (FieldDesc)injectionPointToProviderField.get(injectionPoint), this.annotationLiterals, this.reflectionRegistration, this.injectionPointAnnotationsPredicate, null));
                        continue;
                    }
                    if (injectionPoint.isCurrentInjectionPointWrapperNeeded()) {
                        Expr wrap = BeanGenerator.wrapCurrentInjectionPoint(bean, bc, injectionPoint, (Expr)cc.this_(), (Expr)params.get(paramIdx++), tccl, this.annotationLiterals, this.reflectionRegistration, this.injectionPointAnnotationsPredicate);
                        Expr wrapSupplier = bc.new_(MethodDescs.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, wrap);
                        bc.set((Assignable)cc.this_().field((FieldDesc)injectionPointToProviderField.get(injectionPoint)), wrapSupplier);
                        continue;
                    }
                    bc.set((Assignable)cc.this_().field((FieldDesc)injectionPointToProviderField.get(injectionPoint)), (Expr)params.get(paramIdx++));
                }
                for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                    bc.set((Assignable)cc.this_().field((FieldDesc)interceptorToProviderField.get(interceptor)), (Expr)params.get(paramIdx++));
                }
                for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                    bc.set((Assignable)cc.this_().field((FieldDesc)decoratorToProviderSupplierField.get(decorator)), (Expr)params.get(paramIdx++));
                }
                additionalCode.accept((BlockCreator)bc);
                bc.return_();
            });
        });
    }

    protected void generateCreate(ClassCreator cc, BeanInfo bean, ProviderType providerType, String baseName, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderSupplierField, Map<InterceptorInfo, FieldDesc> interceptorToProviderSupplierField, Map<DecoratorInfo, FieldDesc> decoratorToProviderSupplierField, String targetPackage, boolean isApplicationClass) {
        MethodDesc createDesc = cc.method("create", mc -> {
            mc.returning(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)bean.getProviderType()));
            ParamVar ccParam = mc.parameter("creationalContext", CreationalContext.class);
            mc.body(b0 -> b0.try_(tc -> {
                tc.body(b1 -> {
                    if (bean.isClassBean()) {
                        this.generateCreateForClassBean(cc, bean, providerType, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, targetPackage, isApplicationClass, (BlockCreator)b1, ccParam);
                    } else if (bean.isProducerMethod()) {
                        this.generateCreateForProducerMethod(cc, bean, injectionPointToProviderSupplierField, isApplicationClass, (BlockCreator)b1, ccParam);
                    } else if (bean.isProducerField()) {
                        this.generateCreateForProducerField(cc, bean, isApplicationClass, (BlockCreator)b1);
                    } else if (bean.isSynthetic()) {
                        this.generateCreateForSyntheticBean(cc, bean, injectionPointToProviderSupplierField, (BlockCreator)b1, ccParam);
                    }
                });
                tc.catch_(Exception.class, "e", (b1, e) -> {
                    b1.ifInstanceOf((Expr)e, RuntimeException.class, BlockCreator::throw_);
                    b1.throw_(b1.new_(ConstructorDesc.of(CreationException.class, (Class[])new Class[]{Throwable.class}), (Expr)e));
                });
            }));
        });
        if (!ClassType.OBJECT_TYPE.equals((Object)bean.getProviderType())) {
            cc.method("create", mc -> {
                mc.addFlag(ModifierFlag.BRIDGE);
                mc.returning(Object.class);
                ParamVar ccParam = mc.parameter("creationalContext", CreationalContext.class);
                mc.body(bc -> bc.return_(bc.invokeVirtual(createDesc, (Expr)cc.this_(), (Expr)ccParam)));
            });
        }
    }

    private void generateCreateForClassBean(ClassCreator cc, final BeanInfo bean, ProviderType providerType, String baseName, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderSupplierField, Map<InterceptorInfo, FieldDesc> interceptorToProviderSupplierField, Map<DecoratorInfo, FieldDesc> decoratorToProviderSupplierField, final String targetPackage, final boolean isApplicationClass, BlockCreator bc, ParamVar parentCC) {
        class PostConstructGenerator {
            PostConstructGenerator() {
            }

            void generate(BlockCreator bc, Var instance) {
                if (!bean.isInterceptor()) {
                    List<MethodInfo> postConstructCallbacks = Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.POST_CONSTRUCT, bean.getDeployment().getBeanArchiveIndex());
                    for (MethodInfo callback : postConstructCallbacks) {
                        if (BeanGenerator.this.isReflectionFallbackNeeded(callback, targetPackage)) {
                            if (Modifier.isPrivate(callback.flags())) {
                                BeanGenerator.this.privateMembers.add(isApplicationClass, String.format("@PostConstruct callback %s#%s()", callback.declaringClass().name(), callback.name()));
                            }
                            BeanGenerator.this.reflectionRegistration.registerMethod(callback);
                            bc.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)callback.declaringClass())), Const.of((String)callback.name()), bc.newEmptyArray(Class.class, 0), instance, bc.newEmptyArray(Object.class, 0)});
                            continue;
                        }
                        bc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)callback), (Expr)instance);
                    }
                }
            }
        }
        LocalVar instance;
        ArrayList<TransientReference> transientReferences;
        BeanInfo.InterceptionInfo postConstructInterception = bean.getLifecycleInterceptors(InterceptionType.POST_CONSTRUCT);
        BeanInfo.InterceptionInfo aroundConstructInterception = bean.getLifecycleInterceptors(InterceptionType.AROUND_CONSTRUCT);
        LocalVar aroundConstructs = null;
        LocalVar postConstructs = null;
        HashMap<InterceptorInfo, LocalVar> interceptorToWrap = new HashMap<InterceptorInfo, LocalVar>();
        if (bean.hasLifecycleInterceptors()) {
            Expr interceptorInstance;
            InstanceFieldVar interceptorSupplier;
            HashSet<InterceptorInfo> wraps = new HashSet<InterceptorInfo>();
            wraps.addAll(aroundConstructInterception.interceptors);
            wraps.addAll(postConstructInterception.interceptors);
            HashMap<InterceptorInfo, LocalVar> interceptorVars = new HashMap<InterceptorInfo, LocalVar>();
            for (InterceptorInfo interceptor : wraps) {
                InstanceFieldVar interceptorProviderSupplier = cc.this_().field(interceptorToProviderSupplierField.get(interceptor));
                LocalVar interceptorProvider = bc.localVar("interceptorProvider", bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)interceptorProviderSupplier));
                Expr childCC = bc.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD, (Expr)parentCC);
                LocalVar interceptorInstance2 = bc.localVar("interceptorInstance", bc.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)interceptorProvider, childCC));
                interceptorVars.put(interceptor, interceptorInstance2);
                LocalVar wrap = bc.localVar("wrap", bc.invokeStatic(MethodDesc.of(InitializedInterceptor.class, (String)"of", InitializedInterceptor.class, (Class[])new Class[]{Object.class, InjectableInterceptor.class}), (Expr)interceptorInstance2, (Expr)interceptorProvider));
                interceptorToWrap.put(interceptor, wrap);
            }
            if (!aroundConstructInterception.isEmpty()) {
                aroundConstructs = bc.localVar("aroundConstructs", bc.new_(ArrayList.class));
                for (InterceptorInfo interceptor : aroundConstructInterception.interceptors) {
                    interceptorSupplier = cc.this_().field(interceptorToProviderSupplierField.get(interceptor));
                    interceptorInstance = bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)interceptorSupplier);
                    Expr interceptorInvocationHandle = bc.invokeStatic(MethodDescs.INTERCEPTOR_INVOCATION_AROUND_CONSTRUCT, interceptorInstance, (Expr)interceptorVars.get(interceptor));
                    bc.withList((Expr)aroundConstructs).add(interceptorInvocationHandle);
                }
            }
            if (!postConstructInterception.isEmpty()) {
                postConstructs = bc.localVar("postConstructs", bc.new_(ArrayList.class));
                for (InterceptorInfo interceptor : postConstructInterception.interceptors) {
                    interceptorSupplier = cc.this_().field(interceptorToProviderSupplierField.get(interceptor));
                    interceptorInstance = bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)interceptorSupplier);
                    Expr interceptorInvocation = bc.invokeStatic(MethodDescs.INTERCEPTOR_INVOCATION_POST_CONSTRUCT, interceptorInstance, (Expr)interceptorVars.get(interceptor));
                    bc.withList((Expr)postConstructs).add(interceptorInvocation);
                }
            }
        }
        if (!aroundConstructInterception.isEmpty()) {
            LocalVar constructor;
            Optional<Injection> constructorInjection = bean.getConstructorInjection();
            if (constructorInjection.isPresent()) {
                ArrayList<ClassDesc> paramTypes = new ArrayList<ClassDesc>();
                for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                    paramTypes.add(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)injectionPoint.getType()));
                }
                constructor = bc.localVar("constructor", bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_CONSTRUCTOR, (Expr)Const.of((ClassDesc)providerType.classDesc()), bc.newArray(Class.class, paramTypes.stream().map(Const::of).toList())));
                this.reflectionRegistration.registerMethod(constructorInjection.get().target.asMethod());
            } else {
                constructor = bc.localVar("constructor", bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_CONSTRUCTOR, (Expr)Const.of((ClassDesc)providerType.classDesc()), bc.newEmptyArray(Class.class, 0)));
                MethodInfo noArgsConstructor = bean.getTarget().get().asClass().method("<init>", new org.jboss.jandex.Type[0]);
                this.reflectionRegistration.registerMethod(noArgsConstructor);
            }
            transientReferences = new ArrayList<TransientReference>();
            ArrayList<Var> injectableCtorParams = new ArrayList<Var>();
            ArrayList<Var> allOtherCtorParams = new ArrayList<Var>();
            this.newProviders(bean, cc, bc, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, interceptorToWrap, transientReferences, injectableCtorParams, allOtherCtorParams, parentCC);
            LocalVar func = bc.localVar("func", bc.lambda(Function.class, lc -> {
                ArrayList<Var> capturedAllOtherCtorParams = new ArrayList<Var>();
                for (int i = 0; i < allOtherCtorParams.size(); ++i) {
                    Var param = (Var)allOtherCtorParams.get(i);
                    capturedAllOtherCtorParams.add(lc.capture(param.name() + i, (Expr)param));
                }
                Var capturedParentCC = lc.capture((Var)parentCC);
                List<TransientReference> capturedTransientReferences = transientReferences.stream().map(it -> new TransientReference(lc.capture(it.provider), lc.capture(it.instance), lc.capture(it.creationalContext))).toList();
                ParamVar params = lc.parameter("params", 0);
                lc.body(lbc -> {
                    ArrayList<LocalVar> args = new ArrayList<LocalVar>();
                    if (!injectableCtorParams.isEmpty()) {
                        LocalVar paramsArray = lbc.localVar("params", lbc.cast((Expr)params, Object[].class));
                        for (int i = 0; i < injectableCtorParams.size(); ++i) {
                            args.add(lbc.localVar("arg" + i, (Expr)paramsArray.elem(i)));
                        }
                    }
                    ArrayList<Var> providers = new ArrayList<Var>(args);
                    providers.addAll(capturedAllOtherCtorParams);
                    LocalVar result = lbc.localVar("result", this.newBeanInstance(bean, (BlockCreator)lbc, providerType, baseName, (List<Var>)providers, isApplicationClass, capturedParentCC));
                    BeanGenerator.destroyTransientReferences(lbc, capturedTransientReferences);
                    lbc.return_((Expr)result);
                });
            }));
            LocalVar bindingsArray = bc.localVar("bindings", bc.newEmptyArray(Object.class, aroundConstructInterception.bindings.size()));
            int bindingsIndex = 0;
            for (AnnotationInstance binding : aroundConstructInterception.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                bc.set(bindingsArray.elem(bindingsIndex++), this.annotationLiterals.create(bc, bindingClass, binding));
            }
            LocalVar ctorArgsArray = bc.localVar("ctorArgs", bc.newArray(Object.class, injectableCtorParams));
            LocalVar invocationContext = bc.localVar("invocationContext", bc.invokeStatic(MethodDescs.INVOCATION_CONTEXTS_AROUND_CONSTRUCT, new Expr[]{constructor, ctorArgsArray, aroundConstructs, func, bc.invokeStatic(MethodDescs.SETS_OF, (Expr)bindingsArray)}));
            instance = bc.localVar("instance", (Expr)Const.ofNull((ClassDesc)providerType.classDesc()));
            bc.try_(tc -> {
                tc.body(b1 -> {
                    b1.invokeInterface(MethodDescs.INVOCATION_CONTEXT_PROCEED, (Expr)invocationContext);
                    b1.set((Assignable)instance, b1.invokeInterface(MethodDescs.INVOCATION_CONTEXT_GET_TARGET, (Expr)invocationContext));
                });
                tc.catch_(Exception.class, "e", (b1, e) -> {
                    b1.ifInstanceOf((Expr)e, RuntimeException.class, BlockCreator::throw_);
                    b1.throw_(b1.new_(ConstructorDesc.of(RuntimeException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)"Error invoking aroundConstructs"), (Expr)e));
                });
            });
        } else {
            ArrayList<TransientReference> transientReferences2 = new ArrayList<TransientReference>();
            ArrayList<Var> providers = new ArrayList<Var>();
            this.newProviders(bean, cc, bc, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, decoratorToProviderSupplierField, interceptorToWrap, transientReferences2, providers, providers, parentCC);
            instance = bc.localVar("instance", this.newBeanInstance(bean, bc, providerType, baseName, providers, isApplicationClass, (Var)parentCC));
            BeanGenerator.destroyTransientReferences(bc, transientReferences2);
        }
        for (Injection injection : bean.getInjections()) {
            if (injection.isField()) {
                bc.try_(tc -> {
                    tc.body(b1 -> {
                        InjectionPointInfo injectionPoint = injection.injectionPoints.get(0);
                        InstanceFieldVar providerSupplier = cc.this_().field((FieldDesc)injectionPointToProviderSupplierField.get(injectionPoint));
                        LocalVar provider = b1.localVar("provider", b1.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)providerSupplier));
                        Expr childCC = b1.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)provider, (Expr)parentCC);
                        LocalVar injectedReference = b1.localVar("injectedReference", b1.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)provider, childCC));
                        BeanGenerator.checkPrimitiveInjection(b1, injectionPoint, injectedReference);
                        FieldInfo injectedField = injection.target.asField();
                        if (this.isReflectionFallbackNeeded(injectedField, targetPackage, bean)) {
                            if (Modifier.isPrivate(injectedField.flags())) {
                                this.privateMembers.add(isApplicationClass, String.format("@Inject field %s#%s", injection.target.asField().declaringClass().name(), injection.target.asField().name()));
                            }
                            this.reflectionRegistration.registerField(injectedField);
                            b1.invokeStatic(MethodDescs.REFLECTIONS_WRITE_FIELD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)injectedField.declaringClass())), Const.of((String)injectedField.name()), instance, injectedReference});
                        } else {
                            org.jboss.jandex.Type ipType = injectionPoint.getAnnotationTarget().asField().type();
                            b1.set((Assignable)instance.field(FieldDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)injectedField.declaringClass()), (String)injectedField.name(), (ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)ipType))), (Expr)injectedReference);
                        }
                    });
                    tc.catch_(RuntimeException.class, "e", (b1, e) -> b1.throw_(b1.new_(ConstructorDesc.of(RuntimeException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)("Error injecting " + String.valueOf(injection.target))), (Expr)e)));
                });
                continue;
            }
            if (!injection.isMethod() || injection.isConstructor()) continue;
            transientReferences = new ArrayList();
            LocalVar[] injectedReferences = new LocalVar[injection.injectionPoints.size()];
            int paramIdx = 0;
            for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                InstanceFieldVar providerSupplier = cc.this_().field(injectionPointToProviderSupplierField.get(injectionPoint));
                LocalVar provider = bc.localVar("provider", bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)providerSupplier));
                LocalVar childCC = bc.localVar("childCC", bc.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)provider, (Expr)parentCC));
                LocalVar injectedReference = bc.localVar("injectedReference", bc.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)provider, (Expr)childCC));
                BeanGenerator.checkPrimitiveInjection(bc, injectionPoint, injectedReference);
                injectedReferences[paramIdx++] = injectedReference;
                if (!injectionPoint.isDependentTransientReference()) continue;
                transientReferences.add(new TransientReference((Var)provider, (Var)injectedReference, (Var)childCC));
            }
            MethodInfo initializerMethod = injection.target.asMethod();
            if (this.isReflectionFallbackNeeded(initializerMethod, targetPackage)) {
                if (Modifier.isPrivate(initializerMethod.flags())) {
                    this.privateMembers.add(isApplicationClass, String.format("@Inject initializer %s#%s()", initializerMethod.declaringClass().name(), initializerMethod.name()));
                }
                this.reflectionRegistration.registerMethod(initializerMethod);
                Expr paramTypes = bc.newArray(Class.class, initializerMethod.parameterTypes().stream().map(paramType -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)paramType))).toList());
                Expr args = bc.newArray(Object.class, (Expr[])injectedReferences);
                bc.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)initializerMethod.declaringClass())), Const.of((String)initializerMethod.name()), paramTypes, instance, args});
            } else {
                bc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)initializerMethod), (Expr)instance, (Expr[])injectedReferences);
            }
            BeanGenerator.destroyTransientReferences(bc, transientReferences);
        }
        if (bean.isSubclassRequired()) {
            ClassDesc subclass = ClassDesc.of(SubclassGenerator.generatedName(bean.getProviderType().name(), baseName));
            bc.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)subclass, (String)"arc$markConstructed", Void.TYPE, (Class[])new Class[0]), bc.cast((Expr)instance, subclass));
        }
        if (postConstructInterception.isEmpty()) {
            new PostConstructGenerator().generate(bc, (Var)instance);
        } else {
            LocalVar runnable = bc.localVar("runnable", bc.lambda(Runnable.class, lc -> {
                Var capturedInstance = lc.capture("instance", (Expr)instance);
                lc.body(lbc -> {
                    new PostConstructGenerator().generate((BlockCreator)lbc, capturedInstance);
                    lbc.return_();
                });
            }));
            LocalVar bindingsArray = bc.localVar("bindings", bc.newEmptyArray(Object.class, postConstructInterception.bindings.size()));
            int bindingsIndex = 0;
            for (AnnotationInstance binding : postConstructInterception.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                bc.set(bindingsArray.elem(bindingsIndex++), this.annotationLiterals.create(bc, bindingClass, binding));
            }
            LocalVar invocationContext = bc.localVar("invocationContext", bc.invokeStatic(MethodDescs.INVOCATION_CONTEXTS_POST_CONSTRUCT, new Expr[]{instance, postConstructs, bc.invokeStatic(MethodDescs.SETS_OF, (Expr)bindingsArray), runnable}));
            bc.try_(tc -> {
                tc.body(b1 -> b1.invokeInterface(MethodDesc.of(InvocationContext.class, (String)"proceed", Object.class, (Class[])new Class[0]), (Expr)invocationContext));
                tc.catch_(Exception.class, "e", (b1, e) -> {
                    b1.ifInstanceOf((Expr)e, RuntimeException.class, BlockCreator::throw_);
                    b1.throw_(b1.new_(ConstructorDesc.of(RuntimeException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)"Error invoking postConstructs"), (Expr)e));
                });
            });
        }
        bc.return_((Expr)instance);
    }

    private Expr newBeanInstance(BeanInfo bean, BlockCreator bc, ProviderType providerType, String baseName, List<Var> providers, boolean isApplicationClass, Var parentCC) {
        List<InjectionPointInfo> injectionPoints;
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        MethodInfo constructor = constructorInjection.isPresent() ? constructorInjection.get().target.asMethod() : null;
        List<InjectionPointInfo> list = injectionPoints = constructorInjection.isPresent() ? constructorInjection.get().injectionPoints : Collections.emptyList();
        if (bean.isSubclassRequired()) {
            int i;
            ArrayList<ClassDesc> paramTypes = new ArrayList<ClassDesc>();
            ArrayList<Object> args = new ArrayList<Object>();
            List<InterceptorInfo> interceptors = bean.getBoundInterceptors();
            List<DecoratorInfo> decorators = bean.getBoundDecorators();
            for (i = 0; i < injectionPoints.size(); ++i) {
                paramTypes.add(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)injectionPoints.get(i).getType()));
                args.add((Expr)providers.get(i));
            }
            paramTypes.add(Reflection2Gizmo.classDescOf(CreationalContext.class));
            args.add(parentCC);
            for (i = 0; i < interceptors.size(); ++i) {
                paramTypes.add(Reflection2Gizmo.classDescOf(InjectableInterceptor.class));
                args.add((Expr)providers.get(injectionPoints.size() + i));
            }
            for (i = 0; i < decorators.size(); ++i) {
                paramTypes.add(Reflection2Gizmo.classDescOf(InjectableDecorator.class));
                args.add((Expr)providers.get(injectionPoints.size() + interceptors.size() + i));
            }
            ClassDesc subclass = ClassDesc.of(SubclassGenerator.generatedName(bean.getProviderType().name(), baseName));
            return bc.new_(ConstructorDesc.of((ClassDesc)subclass, paramTypes), args);
        }
        if (constructorInjection.isPresent()) {
            if (Modifier.isPrivate(constructor.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Bean constructor %s on %s", constructor, constructor.declaringClass().name()));
                this.reflectionRegistration.registerMethod(constructor);
                int params = providers.size();
                if (DecoratorGenerator.isAbstractDecoratorImpl(bean, providerType.className())) {
                    ++params;
                }
                LocalVar paramTypes = bc.localVar("paramTypes", bc.newEmptyArray(Class.class, params));
                LocalVar args = bc.localVar("args", bc.newEmptyArray(Object.class, params));
                for (int i = 0; i < injectionPoints.size(); ++i) {
                    bc.set(paramTypes.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)injectionPoints.get(i).getType())));
                    bc.set(args.elem(i), (Expr)providers.get(i));
                }
                if (DecoratorGenerator.isAbstractDecoratorImpl(bean, providerType.className())) {
                    bc.set(paramTypes.elem(params - 1), Const.of(CreationalContext.class));
                    bc.set(args.elem(params - 1), (Expr)parentCC);
                }
                ClassDesc declaringClass = Jandex2Gizmo.classDescOf((ClassInfo)constructor.declaringClass());
                return bc.cast(bc.invokeStatic(MethodDescs.REFLECTIONS_NEW_INSTANCE, new Expr[]{Const.of((ClassDesc)declaringClass), paramTypes, args}), declaringClass);
            }
            int params = injectionPoints.size();
            if (DecoratorGenerator.isAbstractDecoratorImpl(bean, providerType.className())) {
                ++params;
            }
            ArrayList<ClassDesc> paramTypes = new ArrayList<ClassDesc>(params);
            for (InjectionPointInfo injectionPoint : injectionPoints) {
                paramTypes.add(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)injectionPoint.getType()));
            }
            Expr[] args = new Expr[params];
            for (int i = 0; i < injectionPoints.size(); ++i) {
                args[i] = (Expr)providers.get(i);
            }
            if (DecoratorGenerator.isAbstractDecoratorImpl(bean, providerType.className())) {
                paramTypes.add(Reflection2Gizmo.classDescOf(CreationalContext.class));
                args[params - 1] = parentCC;
            }
            return bc.new_(ConstructorDesc.of((ClassDesc)providerType.classDesc(), paramTypes), args);
        }
        MethodInfo noArgsConstructor = bean.getTarget().get().asClass().method("<init>", new org.jboss.jandex.Type[0]);
        if (Modifier.isPrivate(noArgsConstructor.flags())) {
            Expr argsArray;
            Expr paramTypesArray;
            this.privateMembers.add(isApplicationClass, String.format("Bean constructor %s on %s", noArgsConstructor, noArgsConstructor.declaringClass().name()));
            this.reflectionRegistration.registerMethod(noArgsConstructor);
            if (DecoratorGenerator.isAbstractDecoratorImpl(bean, providerType.className())) {
                paramTypesArray = bc.newArray(Class.class, new Expr[]{Const.of(CreationalContext.class)});
                argsArray = bc.newArray(Object.class, new Expr[]{parentCC});
            } else {
                paramTypesArray = bc.newArray(Class.class, new Expr[0]);
                argsArray = bc.newArray(Object.class, new Expr[0]);
            }
            ClassDesc declaringClass = Jandex2Gizmo.classDescOf((ClassInfo)noArgsConstructor.declaringClass());
            return bc.cast(bc.invokeStatic(MethodDescs.REFLECTIONS_NEW_INSTANCE, new Expr[]{Const.of((ClassDesc)declaringClass), paramTypesArray, argsArray}), declaringClass);
        }
        if (DecoratorGenerator.isAbstractDecoratorImpl(bean, providerType.className())) {
            return bc.new_(ConstructorDesc.of((ClassDesc)providerType.classDesc(), (Class[])new Class[]{CreationalContext.class}), (Expr)parentCC);
        }
        return bc.new_(ConstructorDesc.of((ClassDesc)providerType.classDesc()));
    }

    private void newProviders(BeanInfo bean, ClassCreator cc, BlockCreator bc, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, Map<InterceptorInfo, FieldDesc> interceptorToProviderField, Map<DecoratorInfo, FieldDesc> decoratorToProviderSupplierField, Map<InterceptorInfo, LocalVar> interceptorToWrap, List<TransientReference> transientReferences, List<Var> injectableParams, List<Var> allOtherParams, ParamVar parentCC) {
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        if (constructorInjection.isPresent()) {
            for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                InstanceFieldVar providerSupplier = cc.this_().field(injectionPointToProviderField.get(injectionPoint));
                LocalVar provider = bc.localVar("provider", bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)providerSupplier));
                LocalVar childCC = bc.localVar("childCC", bc.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)provider, (Expr)parentCC));
                LocalVar injectedReference = bc.localVar("injectedReference", bc.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)provider, (Expr)childCC));
                BeanGenerator.checkPrimitiveInjection(bc, injectionPoint, injectedReference);
                injectableParams.add((Var)injectedReference);
                if (!injectionPoint.isDependentTransientReference()) continue;
                transientReferences.add(new TransientReference((Var)provider, (Var)injectedReference, (Var)childCC));
            }
        }
        if (bean.isSubclassRequired()) {
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                LocalVar wrapped = interceptorToWrap.get(interceptor);
                if (wrapped != null) {
                    allOtherParams.add((Var)wrapped);
                    continue;
                }
                InstanceFieldVar interceptorProviderSupplier = cc.this_().field(interceptorToProviderField.get(interceptor));
                LocalVar interceptorProvider = bc.localVar("interceptorProvider", bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)interceptorProviderSupplier));
                allOtherParams.add((Var)interceptorProvider);
            }
            for (DecoratorInfo decorator : bean.getBoundDecorators()) {
                InstanceFieldVar decoratorProviderSupplier = cc.this_().field(decoratorToProviderSupplierField.get(decorator));
                LocalVar decoratorProvider = bc.localVar("decoratorProvider", bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)decoratorProviderSupplier));
                allOtherParams.add((Var)decoratorProvider);
            }
        }
    }

    private void generateCreateForProducerMethod(ClassCreator cc, BeanInfo bean, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderSupplierField, boolean isApplicationClass, BlockCreator b0, ParamVar parentCC) {
        MethodInfo producerMethod = bean.getTarget().get().asMethod();
        boolean isStatic = Modifier.isStatic(producerMethod.flags());
        FieldDesc declaringProviderSupplierField = FieldDesc.of((ClassDesc)cc.type(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, Supplier.class);
        InstanceFieldVar declaringProviderSupplier = cc.this_().field(declaringProviderSupplierField);
        LocalVar declaringProvider = b0.localVar("declaringProvider", b0.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)declaringProviderSupplier));
        LocalVar creationalContext = b0.localVar("creationalContext", b0.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)cc.this_()));
        LocalVar declaringProviderInstance = b0.localVar("declaringProviderInstance", b0.blockExpr(Jandex2Gizmo.classDescOf((ClassInfo)producerMethod.declaringClass()), b1 -> {
            if (isStatic) {
                b1.yieldNull();
                return;
            }
            Expr result = b1.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)declaringProvider, (Expr)creationalContext);
            if (bean.getDeclaringBean().getScope().isNormal()) {
                b1.yield(b1.invokeInterface(MethodDescs.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, result));
            } else {
                b1.yield(result);
            }
        }));
        List<InjectionPointInfo> injectionPoints = bean.getAllInjectionPoints();
        LocalVar[] injectedReferences = new LocalVar[injectionPoints.size()];
        ArrayList<TransientReference> transientReferences = new ArrayList<TransientReference>();
        int idx = 0;
        for (InjectionPointInfo injectionPoint : injectionPoints) {
            InstanceFieldVar providerSupplier = cc.this_().field(injectionPointToProviderSupplierField.get(injectionPoint));
            LocalVar provider = b0.localVar("provider" + idx, b0.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)providerSupplier));
            LocalVar childCC = b0.localVar("childCC" + idx, b0.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)provider, (Expr)parentCC));
            LocalVar instance = b0.localVar("instance" + idx, b0.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)provider, (Expr)childCC));
            BeanGenerator.checkPrimitiveInjection(b0, injectionPoint, instance);
            injectedReferences[idx] = instance;
            if (injectionPoint.isDependentTransientReference()) {
                transientReferences.add(new TransientReference((Var)provider, (Var)instance, (Var)childCC));
            }
            ++idx;
        }
        LocalVar instance = b0.localVar("instance", b0.blockExpr(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)bean.getProviderType()), b1 -> {
            Expr result;
            if (Modifier.isPrivate(producerMethod.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Producer method %s#%s()", producerMethod.declaringClass().name(), producerMethod.name()));
                this.reflectionRegistration.registerMethod(producerMethod);
                LocalVar paramTypes = b1.localVar("paramTypes", b1.newEmptyArray(Class.class, injectedReferences.length));
                LocalVar args = b1.localVar("args", b1.newEmptyArray(Object.class, injectedReferences.length));
                for (int i = 0; i < injectedReferences.length; ++i) {
                    b1.set(paramTypes.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)producerMethod.parameterType(i))));
                    b1.set(args.elem(i), (Expr)injectedReferences[i]);
                }
                result = b1.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)producerMethod.declaringClass())), Const.of((String)producerMethod.name()), paramTypes, declaringProviderInstance, args});
            } else {
                result = isStatic ? b1.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)producerMethod), (Expr[])injectedReferences) : b1.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)producerMethod), (Expr)declaringProviderInstance, (Expr[])injectedReferences);
            }
            b1.yield(result);
        }));
        if (bean.getScope().isNormal()) {
            b0.ifNull((Expr)instance, b1 -> b1.throw_(IllegalProductException.class, "Normal scoped producer method may not return null: " + String.valueOf(bean.getDeclaringBean().getImplClazz().name()) + "." + producerMethod.name() + "()"));
        }
        if (BuiltinScope.DEPENDENT.is(bean.getDeclaringBean().getScope()) && !isStatic) {
            b0.invokeInterface(MethodDescs.INJECTABLE_BEAN_DESTROY, (Expr)declaringProvider, (Expr)declaringProviderInstance, (Expr)creationalContext);
        }
        BeanGenerator.destroyTransientReferences(b0, transientReferences);
        b0.return_((Expr)instance);
    }

    private void generateCreateForProducerField(ClassCreator cc, BeanInfo bean, boolean isApplicationClass, BlockCreator b0) {
        FieldInfo producerField = bean.getTarget().get().asField();
        boolean isStatic = Modifier.isStatic(producerField.flags());
        FieldDesc declaringProviderSupplierField = FieldDesc.of((ClassDesc)cc.type(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, Supplier.class);
        InstanceFieldVar declaringProviderSupplier = cc.this_().field(declaringProviderSupplierField);
        LocalVar declaringProvider = b0.localVar("declaringProvider", b0.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)declaringProviderSupplier));
        LocalVar creationalContext = b0.localVar("creationalContext", b0.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)cc.this_()));
        LocalVar declaringProviderInstance = b0.localVar("declaringProviderInstance", b0.blockExpr(Jandex2Gizmo.classDescOf((ClassInfo)producerField.declaringClass()), b1 -> {
            if (isStatic) {
                b1.yieldNull();
                return;
            }
            Expr result = b1.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)declaringProvider, (Expr)creationalContext);
            if (bean.getDeclaringBean().getScope().isNormal()) {
                b1.yield(b1.invokeInterface(MethodDescs.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, result));
            } else {
                b1.yield(result);
            }
        }));
        LocalVar instance = b0.localVar("instance", b0.blockExpr(Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)bean.getProviderType()), b1 -> {
            StaticFieldVar result;
            if (Modifier.isPrivate(producerField.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Producer field %s#%s", producerField.declaringClass().name(), producerField.name()));
                this.reflectionRegistration.registerField(producerField);
                result = b1.invokeStatic(MethodDescs.REFLECTIONS_READ_FIELD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)producerField.declaringClass())), Const.of((String)producerField.name()), declaringProviderInstance});
            } else {
                result = Modifier.isStatic(producerField.flags()) ? Expr.staticField((FieldDesc)Jandex2Gizmo.fieldDescOf((FieldInfo)producerField)) : declaringProviderInstance.field(Jandex2Gizmo.fieldDescOf((FieldInfo)producerField));
            }
            b1.yield((Expr)result);
        }));
        if (bean.getScope().isNormal()) {
            b0.ifNull((Expr)instance, b1 -> b1.throw_(IllegalProductException.class, "Normal scoped producer field may not be null: " + String.valueOf(bean.getDeclaringBean().getImplClazz().name()) + "." + bean.getTarget().get().asField().name()));
        }
        if (BuiltinScope.DEPENDENT.is(bean.getDeclaringBean().getScope()) && !isStatic) {
            b0.invokeInterface(MethodDescs.INJECTABLE_BEAN_DESTROY, (Expr)declaringProvider, (Expr)declaringProviderInstance, (Expr)creationalContext);
        }
        b0.return_((Expr)instance);
    }

    private void generateCreateForSyntheticBean(final ClassCreator cc, BeanInfo bean, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderSupplierField, BlockCreator b0, ParamVar parentCC) {
        LocalVar injectedReferences;
        MethodDesc createSyntheticDesc = cc.method("createSynthetic", mc -> {
            mc.returning(Object.class);
            ParamVar synthCC = mc.parameter("synthCC", SyntheticCreationalContext.class);
            mc.body(bc -> bean.getCreatorConsumer().accept(new BeanConfiguratorBase.CreateGeneration(){
                final /* synthetic */ BlockCreator val$bc;
                final /* synthetic */ ParamVar val$synthCC;
                {
                    this.val$bc = blockCreator;
                    this.val$synthCC = paramVar;
                }

                @Override
                public ClassCreator beanClass() {
                    return cc;
                }

                @Override
                public BlockCreator createMethod() {
                    return this.val$bc;
                }

                @Override
                public Var syntheticCreationalContext() {
                    return this.val$synthCC;
                }
            }));
        });
        Consumer<BeanConfiguratorBase.CheckActiveGeneration> checkActiveConsumer = bean.getCheckActiveConsumer();
        if (checkActiveConsumer != null) {
            MethodDesc checkActiveDesc = cc.method("checkActive", mc -> {
                mc.returning(ActiveResult.class);
                mc.body(bc -> checkActiveConsumer.accept(new BeanConfiguratorBase.CheckActiveGeneration(){
                    final /* synthetic */ BlockCreator val$bc;
                    {
                        this.val$bc = blockCreator;
                    }

                    @Override
                    public ClassCreator beanClass() {
                        return cc;
                    }

                    @Override
                    public BlockCreator checkActiveMethod() {
                        return this.val$bc;
                    }
                }));
            });
            ArrayList<InjectionPointInfo> matchingIPs = new ArrayList<InjectionPointInfo>();
            for (InjectionPointInfo injectionPoint : bean.getDeployment().getInjectionPoints()) {
                if (injectionPoint.isSynthetic() || !bean.equals(injectionPoint.getResolvedBean())) continue;
                matchingIPs.add(injectionPoint);
            }
            LocalVar active = b0.localVar("active", b0.invokeVirtual(checkActiveDesc, (Expr)cc.this_()));
            Expr activeBool = b0.invokeVirtual(MethodDescs.ACTIVE_RESULT_VALUE, (Expr)active);
            b0.ifNot(activeBool, b1 -> {
                LocalVar msg = b1.localVar("msg", b1.new_(StringBuilder.class));
                StringBuilderGen msgBuilder = StringBuilderGen.of((Var)msg, (BlockCreator)b1).append("Bean is not active: ").append((Expr)cc.this_()).append("\nReason: ").append(b1.invokeVirtual(MethodDescs.ACTIVE_RESULT_REASON, (Expr)active));
                LocalVar cause = b1.localVar("cause", b1.invokeVirtual(MethodDescs.ACTIVE_RESULT_CAUSE, (Expr)active));
                b1.while_(b2 -> b2.yield(b2.isNotNull((Expr)cause)), b2 -> {
                    StringBuilderGen.of((Var)msg, (BlockCreator)b2).append("\nCause: ").append(b2.invokeVirtual(MethodDescs.ACTIVE_RESULT_REASON, (Expr)cause));
                    b2.set((Assignable)cause, b2.invokeVirtual(MethodDescs.ACTIVE_RESULT_CAUSE, (Expr)cause));
                });
                msgBuilder.append("\nTo avoid this exception while keeping the bean inactive:").append("\n\t- Configure all extensions consuming this bean as inactive as well, if they allow it,").append(" e.g. 'quarkus.someextension.active=false'").append("\n\t- Make sure that custom code only accesses this bean if it is active");
                if (!matchingIPs.isEmpty()) {
                    Const implClassName = Const.of((String)bean.getImplClazz().name().toString());
                    msgBuilder.append("\n\t- Inject the bean with 'Instance<").append((Expr)implClassName).append(">' instead of '").append((Expr)implClassName).append("'\n");
                    msgBuilder.append("This bean is injected into:");
                    for (InjectionPointInfo matchingIP : matchingIPs) {
                        msgBuilder.append("\n\t- ").append(matchingIP.getTargetInfo());
                    }
                }
                b1.throw_(InactiveBeanException.class, b1.objToString((Expr)msg));
            });
        }
        if (injectionPointToProviderSupplierField.isEmpty()) {
            injectedReferences = b0.localVar("injectedReferences", b0.mapOf(new Expr[0]));
        } else {
            injectedReferences = b0.localVar("injectedReferences", b0.new_(HashMap.class));
            LocalVar tccl = b0.localVar("tccl", b0.invokeVirtual(MethodDescs.THREAD_GET_TCCL, b0.currentThread()));
            IndexView index = bean.getDeployment().getBeanArchiveIndex();
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                b0.try_(tc -> {
                    tc.body(b1 -> {
                        LocalVar requiredQualifiers;
                        LocalVar requiredType;
                        try {
                            requiredType = RuntimeTypeCreator.of(b1).withTCCL((Var)tccl).withIndex(index).create(injectionPoint.getType());
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalStateException("Unable to construct type for " + String.valueOf(injectionPoint.getType()) + ": " + e.getMessage());
                        }
                        if (injectionPoint.hasDefaultedQualifier()) {
                            requiredQualifiers = b1.localVar(FIELD_NAME_QUALIFIERS, (Expr)Const.ofNull(Annotation[].class));
                        } else {
                            requiredQualifiers = b1.localVar(FIELD_NAME_QUALIFIERS, b1.newEmptyArray(Annotation.class, injectionPoint.getRequiredQualifiers().size()));
                            int idx = 0;
                            for (AnnotationInstance qualifier : injectionPoint.getRequiredQualifiers()) {
                                BuiltinQualifier builtinQualifier = BuiltinQualifier.of(qualifier);
                                if (builtinQualifier != null) {
                                    b1.set(requiredQualifiers.elem(idx++), (Expr)builtinQualifier.getLiteralInstance());
                                    continue;
                                }
                                ClassInfo qualifierClass = bean.getDeployment().getQualifier(qualifier.name());
                                b1.set(requiredQualifiers.elem(idx++), this.annotationLiterals.create((BlockCreator)b1, qualifierClass, qualifier));
                            }
                        }
                        LocalVar typeAndQualifiers = b1.localVar("typeAndQualifiers", b1.new_(SyntheticCreationalContextImpl.TypeAndQualifiers.class, (Expr)requiredType, (Expr)requiredQualifiers));
                        InstanceFieldVar providerSupplier = cc.this_().field((FieldDesc)injectionPointToProviderSupplierField.get(injectionPoint));
                        LocalVar provider = b1.localVar("provider", b1.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)providerSupplier));
                        LocalVar childCC = b1.localVar("childCC", b1.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)provider, (Expr)parentCC));
                        LocalVar injectedReference = b1.localVar("injectedReference", b1.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)provider, (Expr)childCC));
                        BeanGenerator.checkPrimitiveInjection(b1, injectionPoint, injectedReference);
                        b1.withMap((Expr)injectedReferences).put((Expr)typeAndQualifiers, (Expr)injectedReference);
                    });
                    tc.catch_(RuntimeException.class, "e", (b1, e) -> b1.throw_(b1.new_(ConstructorDesc.of(RuntimeException.class, (Class[])new Class[]{String.class, Throwable.class}), (Expr)Const.of((String)("Error injecting synthetic injection point of bean: " + bean.getIdentifier())), (Expr)e)));
                });
            }
        }
        InstanceFieldVar params = cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)"params", Map.class));
        LocalVar synthCC = b0.localVar("synthCC", b0.new_(ConstructorDesc.of(SyntheticCreationalContextImpl.class, (Class[])new Class[]{CreationalContext.class, Map.class, Map.class}), new Expr[]{parentCC, params, injectedReferences}));
        LocalVar result = b0.localVar("result", (Expr)Const.ofNull((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)bean.getProviderType())));
        b0.try_(arg_0 -> BeanGenerator.lambda$generateCreateForSyntheticBean$61(result, createSyntheticDesc, cc, (Expr)synthCC, bean, arg_0));
        if (bean.getScope().isNormal()) {
            b0.ifNull((Expr)result, b1 -> {
                Expr msg = StringBuilderGen.ofNew((BlockCreator)b1).append("Null contextual instance was produced by a normal scoped synthetic bean: ").append((Expr)cc.this_()).toString_();
                b1.throw_(CreationException.class, msg);
            });
        }
        b0.return_((Expr)result);
    }

    static void checkPrimitiveInjection(BlockCreator b0, InjectionPointInfo injectionPoint, LocalVar localVar) {
        if (injectionPoint.getType().kind() == Type.Kind.PRIMITIVE) {
            org.jboss.jandex.Type producerType = null;
            if (injectionPoint.getResolvedBean().isProducerField()) {
                producerType = injectionPoint.getResolvedBean().getTarget().get().asField().type();
            } else if (injectionPoint.getResolvedBean().isProducerMethod()) {
                producerType = injectionPoint.getResolvedBean().getTarget().get().asMethod().returnType();
            }
            if (PrimitiveType.isBox(producerType)) {
                b0.ifNull((Expr)localVar, b1 -> b1.set((Assignable)localVar, Const.ofDefault((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)injectionPoint.getType()))));
            }
        }
    }

    protected void generateDestroy(final ClassCreator cc, final BeanInfo bean, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, final boolean isApplicationClass, String baseName, final String targetPackage) {
        MethodDesc destroyDesc = cc.method("destroy", mc -> {
            mc.returning(Void.TYPE);
            ParamVar providerParam = mc.parameter("provider", Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)bean.getProviderType()));
            ParamVar ccParam = mc.parameter("creationalContext", CreationalContext.class);
            mc.body(b0 -> {
                b0.try_(tc -> {
                    tc.body(b1 -> {
                        if (bean.isClassBean()) {
                            if (!bean.isInterceptor()) {
                                class PreDestroyGenerator {
                                    PreDestroyGenerator() {
                                    }

                                    void generate(BlockCreator bc, Var instance) {
                                        List<MethodInfo> preDestroyCallbacks = Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.PRE_DESTROY, bean.getDeployment().getBeanArchiveIndex());
                                        for (MethodInfo callback : preDestroyCallbacks) {
                                            if (BeanGenerator.this.isReflectionFallbackNeeded(callback, targetPackage)) {
                                                if (Modifier.isPrivate(callback.flags())) {
                                                    BeanGenerator.this.privateMembers.add(isApplicationClass, String.format("@PreDestroy callback %s#%s()", callback.declaringClass().name(), callback.name()));
                                                }
                                                BeanGenerator.this.reflectionRegistration.registerMethod(callback);
                                                bc.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)callback.declaringClass())), Const.of((String)callback.name()), bc.newEmptyArray(Class.class, 0), instance, bc.newEmptyArray(Object.class, 0)});
                                                continue;
                                            }
                                            bc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)callback), (Expr)instance);
                                        }
                                    }
                                }
                                LocalVar instance = b1.localVar("instance", b1.invokeStatic(MethodDescs.CLIENT_PROXY_UNWRAP, (Expr)providerParam));
                                if (bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY).isEmpty()) {
                                    new PreDestroyGenerator().generate((BlockCreator)b1, (Var)instance);
                                } else {
                                    ClassDesc subclass = ClassDesc.of(SubclassGenerator.generatedName(bean.getProviderType().name(), baseName));
                                    Expr runnable = b1.lambda(Runnable.class, lc -> {
                                        Var capturedInstance = lc.capture((Var)instance);
                                        lc.body(lbc -> {
                                            new PreDestroyGenerator().generate((BlockCreator)lbc, capturedInstance);
                                            lbc.return_();
                                        });
                                    });
                                    b1.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)subclass, (String)"arc$destroy", Void.TYPE, (Class[])new Class[]{Runnable.class}), (Expr)instance, runnable);
                                }
                            }
                            b1.invokeInterface(MethodDescs.CREATIONAL_CTX_RELEASE, (Expr)ccParam);
                            b1.return_();
                        } else if (bean.getDisposer() != null) {
                            MethodInfo disposerMethod = bean.getDisposer().getDisposerMethod();
                            boolean isStatic = Modifier.isStatic(disposerMethod.flags());
                            InstanceFieldVar declaringProviderSupplier = cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, Supplier.class));
                            LocalVar declaringProvider = b1.localVar("declaringProvider", b1.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)declaringProviderSupplier));
                            LocalVar parentCC = b1.localVar("parentCC", b1.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)Const.ofNull(Contextual.class)));
                            LocalVar declaringProviderInstance = b1.localVar("declaringProviderInstance", (Expr)Const.ofNull(Object.class));
                            if (!isStatic) {
                                b1.set((Assignable)declaringProviderInstance, b1.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)declaringProvider, (Expr)parentCC));
                                if (bean.getDeclaringBean().getScope().isNormal()) {
                                    b1.set((Assignable)declaringProviderInstance, b1.invokeInterface(MethodDescs.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, (Expr)declaringProviderInstance));
                                }
                            }
                            Var[] disposerArgs = new Var[disposerMethod.parametersCount()];
                            short disposedParamPosition = bean.getDisposer().getDisposedParameter().position();
                            Iterator<InjectionPointInfo> injectionPointsIterator = bean.getDisposer().getInjection().injectionPoints.iterator();
                            for (int i = 0; i < disposerMethod.parametersCount(); ++i) {
                                if (i == disposedParamPosition) {
                                    disposerArgs[i] = providerParam;
                                    continue;
                                }
                                InjectionPointInfo injectionPoint = injectionPointsIterator.next();
                                InstanceFieldVar providerSupplier = cc.this_().field((FieldDesc)injectionPointToProviderField.get(injectionPoint));
                                Expr provider = b1.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)providerSupplier);
                                Expr childCC = b1.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)declaringProvider, (Expr)parentCC);
                                LocalVar injection = b1.localVar("injection" + i, b1.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, provider, childCC));
                                BeanGenerator.checkPrimitiveInjection(b1, injectionPoint, injection);
                                disposerArgs[i] = injection;
                            }
                            if (Modifier.isPrivate(disposerMethod.flags())) {
                                this.privateMembers.add(isApplicationClass, String.format("Disposer %s#%s", disposerMethod.declaringClass().name(), disposerMethod.name()));
                                this.reflectionRegistration.registerMethod(disposerMethod);
                                LocalVar paramTypesArray = b1.localVar("paramTypes", b1.newEmptyArray(Class.class, disposerArgs.length));
                                LocalVar argsArray = b1.localVar("args", b1.newEmptyArray(Object.class, disposerArgs.length));
                                for (int i = 0; i < disposerArgs.length; ++i) {
                                    b1.set(paramTypesArray.elem(i), Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)disposerMethod.parameterType(i))));
                                    b1.set(argsArray.elem(i), (Expr)disposerArgs[i]);
                                }
                                b1.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)disposerMethod.declaringClass())), Const.of((String)disposerMethod.name()), paramTypesArray, declaringProviderInstance, argsArray});
                            } else if (isStatic) {
                                b1.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)disposerMethod), (Expr[])disposerArgs);
                            } else {
                                b1.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)disposerMethod), (Expr)declaringProviderInstance, (Expr[])disposerArgs);
                            }
                            b1.invokeInterface(MethodDescs.CREATIONAL_CTX_RELEASE, (Expr)parentCC);
                            if (BuiltinScope.DEPENDENT.is(bean.getDisposer().getDeclaringBean().getScope()) && !isStatic) {
                                b1.invokeInterface(MethodDescs.INJECTABLE_BEAN_DESTROY, (Expr)declaringProvider, (Expr)declaringProviderInstance, (Expr)parentCC);
                            }
                            b1.invokeInterface(MethodDescs.CREATIONAL_CTX_RELEASE, (Expr)ccParam);
                            b1.return_();
                        } else if (bean.isSynthetic()) {
                            bean.getDestroyerConsumer().accept(new BeanConfiguratorBase.DestroyGeneration(){
                                final /* synthetic */ BlockCreator val$b1;
                                final /* synthetic */ ParamVar val$providerParam;
                                final /* synthetic */ ParamVar val$ccParam;
                                {
                                    this.val$b1 = blockCreator;
                                    this.val$providerParam = paramVar;
                                    this.val$ccParam = paramVar2;
                                }

                                @Override
                                public ClassCreator beanClass() {
                                    return cc;
                                }

                                @Override
                                public BlockCreator destroyMethod() {
                                    return this.val$b1;
                                }

                                @Override
                                public Var destroyedInstance() {
                                    return this.val$providerParam;
                                }

                                @Override
                                public Var creationalContext() {
                                    return this.val$ccParam;
                                }
                            });
                        }
                    });
                    tc.catch_(Throwable.class, "e", (b1, e) -> {
                        Const error = Const.of((String)("Error occurred while destroying instance of " + String.valueOf(bean)));
                        LocalVar logger = b1.localVar("logger", (Expr)Expr.staticField((FieldDesc)FieldDesc.of(UncaughtExceptions.class, (String)"LOGGER")));
                        Expr isDebugEnabled = b1.invokeVirtual(MethodDesc.of(Logger.class, (String)"isDebugEnabled", Boolean.TYPE, (Class[])new Class[0]), (Expr)logger);
                        b1.ifElse(isDebugEnabled, b2 -> b2.invokeVirtual(MethodDesc.of(Logger.class, (String)"error", Void.TYPE, (Class[])new Class[]{Object.class, Throwable.class}), (Expr)logger, (Expr)error, (Expr)e), b2 -> b2.invokeVirtual(MethodDesc.of(Logger.class, (String)"error", Void.TYPE, (Class[])new Class[]{Object.class}), (Expr)logger, StringBuilderGen.ofNew((BlockCreator)b2).append((Expr)error).append(": ").append((Expr)e).toString_()));
                    });
                });
                b0.return_();
            });
        });
        if (!ClassType.OBJECT_TYPE.equals((Object)bean.getProviderType())) {
            cc.method("destroy", mc -> {
                mc.addFlag(ModifierFlag.BRIDGE);
                mc.returning(Void.TYPE);
                ParamVar provider = mc.parameter("provider", Object.class);
                ParamVar creationalContext = mc.parameter("creationalContext", CreationalContext.class);
                mc.body(bc -> bc.return_(bc.invokeVirtual(destroyDesc, (Expr)cc.this_(), (Expr)provider, (Expr)creationalContext)));
            });
        }
    }

    protected void generateSupplierGet(ClassCreator cc) {
        cc.method("get", mc -> {
            mc.returning(Object.class);
            mc.body(bc -> bc.return_((Expr)cc.this_()));
        });
    }

    protected void generateInjectableReferenceProviderGet(BeanInfo bean, ClassCreator cc, String baseName) {
        ClassDesc providerType = Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)bean.getProviderType());
        MethodDesc getDesc = cc.method("get", mc -> {
            mc.returning(providerType);
            ParamVar creationalContextParam = mc.parameter("creationalContext", CreationalContext.class);
            mc.body(b0 -> {
                if (bean.getDeployment().hasRuntimeDeferredUnproxyableError(bean)) {
                    b0.throw_(UnproxyableResolutionException.class, "Bean not proxyable: " + String.valueOf(bean));
                } else if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
                    LocalVar instance = b0.localVar("instance", b0.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)cc.type(), (String)"create", (MethodTypeDesc)MethodTypeDesc.of(providerType, Reflection2Gizmo.classDescOf(CreationalContext.class))), (Expr)cc.this_(), (Expr)creationalContextParam));
                    if (!bean.hasDestroyLogic()) {
                        Expr hasDependentInstances = b0.invokeVirtual(MethodDescs.CREATIONAL_CTX_HAS_DEPENDENT_INSTANCES, b0.cast((Expr)creationalContextParam, CreationalContextImpl.class));
                        b0.ifNot(hasDependentInstances, b1 -> b1.return_((Expr)instance));
                    }
                    b0.invokeStatic(MethodDescs.CREATIONAL_CTX_ADD_DEP_TO_PARENT, new Expr[]{cc.this_(), instance, creationalContextParam});
                    b0.return_((Expr)instance);
                } else if (bean.getScope().isNormal()) {
                    b0.return_(b0.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)cc.type(), (String)FIELD_NAME_PROXY, (MethodTypeDesc)MethodTypeDesc.of(this.getClientProxyType(bean, baseName), new ClassDesc[0])), (Expr)cc.this_()));
                } else {
                    Expr context = b0.invokeInterface(MethodDescs.ARC_CONTAINER_GET_ACTIVE_CONTEXT, b0.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER), (Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)bean.getScope().getDotName())));
                    Expr creationalContext = b0.new_(ConstructorDesc.of(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), (Expr)cc.this_());
                    Expr instance = b0.invokeInterface(MethodDescs.CONTEXT_GET, context, (Expr)cc.this_(), creationalContext);
                    b0.return_(instance);
                }
            });
        });
        if (!ClassType.OBJECT_TYPE.equals((Object)bean.getProviderType())) {
            cc.method("get", mc -> {
                mc.addFlag(ModifierFlag.BRIDGE);
                mc.returning(Object.class);
                ParamVar creationalContext = mc.parameter("creationalContext", CreationalContext.class);
                mc.body(bc -> bc.return_(bc.invokeVirtual(getDesc, (Expr)cc.this_(), (Expr)creationalContext)));
            });
        }
    }

    protected void generateGetIdentifier(ClassCreator cc, BeanInfo bean) {
        cc.method("getIdentifier", mc -> {
            mc.returning(String.class);
            mc.body(bc -> bc.return_((Expr)Const.of((String)bean.getIdentifier())));
        });
    }

    protected void generateGetTypes(FieldDesc typesField, ClassCreator cc) {
        cc.method("getTypes", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(typesField)));
        });
    }

    protected void generateGetScope(ClassCreator cc, BeanInfo bean) {
        cc.method("getScope", mc -> {
            mc.returning(Class.class);
            mc.body(bc -> bc.return_((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)bean.getScope().getDotName()))));
        });
    }

    protected void generateGetQualifiers(ClassCreator cc, FieldDesc qualifiersField) {
        cc.method("getQualifiers", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(qualifiersField)));
        });
    }

    protected void generateIsAlternative(ClassCreator cc, BeanInfo bean) {
        if (bean.isAlternative()) {
            cc.method("isAlternative", mc -> {
                mc.returning(Boolean.TYPE);
                mc.body(BlockCreator::returnTrue);
            });
        }
    }

    protected void generateGetPriority(ClassCreator cc, BeanInfo bean) {
        if (bean.getPriority() != null) {
            cc.method("hasPriority", mc -> {
                mc.returning(Boolean.TYPE);
                mc.body(BlockCreator::returnTrue);
            });
            cc.method("getPriority", mc -> {
                mc.returning(Integer.TYPE);
                mc.body(bc -> bc.return_(bean.getPriority().intValue()));
            });
        }
    }

    protected void generateGetDeclaringBean(ClassCreator cc, FieldDesc declaringProviderSupplierField) {
        cc.method("getDeclaringBean", mc -> {
            mc.returning(InjectableBean.class);
            mc.body(bc -> {
                InstanceFieldVar declaringProviderSupplier = cc.this_().field(declaringProviderSupplierField);
                bc.return_(bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)declaringProviderSupplier));
            });
        });
    }

    protected void generateGetStereotypes(ClassCreator cc, FieldDesc stereotypesField) {
        cc.method("getStereotypes", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(stereotypesField)));
        });
    }

    protected void generateGetBeanClass(ClassCreator cc, BeanInfo bean) {
        cc.method("getBeanClass", mc -> {
            mc.returning(Class.class);
            mc.body(bc -> bc.return_((Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)bean.getBeanClass()))));
        });
    }

    protected void generateGetImplementationClass(ClassCreator cc, BeanInfo bean) {
        cc.method("getImplementationClass", mc -> {
            mc.returning(Class.class);
            mc.body(bc -> bc.return_((Expr)(bean.getImplClazz() != null ? Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)bean.getImplClazz())) : Const.ofNull(Class.class))));
        });
    }

    protected void generateGetName(ClassCreator cc, BeanInfo bean) {
        if (bean.getName() != null) {
            cc.method("getName", mc -> {
                mc.returning(String.class);
                mc.body(bc -> bc.return_((Expr)Const.of((String)bean.getName())));
            });
        }
    }

    protected void generateIsDefaultBean(ClassCreator cc, BeanInfo bean) {
        cc.method("isDefaultBean", mc -> {
            mc.returning(Boolean.TYPE);
            mc.body(bc -> bc.return_(bean.isDefaultBean()));
        });
    }

    protected void generateGetKind(ClassCreator cc, BeanInfo bean) {
        InjectableBean.Kind kind;
        if (bean.isClassBean()) {
            return;
        }
        if (bean.isProducerMethod()) {
            kind = InjectableBean.Kind.PRODUCER_METHOD;
        } else if (bean.isProducerField()) {
            kind = InjectableBean.Kind.PRODUCER_FIELD;
        } else if (bean.isSynthetic()) {
            kind = InjectableBean.Kind.SYNTHETIC;
        } else {
            throw new IllegalArgumentException("Unknown bean kind: " + String.valueOf(bean));
        }
        cc.method("getKind", mc -> {
            mc.returning(InjectableBean.Kind.class);
            mc.body(bc -> bc.return_((Expr)Expr.staticField((FieldDesc)FieldDesc.of(InjectableBean.Kind.class, (String)kind.name()))));
        });
    }

    protected void generateIsSuppressed(ClassCreator cc, BeanInfo bean) {
        cc.method("isSuppressed", mc -> {
            mc.returning(Boolean.TYPE);
            mc.body(bc -> {
                for (Function<BeanInfo, Consumer<BlockCreator>> generator : this.suppressConditionGenerators) {
                    Consumer<BlockCreator> condition = generator.apply(bean);
                    if (condition == null) continue;
                    condition.accept((BlockCreator)bc);
                }
                bc.returnFalse();
            });
        });
    }

    protected void generateGetInjectionPoints(ClassCreator cc, BeanInfo bean) {
        if (!bean.getDeployment().strictCompatibility) {
            return;
        }
        List<InjectionPointInfo> injectionPoints = bean.getAllInjectionPoints();
        if (injectionPoints.isEmpty()) {
            return;
        }
        cc.method("getInjectionPoints", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> {
                LocalVar tccl = bc.localVar("tccl", bc.invokeVirtual(MethodDescs.THREAD_GET_TCCL, bc.currentThread()));
                LocalVar result = bc.localVar("result", bc.new_(HashSet.class));
                for (InjectionPointInfo injectionPoint : injectionPoints) {
                    LocalVar type = RuntimeTypeCreator.of(bc).withTCCL((Var)tccl).create(injectionPoint.getType());
                    Var qualifiers = BeanGenerator.collectInjectionPointQualifiers(bean.getDeployment(), bc, injectionPoint, this.annotationLiterals);
                    Var annotations = BeanGenerator.collectInjectionPointAnnotations(bean.getDeployment(), bc, injectionPoint, this.annotationLiterals, this.injectionPointAnnotationsPredicate);
                    Var member = BeanGenerator.getJavaMember(bc, injectionPoint, this.reflectionRegistration);
                    Expr ip = bc.new_(MethodDescs.INJECTION_POINT_IMPL_CONSTRUCTOR, new Expr[]{type, type, qualifiers, cc.this_(), annotations, member, Const.of((int)injectionPoint.getPosition()), Const.of((boolean)injectionPoint.isTransient())});
                    bc.withSet((Expr)result).add(ip);
                }
                bc.return_((Expr)result);
            });
        });
    }

    protected void generateEquals(ClassCreator cc, BeanInfo bean) {
        cc.method("equals", mc -> {
            mc.returning(Boolean.TYPE);
            ParamVar other = mc.parameter("other", Object.class);
            mc.body(bc -> {
                bc.if_(bc.eq((Expr)cc.this_(), (Expr)other), BlockCreator::returnTrue);
                bc.ifNull((Expr)other, BlockCreator::returnFalse);
                bc.ifNotInstanceOf((Expr)other, InjectableBean.class, BlockCreator::returnFalse);
                Expr otherBean = bc.cast((Expr)other, InjectableBean.class);
                Expr otherIdentifier = bc.invokeInterface(MethodDescs.GET_IDENTIFIER, otherBean);
                bc.return_(bc.objEquals((Expr)Const.of((String)bean.getIdentifier()), otherIdentifier));
            });
        });
    }

    protected void generateHashCode(ClassCreator cc, BeanInfo bean) {
        cc.method("hashCode", mc -> {
            mc.returning(Integer.TYPE);
            mc.body(bc -> bc.return_((Expr)Const.of((int)bean.getIdentifier().hashCode())));
        });
    }

    protected void generateToString(ClassCreator cc) {
        cc.method("toString", mc -> {
            mc.returning(String.class);
            mc.body(bc -> bc.return_(bc.invokeStatic(MethodDescs.BEANS_TO_STRING, (Expr)cc.this_())));
        });
    }

    private ClassDesc getClientProxyType(BeanInfo bean, String baseName) {
        StringBuilder proxyTypeName = new StringBuilder();
        proxyTypeName.append(bean.getClientProxyPackageName());
        if (!proxyTypeName.isEmpty()) {
            proxyTypeName.append(".");
        }
        proxyTypeName.append(baseName);
        proxyTypeName.append("_ClientProxy");
        return ClassDesc.of(proxyTypeName.toString());
    }

    static Expr wrapCurrentInjectionPoint(BeanInfo bean, BlockCreator constructor, InjectionPointInfo injectionPoint, Expr beanExpr, Expr delegateSupplier, LocalVar tccl, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate) {
        Var requiredQualifiers = BeanGenerator.collectInjectionPointQualifiers(bean.getDeployment(), constructor, injectionPoint, annotationLiterals);
        Var annotations = BeanGenerator.collectInjectionPointAnnotations(bean.getDeployment(), constructor, injectionPoint, annotationLiterals, injectionPointAnnotationsPredicate);
        Var javaMember = BeanGenerator.getJavaMember(constructor, injectionPoint, reflectionRegistration);
        RuntimeTypeCreator rttc = RuntimeTypeCreator.of(constructor);
        if (tccl != null) {
            rttc = rttc.withTCCL((Var)tccl);
        }
        return constructor.new_(ConstructorDesc.of(CurrentInjectionPointProvider.class, (Class[])new Class[]{InjectableBean.class, Supplier.class, Type.class, Set.class, Set.class, Member.class, Integer.TYPE, Boolean.TYPE}), new Expr[]{beanExpr, delegateSupplier, rttc.create(injectionPoint.getType()), requiredQualifiers, annotations, javaMember, Const.of((int)injectionPoint.getPosition()), Const.of((boolean)injectionPoint.isTransient())});
    }

    public static Var getJavaMember(BlockCreator bc, InjectionPointInfo injectionPoint, ReflectionRegistration reflectionRegistration) {
        Const javaMember;
        if (injectionPoint.isSynthetic()) {
            javaMember = Const.ofNull(Member.class);
        } else if (injectionPoint.isField()) {
            FieldInfo field = injectionPoint.getAnnotationTarget().asField();
            reflectionRegistration.registerField(field);
            javaMember = bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_FIELD, (Expr)Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)field.declaringClass())), (Expr)Const.of((String)field.name()));
        } else {
            MethodInfo method = injectionPoint.getAnnotationTarget().asMethodParameter().method();
            reflectionRegistration.registerMethod(method);
            if (method.name().equals("<init>")) {
                Const clazz = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass()));
                Expr paramsArray = bc.newArray(Class.class, method.parameterTypes().stream().map(paramType -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)paramType))).toList());
                javaMember = bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_CONSTRUCTOR, (Expr)clazz, paramsArray);
            } else {
                Const clazz = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)method.declaringClass()));
                Const name = Const.of((String)method.name());
                Expr paramsArray = bc.newArray(Class.class, method.parameterTypes().stream().map(paramType -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)paramType))).toList());
                javaMember = bc.invokeStatic(MethodDescs.REFLECTIONS_FIND_METHOD, new Expr[]{clazz, name, paramsArray});
            }
        }
        return bc.localVar("member", (Expr)javaMember);
    }

    public static Var collectInjectionPointAnnotations(BeanDeployment beanDeployment, BlockCreator bc, InjectionPointInfo injectionPoint, AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> injectionPointAnnotationsPredicate) {
        Collection<AnnotationInstance> annotations;
        if (injectionPoint.isSynthetic()) {
            return bc.localVar("annotations", bc.setOf(new Expr[0]));
        }
        if (AnnotationTarget.Kind.FIELD.equals((Object)injectionPoint.getAnnotationTarget().kind())) {
            FieldInfo field = injectionPoint.getAnnotationTarget().asField();
            annotations = beanDeployment.getAnnotations((AnnotationTarget)field);
        } else {
            MethodInfo method = injectionPoint.getAnnotationTarget().asMethodParameter().method();
            annotations = Annotations.getParameterAnnotations(beanDeployment, method, injectionPoint.getPosition());
        }
        if (annotations.isEmpty()) {
            return bc.localVar("annotations", bc.setOf(new Expr[0]));
        }
        LocalVar annotationsVar = bc.localVar("annotations", bc.new_(HashSet.class));
        for (AnnotationInstance annotation : annotations) {
            StaticFieldVar annotationExpr;
            if (!injectionPointAnnotationsPredicate.test(annotation.name())) continue;
            if (DotNames.INJECT.equals((Object)annotation.name())) {
                annotationExpr = Expr.staticField((FieldDesc)FieldDesc.of(InjectLiteral.class, (String)"INSTANCE"));
            } else {
                ClassInfo annotationClass = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), annotation.name());
                if (annotationClass == null) continue;
                annotationExpr = annotationLiterals.create(bc, annotationClass, annotation);
            }
            bc.withSet((Expr)annotationsVar).add((Expr)annotationExpr);
        }
        return annotationsVar;
    }

    public static Var collectInjectionPointQualifiers(BeanDeployment beanDeployment, BlockCreator bc, InjectionPointInfo injectionPoint, AnnotationLiteralProcessor annotationLiterals) {
        return BeanGenerator.collectQualifiers(beanDeployment, bc, annotationLiterals, injectionPoint.hasDefaultedQualifier() ? Collections.emptySet() : injectionPoint.getRequiredQualifiers());
    }

    public static Var collectQualifiers(BeanDeployment beanDeployment, BlockCreator bc, AnnotationLiteralProcessor annotationLiterals, Set<AnnotationInstance> qualifiers) {
        if (qualifiers.isEmpty()) {
            return Expr.staticField((FieldDesc)FieldDescs.QUALIFIERS_IP_QUALIFIERS);
        }
        LocalVar qualifiersVar = bc.localVar(FIELD_NAME_QUALIFIERS, bc.new_(HashSet.class));
        for (AnnotationInstance qualifier : qualifiers) {
            BuiltinQualifier builtinQualifier = BuiltinQualifier.of(qualifier);
            Object qualifierExpr = builtinQualifier != null ? builtinQualifier.getLiteralInstance() : annotationLiterals.create(bc, beanDeployment.getQualifier(qualifier.name()), qualifier);
            bc.withSet((Expr)qualifiersVar).add((Expr)qualifierExpr);
        }
        return qualifiersVar;
    }

    static void destroyTransientReferences(BlockCreator bc, Iterable<TransientReference> transientReferences) {
        for (TransientReference transientReference : transientReferences) {
            bc.invokeStatic(MethodDescs.INJECTABLE_REFERENCE_PROVIDERS_DESTROY, new Expr[]{transientReference.provider, transientReference.instance, transientReference.creationalContext});
        }
    }

    private static /* synthetic */ void lambda$generateCreateForSyntheticBean$61(LocalVar result, MethodDesc createSyntheticDesc, ClassCreator cc, Expr synthCC, BeanInfo bean, TryCreator tc) {
        tc.body(b1 -> b1.set((Assignable)result, b1.invokeVirtual(createSyntheticDesc, (Expr)cc.this_(), synthCC)));
        tc.catch_(Exception.class, "e", (b1, e) -> {
            Expr msg = StringBuilderGen.ofNew((BlockCreator)b1).append("Error creating synthetic bean [").append(bean.getIdentifier()).append("]: ").append((Expr)e).toString_();
            b1.throw_(b1.new_(ConstructorDesc.of(CreationException.class, (Class[])new Class[]{String.class, Throwable.class}), msg, (Expr)e));
        });
    }

    static final class ProviderType {
        private final org.jboss.jandex.Type type;
        private final ClassDesc desc;
        private final String className;

        public ProviderType(org.jboss.jandex.Type type) {
            this.type = type;
            this.desc = Jandex2Gizmo.classDescOf((org.jboss.jandex.Type)type);
            this.className = type.name().toString();
        }

        ClassDesc classDesc() {
            return this.desc;
        }

        DotName name() {
            return this.type.name();
        }

        String className() {
            return this.className;
        }
    }

    record TransientReference(Var provider, Var instance, Var creationalContext) {
    }
}

