/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.CurrentInjectionPointProvider;
import io.quarkus.arc.impl.InitializedInterceptor;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.FieldDescriptors;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.SubclassGenerator;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.literal.InjectLiteral;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.InvocationContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public class BeanGenerator
extends AbstractGenerator {
    static final String BEAN_SUFFIX = "_Bean";
    static final String PRODUCER_METHOD_SUFFIX = "_ProducerMethod";
    static final String PRODUCER_FIELD_SUFFIX = "_ProducerField";
    protected static final String FIELD_NAME_DECLARING_PROVIDER_SUPPLIER = "declaringProviderSupplier";
    protected static final String FIELD_NAME_BEAN_TYPES = "types";
    protected static final String FIELD_NAME_QUALIFIERS = "qualifiers";
    protected static final String FIELD_NAME_STEREOTYPES = "stereotypes";
    protected static final String FIELD_NAME_PROXY = "proxy";
    protected static final String FIELD_NAME_PARAMS = "params";
    protected final AnnotationLiteralProcessor annotationLiterals;
    protected final Predicate<DotName> applicationClassPredicate;
    protected final BeanProcessor.PrivateMembersCollector privateMembers;
    protected final ReflectionRegistration reflectionRegistration;
    protected final Set<String> existingClasses;
    protected final Map<BeanInfo, String> beanToGeneratedName;
    protected final Predicate<DotName> injectionPointAnnotationsPredicate;

    public BeanGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(generateSources);
        this.annotationLiterals = annotationLiterals;
        this.applicationClassPredicate = applicationClassPredicate;
        this.privateMembers = privateMembers;
        this.reflectionRegistration = reflectionRegistration;
        this.existingClasses = existingClasses;
        this.beanToGeneratedName = beanToGeneratedName;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
    }

    Collection<ResourceOutput.Resource> generate(BeanInfo bean) {
        if (bean.getTarget().isPresent()) {
            AnnotationTarget target = bean.getTarget().get();
            switch (target.kind()) {
                case CLASS: {
                    return this.generateClassBean(bean, target.asClass());
                }
                case METHOD: {
                    return this.generateProducerMethodBean(bean, target.asMethod());
                }
                case FIELD: {
                    return this.generateProducerFieldBean(bean, target.asField());
                }
            }
            throw new IllegalArgumentException("Unsupported bean type");
        }
        return this.generateSyntheticBean(bean);
    }

    Collection<ResourceOutput.Resource> generateSyntheticBean(BeanInfo bean) {
        ResultHandle paramsHandle;
        StringBuilder baseNameBuilder = new StringBuilder();
        if (bean.getImplClazz().enclosingClass() != null) {
            baseNameBuilder.append(DotNames.simpleName(bean.getImplClazz().enclosingClass())).append("_").append(DotNames.simpleName(bean.getImplClazz()));
        } else {
            baseNameBuilder.append(DotNames.simpleName(bean.getImplClazz()));
        }
        baseNameBuilder.append("_");
        baseNameBuilder.append(bean.getIdentifier());
        baseNameBuilder.append("_");
        baseNameBuilder.append("Synthetic");
        String baseName = baseNameBuilder.toString();
        org.jboss.jandex.Type providerType = bean.getProviderType();
        String providerTypeName = providerType.name().toString();
        String targetPackage = this.getPackageName(bean);
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(bean.getImplClazz().name());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        MethodCreator constructor = this.initConstructor(classOutput, beanCreator, bean, baseName, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, this.reflectionRegistration);
        FieldCreator params = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_PARAMS, Map.class).setModifiers(18);
        if (bean.getParams().isEmpty()) {
            paramsHandle = constructor.invokeStaticMethod(MethodDescriptors.COLLECTIONS_EMPTY_MAP, new ResultHandle[0]);
        } else {
            paramsHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (Map.Entry<String, Object> entry : bean.getParams().entrySet()) {
                ResultHandle valHandle = null;
                if (entry.getValue() instanceof String) {
                    valHandle = constructor.load(entry.getValue().toString());
                } else if (entry.getValue() instanceof Integer) {
                    valHandle = constructor.newInstance(MethodDescriptor.ofConstructor(Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{constructor.load(((Integer)entry.getValue()).intValue())});
                } else if (entry.getValue() instanceof Long) {
                    valHandle = constructor.newInstance(MethodDescriptor.ofConstructor(Long.class, (Class[])new Class[]{Long.TYPE}), new ResultHandle[]{constructor.load(((Long)entry.getValue()).longValue())});
                } else if (entry.getValue() instanceof Double) {
                    valHandle = constructor.newInstance(MethodDescriptor.ofConstructor(Double.class, (Class[])new Class[]{Double.TYPE}), new ResultHandle[]{constructor.load(((Double)entry.getValue()).doubleValue())});
                } else if (entry.getValue() instanceof Class) {
                    valHandle = constructor.loadClass((Class)entry.getValue());
                } else if (entry.getValue() instanceof Boolean) {
                    valHandle = constructor.load(((Boolean)entry.getValue()).booleanValue());
                }
                constructor.invokeInterfaceMethod(MethodDescriptors.MAP_PUT, paramsHandle, new ResultHandle[]{constructor.load(entry.getKey()), valHandle});
            }
        }
        constructor.writeInstanceField(params.getFieldDescriptor(), constructor.getThis(), paramsHandle);
        constructor.returnValue(null);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (!bean.hasDefaultDestroy()) {
            this.implementDestroy(bean, beanCreator, providerTypeName, Collections.emptyMap(), this.reflectionRegistration, isApplicationClass, baseName);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerTypeName, baseName, Collections.emptyMap(), Collections.emptyMap(), this.reflectionRegistration, targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerTypeName, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        if (bean.isAlternative()) {
            this.implementGetAlternativePriority(bean, beanCreator);
        }
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementGetKind(beanCreator, InjectableBean.Kind.SYNTHETIC);
        beanCreator.close();
        return classOutput.getResources();
    }

    Collection<ResourceOutput.Resource> generateClassBean(BeanInfo bean, ClassInfo beanClass) {
        String baseName = beanClass.enclosingClass() != null ? DotNames.simpleName(beanClass.enclosingClass()) + "_" + DotNames.simpleName(beanClass) : DotNames.simpleName(beanClass);
        org.jboss.jandex.Type providerType = bean.getProviderType();
        String providerTypeName = providerType.name().toString();
        String targetPackage = DotNames.packageName(providerType.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(beanClass.name());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderSupplierField = new HashMap<InjectionPointInfo, String>();
        HashMap<InterceptorInfo, String> interceptorToProviderSupplierField = new HashMap<InterceptorInfo, String>();
        this.initMaps(bean, injectionPointToProviderSupplierField, interceptorToProviderSupplierField);
        this.createProviderFields(beanCreator, bean, injectionPointToProviderSupplierField, interceptorToProviderSupplierField);
        this.createConstructor(classOutput, beanCreator, bean, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, this.annotationLiterals, this.reflectionRegistration);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (!bean.hasDefaultDestroy()) {
            this.implementDestroy(bean, beanCreator, providerTypeName, injectionPointToProviderSupplierField, this.reflectionRegistration, isApplicationClass, baseName);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerTypeName, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, this.reflectionRegistration, targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerTypeName, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        if (bean.isAlternative()) {
            this.implementGetAlternativePriority(bean, beanCreator);
        }
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        beanCreator.close();
        return classOutput.getResources();
    }

    Collection<ResourceOutput.Resource> generateProducerMethodBean(BeanInfo bean, MethodInfo producerMethod) {
        ClassInfo declaringClass = producerMethod.declaringClass();
        String declaringClassBase = declaringClass.enclosingClass() != null ? DotNames.simpleName(declaringClass.enclosingClass()) + "_" + DotNames.simpleName(declaringClass) : DotNames.simpleName(declaringClass);
        org.jboss.jandex.Type providerType = bean.getProviderType();
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(producerMethod.name()).append("_").append(producerMethod.returnType().name().toString());
        for (org.jboss.jandex.Type i : producerMethod.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String baseName = declaringClassBase + PRODUCER_METHOD_SUFFIX + "_" + producerMethod.name() + "_" + Hashes.sha1(sigBuilder.toString());
        String providerTypeName = providerType.name().toString();
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(declaringClass.name());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        HashMap<InjectionPointInfo, String> injectionPointToProviderField = new HashMap<InjectionPointInfo, String>();
        this.initMaps(bean, injectionPointToProviderField, null);
        this.createProviderFields(beanCreator, bean, injectionPointToProviderField, Collections.emptyMap());
        this.createConstructor(classOutput, beanCreator, bean, baseName, injectionPointToProviderField, Collections.emptyMap(), this.annotationLiterals, this.reflectionRegistration);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (!bean.hasDefaultDestroy()) {
            this.implementDestroy(bean, beanCreator, providerTypeName, injectionPointToProviderField, this.reflectionRegistration, isApplicationClass, baseName);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerTypeName, baseName, injectionPointToProviderField, Collections.emptyMap(), this.reflectionRegistration, targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerTypeName, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        if (bean.isAlternative()) {
            this.implementGetAlternativePriority(bean, beanCreator);
        }
        this.implementGetDeclaringBean(beanCreator);
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementGetKind(beanCreator, InjectableBean.Kind.PRODUCER_METHOD);
        beanCreator.close();
        return classOutput.getResources();
    }

    Collection<ResourceOutput.Resource> generateProducerFieldBean(BeanInfo bean, FieldInfo producerField) {
        ClassInfo declaringClass = producerField.declaringClass();
        String declaringClassBase = declaringClass.enclosingClass() != null ? DotNames.simpleName(declaringClass.enclosingClass()) + "_" + DotNames.simpleName(declaringClass) : DotNames.simpleName(declaringClass);
        org.jboss.jandex.Type providerType = bean.getProviderType();
        String baseName = declaringClassBase + PRODUCER_FIELD_SUFFIX + "_" + producerField.name();
        String providerTypeName = providerType.name().toString();
        String targetPackage = DotNames.packageName(declaringClass.name());
        String generatedName = BeanGenerator.generatedNameFromTarget(targetPackage, baseName, BEAN_SUFFIX);
        this.beanToGeneratedName.put(bean, generatedName);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(declaringClass.name());
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.BEAN : null, this.generateSources);
        ClassCreator beanCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{InjectableBean.class, Supplier.class}).build();
        FieldCreator beanTypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_BEAN_TYPES, Set.class).setModifiers(18);
        FieldCreator qualifiers = null;
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            qualifiers = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_QUALIFIERS, Set.class).setModifiers(18);
        }
        if (bean.getScope().isNormal()) {
            this.initializeProxy(bean, baseName, beanCreator);
        }
        FieldCreator stereotypes = null;
        if (!bean.getStereotypes().isEmpty()) {
            stereotypes = (FieldCreator)beanCreator.getFieldCreator(FIELD_NAME_STEREOTYPES, Set.class).setModifiers(18);
        }
        this.createProviderFields(beanCreator, bean, Collections.emptyMap(), Collections.emptyMap());
        this.createConstructor(classOutput, beanCreator, bean, baseName, Collections.emptyMap(), Collections.emptyMap(), this.annotationLiterals, this.reflectionRegistration);
        this.implementGetIdentifier(bean, beanCreator);
        this.implementSupplierGet(beanCreator);
        if (!bean.hasDefaultDestroy()) {
            this.implementDestroy(bean, beanCreator, providerTypeName, null, this.reflectionRegistration, isApplicationClass, baseName);
        }
        this.implementCreate(classOutput, beanCreator, bean, providerTypeName, baseName, Collections.emptyMap(), Collections.emptyMap(), this.reflectionRegistration, targetPackage, isApplicationClass);
        this.implementGet(bean, beanCreator, providerTypeName, baseName);
        this.implementGetTypes(beanCreator, beanTypes.getFieldDescriptor());
        if (!BuiltinScope.isDefault(bean.getScope())) {
            this.implementGetScope(bean, beanCreator);
        }
        if (qualifiers != null) {
            this.implementGetQualifiers(bean, beanCreator, qualifiers.getFieldDescriptor());
        }
        if (bean.isAlternative()) {
            this.implementGetAlternativePriority(bean, beanCreator);
        }
        this.implementGetDeclaringBean(beanCreator);
        if (stereotypes != null) {
            this.implementGetStereotypes(bean, beanCreator, stereotypes.getFieldDescriptor());
        }
        this.implementGetBeanClass(bean, beanCreator);
        this.implementGetName(bean, beanCreator);
        if (bean.isDefaultBean()) {
            this.implementIsDefaultBean(bean, beanCreator);
        }
        this.implementGetKind(beanCreator, InjectableBean.Kind.PRODUCER_FIELD);
        beanCreator.close();
        return classOutput.getResources();
    }

    protected void initMaps(BeanInfo bean, Map<InjectionPointInfo, String> injectionPointToProvider, Map<InterceptorInfo, String> interceptorToProvider) {
        int providerIdx = 1;
        for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
            injectionPointToProvider.put(injectionPoint, "injectProviderSupplier" + providerIdx++);
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                injectionPointToProvider.put(injectionPoint, "disposerProviderSupplier" + providerIdx++);
            }
        }
        for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
            interceptorToProvider.put(interceptor, "interceptorProviderSupplier" + providerIdx++);
        }
    }

    protected void createProviderFields(ClassCreator beanCreator, BeanInfo bean, Map<InjectionPointInfo, String> injectionPointToProviderSupplier, Map<InterceptorInfo, String> interceptorToProviderSupplier) {
        if (bean.isProducerMethod() || bean.isProducerField()) {
            beanCreator.getFieldCreator(FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, Supplier.class).setModifiers(18);
        }
        for (String provider : injectionPointToProviderSupplier.values()) {
            beanCreator.getFieldCreator(provider, Supplier.class).setModifiers(18);
        }
        for (String interceptorProvider : interceptorToProviderSupplier.values()) {
            beanCreator.getFieldCreator(interceptorProvider, Supplier.class).setModifiers(18);
        }
    }

    protected void createConstructor(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderField, Map<InterceptorInfo, String> interceptorToProviderField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        this.initConstructor(classOutput, beanCreator, bean, baseName, injectionPointToProviderField, interceptorToProviderField, annotationLiterals, reflectionRegistration).returnValue(null);
    }

    protected MethodCreator initConstructor(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderField, Map<InterceptorInfo, String> interceptorToProviderField, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (bean.isProducerMethod() || bean.isProducerField()) {
            parameterTypes.add(Supplier.class.getName());
        }
        for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
            if (BuiltinBean.resolve(injectionPoint) != null) continue;
            parameterTypes.add(Supplier.class.getName());
        }
        if (bean.getDisposer() != null) {
            for (InjectionPointInfo injectionPoint : bean.getDisposer().getInjection().injectionPoints) {
                if (BuiltinBean.resolve(injectionPoint) != null) continue;
                parameterTypes.add(Supplier.class.getName());
            }
        }
        for (int i = 0; i < interceptorToProviderField.size(); ++i) {
            parameterTypes.add(Supplier.class.getName());
        }
        MethodCreator constructor = beanCreator.getMethodCreator("<init>", "V", parameterTypes.toArray(new String[0]));
        constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        ResultHandle currentThread = constructor.invokeStaticMethod(MethodDescriptors.THREAD_CURRENT_THREAD, new ResultHandle[0]);
        ResultHandle tccl = constructor.invokeVirtualMethod(MethodDescriptors.THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
        int paramIdx = 0;
        if (bean.isProducerMethod() || bean.isProducerField()) {
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(0));
            ++paramIdx;
        }
        ArrayList<InjectionPointInfo> allInjectionPoints = new ArrayList<InjectionPointInfo>();
        allInjectionPoints.addAll(bean.getAllInjectionPoints());
        if (bean.getDisposer() != null) {
            allInjectionPoints.addAll(bean.getDisposer().getInjection().injectionPoints);
        }
        for (InjectionPointInfo injectionPointInfo : allInjectionPoints) {
            BuiltinBean builtinBean = null;
            if (injectionPointInfo.getResolvedBean() == null) {
                builtinBean = BuiltinBean.resolve(injectionPointInfo);
            }
            if (builtinBean != null) {
                builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(classOutput, bean.getDeployment(), injectionPointInfo, beanCreator, constructor, injectionPointToProviderField.get(injectionPointInfo), annotationLiterals, bean, reflectionRegistration, this.injectionPointAnnotationsPredicate));
                continue;
            }
            if (BuiltinScope.DEPENDENT.is(injectionPointInfo.getResolvedBean().getScope()) && (injectionPointInfo.getResolvedBean().getAllInjectionPoints().stream().anyMatch(ip -> BuiltinBean.INJECTION_POINT.hasRawTypeDotName(ip.getRequiredType().name())) || injectionPointInfo.getResolvedBean().isSynthetic())) {
                ResultHandle wrapHandle = this.wrapCurrentInjectionPoint(classOutput, beanCreator, bean, constructor, injectionPointInfo, paramIdx++, tccl, reflectionRegistration);
                ResultHandle wrapSupplierHandle = constructor.newInstance(MethodDescriptors.FIXED_VALUE_SUPPLIER_CONSTRUCTOR, new ResultHandle[]{wrapHandle});
                constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPointInfo), (String)Supplier.class.getName()), constructor.getThis(), wrapSupplierHandle);
                continue;
            }
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPointInfo), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx++));
        }
        for (InterceptorInfo interceptorInfo : bean.getBoundInterceptors()) {
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderField.get(interceptorInfo), (String)Supplier.class.getName()), constructor.getThis(), constructor.getMethodParam(paramIdx++));
        }
        ResultHandle typesHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (org.jboss.jandex.Type type : bean.getTypes()) {
            ResultHandle typeHandle;
            try {
                typeHandle = Types.getTypeHandle((BytecodeCreator)constructor, type, tccl);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to construct the type handle for " + bean + ": " + e.getMessage());
            }
            constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, typesHandle, new ResultHandle[]{typeHandle});
        }
        ResultHandle resultHandle = constructor.invokeStaticMethod(MethodDescriptors.COLLECTIONS_UNMODIFIABLE_SET, new ResultHandle[]{typesHandle});
        constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_BEAN_TYPES, (String)Set.class.getName()), constructor.getThis(), resultHandle);
        if (!bean.getQualifiers().isEmpty() && !bean.hasDefaultQualifiers()) {
            ResultHandle qualifiersHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance qualifierAnnotation : bean.getQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                if (qualifier != null) {
                    constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{qualifier.getLiteralInstance((BytecodeCreator)constructor)});
                    continue;
                }
                ClassInfo qualifierClass = bean.getDeployment().getQualifier(qualifierAnnotation.name());
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, qualifiersHandle, new ResultHandle[]{annotationLiterals.process((BytecodeCreator)constructor, classOutput, qualifierClass, qualifierAnnotation, Types.getPackageName(beanCreator.getClassName()))});
            }
            ResultHandle unmodifiableQualifiersHandle = constructor.invokeStaticMethod(MethodDescriptors.COLLECTIONS_UNMODIFIABLE_SET, new ResultHandle[]{qualifiersHandle});
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_QUALIFIERS, (String)Set.class.getName()), constructor.getThis(), unmodifiableQualifiersHandle);
        }
        if (!bean.getStereotypes().isEmpty()) {
            ResultHandle stereotypesHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (StereotypeInfo stereotype : bean.getStereotypes()) {
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, stereotypesHandle, new ResultHandle[]{constructor.loadClass(stereotype.getTarget().name().toString())});
            }
            ResultHandle unmodifiableStereotypesHandle = constructor.invokeStaticMethod(MethodDescriptors.COLLECTIONS_UNMODIFIABLE_SET, new ResultHandle[]{stereotypesHandle});
            constructor.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_STEREOTYPES, (String)Set.class.getName()), constructor.getThis(), unmodifiableStereotypesHandle);
        }
        return constructor;
    }

    protected void implementDestroy(BeanInfo bean, ClassCreator beanCreator, String providerTypeName, Map<InjectionPointInfo, String> injectionPointToProviderField, ReflectionRegistration reflectionRegistration, boolean isApplicationClass, String baseName) {
        MethodCreator destroy = (MethodCreator)beanCreator.getMethodCreator("destroy", Void.TYPE, new Object[]{providerTypeName, CreationalContext.class}).setModifiers(1);
        if (bean.isClassBean()) {
            if (!bean.isInterceptor()) {
                if (!bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY).isEmpty()) {
                    destroy.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)SubclassGenerator.generatedName(bean.getProviderType().name(), baseName), (String)"arc$destroy", Void.TYPE, (Object[])new Object[0]), destroy.getMethodParam(0), new ResultHandle[0]);
                }
                List<MethodInfo> preDestroyCallbacks = Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.PRE_DESTROY, bean.getDeployment().getIndex());
                for (MethodInfo callback : preDestroyCallbacks) {
                    if (Modifier.isPrivate(callback.flags())) {
                        this.privateMembers.add(isApplicationClass, String.format("@PreDestroy callback %s#%s()", callback.declaringClass().name(), callback.name()));
                        reflectionRegistration.registerMethod(callback);
                        destroy.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{destroy.loadClass(callback.declaringClass().name().toString()), destroy.load(callback.name()), destroy.newArray(Class.class, destroy.load(0)), destroy.getMethodParam(0), destroy.newArray(Object.class, destroy.load(0))});
                        continue;
                    }
                    destroy.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback), destroy.getMethodParam(0), new ResultHandle[0]);
                }
            }
            destroy.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, destroy.getMethodParam(1), new ResultHandle[0]);
            destroy.returnValue(null);
        } else if (bean.getDisposer() != null) {
            MethodInfo disposerMethod = bean.getDisposer().getDisposerMethod();
            ResultHandle declaringProviderSupplierHandle = destroy.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), destroy.getThis());
            ResultHandle declaringProviderHandle = destroy.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
            ResultHandle ctxHandle = destroy.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{destroy.loadNull()});
            ResultHandle declaringProviderInstanceHandle = destroy.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle});
            if (bean.getDeclaringBean().getScope().isNormal()) {
                declaringProviderInstanceHandle = destroy.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, declaringProviderInstanceHandle, new ResultHandle[0]);
            }
            ResultHandle[] referenceHandles = new ResultHandle[disposerMethod.parameters().size()];
            short disposedParamPosition = bean.getDisposer().getDisposedParameter().position();
            Iterator<InjectionPointInfo> injectionPointsIterator = bean.getDisposer().getInjection().injectionPoints.iterator();
            for (int i = 0; i < disposerMethod.parameters().size(); ++i) {
                ResultHandle referenceHandle;
                if (i == disposedParamPosition) {
                    referenceHandles[i] = destroy.getMethodParam(0);
                    continue;
                }
                ResultHandle childCtxHandle = destroy.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{declaringProviderHandle, ctxHandle});
                ResultHandle providerSupplierHandle = destroy.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPointsIterator.next()), (String)Supplier.class.getName()), destroy.getThis());
                ResultHandle providerHandle = destroy.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                referenceHandles[i] = referenceHandle = destroy.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle});
            }
            if (Modifier.isPrivate(disposerMethod.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Disposer %s#%s", disposerMethod.declaringClass().name(), disposerMethod.name()));
                ResultHandle paramTypesArray = destroy.newArray(Class.class, destroy.load(referenceHandles.length));
                ResultHandle argsArray = destroy.newArray(Object.class, destroy.load(referenceHandles.length));
                for (int i = 0; i < referenceHandles.length; ++i) {
                    destroy.writeArrayValue(paramTypesArray, i, destroy.loadClass(((org.jboss.jandex.Type)disposerMethod.parameters().get(i)).name().toString()));
                    destroy.writeArrayValue(argsArray, i, referenceHandles[i]);
                }
                reflectionRegistration.registerMethod(disposerMethod);
                destroy.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{destroy.loadClass(disposerMethod.declaringClass().name().toString()), destroy.load(disposerMethod.name()), paramTypesArray, declaringProviderInstanceHandle, argsArray});
            } else {
                destroy.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)disposerMethod), declaringProviderInstanceHandle, referenceHandles);
            }
            destroy.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, ctxHandle, new ResultHandle[0]);
            if (BuiltinScope.DEPENDENT.is(bean.getDisposer().getDeclaringBean().getScope())) {
                destroy.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
            }
            destroy.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, destroy.getMethodParam(1), new ResultHandle[0]);
            destroy.returnValue(null);
        } else if (bean.isSynthetic()) {
            bean.getDestroyerConsumer().accept(destroy);
        }
        MethodCreator bridgeDestroy = (MethodCreator)beanCreator.getMethodCreator("destroy", Void.TYPE, new Class[]{Object.class, CreationalContext.class}).setModifiers(1);
        bridgeDestroy.returnValue(bridgeDestroy.invokeVirtualMethod(destroy.getMethodDescriptor(), bridgeDestroy.getThis(), new ResultHandle[]{bridgeDestroy.getMethodParam(0), bridgeDestroy.getMethodParam(1)}));
    }

    protected void implementCreate(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, String providerTypeName, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, Map<InterceptorInfo, String> interceptorToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass) {
        MethodCreator create = (MethodCreator)beanCreator.getMethodCreator("create", (Object)providerTypeName, new Object[]{CreationalContext.class}).setModifiers(1);
        if (bean.isClassBean()) {
            this.implementCreateForClassBean(classOutput, beanCreator, bean, providerTypeName, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, reflectionRegistration, targetPackage, isApplicationClass, create);
        } else if (bean.isProducerMethod()) {
            this.implementCreateForProducerMethod(classOutput, beanCreator, bean, providerTypeName, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, reflectionRegistration, targetPackage, isApplicationClass, create);
        } else if (bean.isProducerField()) {
            this.implementCreateForProducerField(classOutput, beanCreator, bean, providerTypeName, baseName, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, reflectionRegistration, targetPackage, isApplicationClass, create);
        } else if (bean.isSynthetic()) {
            bean.getCreatorConsumer().accept(create);
        }
        MethodCreator bridgeCreate = (MethodCreator)beanCreator.getMethodCreator("create", Object.class, new Class[]{CreationalContext.class}).setModifiers(65);
        bridgeCreate.returnValue(bridgeCreate.invokeVirtualMethod(create.getMethodDescriptor(), bridgeCreate.getThis(), new ResultHandle[]{bridgeCreate.getMethodParam(0)}));
    }

    private List<ResultHandle> newProviderHandles(BeanInfo bean, ClassCreator beanCreator, MethodCreator createMethod, Map<InjectionPointInfo, String> injectionPointToProviderField, Map<InterceptorInfo, String> interceptorToProviderField, Map<InterceptorInfo, ResultHandle> interceptorToWrap, List<TransientReference> transientReferences) {
        ArrayList<ResultHandle> providerHandles = new ArrayList<ResultHandle>();
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        if (constructorInjection.isPresent()) {
            for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                ResultHandle providerSupplierHandle = createMethod.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderField.get(injectionPoint), (String)Supplier.class.getName()), createMethod.getThis());
                ResultHandle providerHandle = createMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                ResultHandle childCtx = createMethod.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, createMethod.getMethodParam(0)});
                ResultHandle referenceHandle = createMethod.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtx});
                providerHandles.add(referenceHandle);
                if (!injectionPoint.isDependentTransientReference()) continue;
                transientReferences.add(new TransientReference(providerHandle, referenceHandle, childCtx));
            }
        }
        if (bean.isSubclassRequired()) {
            for (InterceptorInfo interceptor : bean.getBoundInterceptors()) {
                ResultHandle wrapped = interceptorToWrap.get(interceptor);
                if (wrapped != null) {
                    providerHandles.add(wrapped);
                    continue;
                }
                ResultHandle interceptorProviderSupplierHandle = createMethod.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderField.get(interceptor), Supplier.class), createMethod.getThis());
                ResultHandle interceptorProviderHandle = createMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorProviderSupplierHandle, new ResultHandle[0]);
                providerHandles.add(interceptorProviderHandle);
            }
        }
        return providerHandles;
    }

    private ResultHandle newInstanceHandle(BeanInfo bean, ClassCreator beanCreator, BytecodeCreator creator, MethodCreator createMethod, String providerTypeName, String baseName, List<ResultHandle> providerHandles, ReflectionRegistration registration, boolean isApplicationClass) {
        List injectionPoints;
        Optional<Injection> constructorInjection = bean.getConstructorInjection();
        MethodInfo constructor = constructorInjection.isPresent() ? constructorInjection.get().target.asMethod() : null;
        List<Object> list = injectionPoints = constructorInjection.isPresent() ? constructorInjection.get().injectionPoints : Collections.emptyList();
        if (bean.isSubclassRequired()) {
            int i;
            List<InterceptorInfo> interceptors = bean.getBoundInterceptors();
            ArrayList<String> paramTypes = new ArrayList<String>();
            ArrayList<ResultHandle> paramHandles = new ArrayList<ResultHandle>();
            for (i = 0; i < injectionPoints.size(); ++i) {
                paramTypes.add(((InjectionPointInfo)injectionPoints.get(i)).getRequiredType().name().toString());
                paramHandles.add(providerHandles.get(i));
            }
            paramHandles.add(createMethod.getMethodParam(0));
            paramTypes.add(CreationalContext.class.getName());
            for (i = 0; i < interceptors.size(); ++i) {
                paramTypes.add(InjectableInterceptor.class.getName());
                paramHandles.add(providerHandles.get(injectionPoints.size() + i));
            }
            return creator.newInstance(MethodDescriptor.ofConstructor((String)SubclassGenerator.generatedName(bean.getProviderType().name(), baseName), (String[])paramTypes.toArray(new String[0])), paramHandles.toArray(new ResultHandle[0]));
        }
        if (constructorInjection.isPresent()) {
            if (Modifier.isPrivate(constructor.flags())) {
                this.privateMembers.add(isApplicationClass, String.format("Bean constructor %s on %s", constructor, constructor.declaringClass().name()));
                ResultHandle paramTypesArray = creator.newArray(Class.class, creator.load(providerHandles.size()));
                ResultHandle argsArray = creator.newArray(Object.class, creator.load(providerHandles.size()));
                for (int i = 0; i < injectionPoints.size(); ++i) {
                    creator.writeArrayValue(paramTypesArray, i, creator.loadClass(((InjectionPointInfo)injectionPoints.get(i)).getRequiredType().name().toString()));
                    creator.writeArrayValue(argsArray, i, providerHandles.get(i));
                }
                registration.registerMethod(constructor);
                return creator.invokeStaticMethod(MethodDescriptors.REFLECTIONS_NEW_INSTANCE, new ResultHandle[]{creator.loadClass(constructor.declaringClass().name().toString()), paramTypesArray, argsArray});
            }
            String[] paramTypes = new String[injectionPoints.size()];
            ListIterator iterator = injectionPoints.listIterator();
            while (iterator.hasNext()) {
                InjectionPointInfo injectionPoint = (InjectionPointInfo)iterator.next();
                paramTypes[iterator.previousIndex()] = injectionPoint.getRequiredType().name().toString();
            }
            return creator.newInstance(MethodDescriptor.ofConstructor((String)providerTypeName, (String[])paramTypes), providerHandles.toArray(new ResultHandle[0]));
        }
        MethodInfo noArgsConstructor = bean.getTarget().get().asClass().method("<init>", new org.jboss.jandex.Type[0]);
        if (Modifier.isPrivate(noArgsConstructor.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Bean constructor %s on %s", noArgsConstructor, noArgsConstructor.declaringClass().name()));
            ResultHandle paramTypesArray = creator.newArray(Class.class, creator.load(0));
            ResultHandle argsArray = creator.newArray(Object.class, creator.load(0));
            registration.registerMethod(noArgsConstructor);
            return creator.invokeStaticMethod(MethodDescriptors.REFLECTIONS_NEW_INSTANCE, new ResultHandle[]{creator.loadClass(noArgsConstructor.declaringClass().name().toString()), paramTypesArray, argsArray});
        }
        return creator.newInstance(MethodDescriptor.ofConstructor((String)providerTypeName, (String[])new String[0]), new ResultHandle[0]);
    }

    void implementCreateForProducerField(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, String providerTypeName, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, Map<InterceptorInfo, String> interceptorToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass, MethodCreator create) {
        ResultHandle declaringProviderInstanceHandle;
        AssignableResultHandle instanceHandle = create.createVariable(DescriptorUtils.extToInt((String)providerTypeName));
        FieldInfo producerField = bean.getTarget().get().asField();
        ResultHandle declaringProviderSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), create.getThis());
        ResultHandle declaringProviderHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
        ResultHandle ctxHandle = create.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{create.getThis()});
        if (Modifier.isStatic(producerField.flags())) {
            declaringProviderInstanceHandle = create.loadNull();
        } else {
            declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle});
            if (bean.getDeclaringBean().getScope().isNormal()) {
                declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, declaringProviderInstanceHandle, new ResultHandle[0]);
            }
        }
        if (Modifier.isPrivate(producerField.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Producer field %s#%s", producerField.declaringClass().name(), producerField.name()));
            reflectionRegistration.registerField(producerField);
            create.assign(instanceHandle, create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_READ_FIELD, new ResultHandle[]{create.loadClass(producerField.declaringClass().name().toString()), create.load(producerField.name()), declaringProviderInstanceHandle}));
        } else {
            ResultHandle readFieldHandle = Modifier.isStatic(producerField.flags()) ? create.readStaticField(FieldDescriptor.of((FieldInfo)producerField)) : create.readInstanceField(FieldDescriptor.of((FieldInfo)producerField), declaringProviderInstanceHandle);
            create.assign(instanceHandle, readFieldHandle);
        }
        if (bean.getScope().isNormal()) {
            create.ifNull((ResultHandle)instanceHandle).trueBranch().throwException(IllegalProductException.class, "Normal scoped producer field may not be null: " + bean.getDeclaringBean().getImplClazz().name() + "." + bean.getTarget().get().asField().name());
        }
        if (BuiltinScope.DEPENDENT.is(bean.getDeclaringBean().getScope())) {
            create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
        }
        create.returnValue((ResultHandle)instanceHandle);
    }

    void implementCreateForProducerMethod(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, String providerTypeName, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, Map<InterceptorInfo, String> interceptorToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass, MethodCreator create) {
        ResultHandle declaringProviderInstanceHandle;
        MethodInfo producerMethod = bean.getTarget().get().asMethod();
        AssignableResultHandle instanceHandle = create.createVariable(DescriptorUtils.extToInt((String)providerTypeName));
        ResultHandle ctxHandle = create.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{create.getThis()});
        ResultHandle declaringProviderSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), create.getThis());
        ResultHandle declaringProviderHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]);
        if (Modifier.isStatic(producerMethod.flags())) {
            declaringProviderInstanceHandle = create.loadNull();
        } else {
            declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, declaringProviderHandle, new ResultHandle[]{ctxHandle});
            if (bean.getDeclaringBean().getScope().isNormal()) {
                declaringProviderInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.CLIENT_PROXY_GET_CONTEXTUAL_INSTANCE, declaringProviderInstanceHandle, new ResultHandle[0]);
            }
        }
        List<InjectionPointInfo> injectionPoints = bean.getAllInjectionPoints();
        ResultHandle[] referenceHandles = new ResultHandle[injectionPoints.size()];
        ArrayList<TransientReference> transientReferences = new ArrayList<TransientReference>();
        int paramIdx = 0;
        for (InjectionPointInfo injectionPoint : injectionPoints) {
            ResultHandle providerSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), create.getThis());
            ResultHandle providerHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
            ResultHandle childCtxHandle = create.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, create.getMethodParam(0)});
            ResultHandle referenceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle});
            referenceHandles[paramIdx++] = referenceHandle;
            if (!injectionPoint.isDependentTransientReference()) continue;
            transientReferences.add(new TransientReference(providerHandle, referenceHandle, childCtxHandle));
        }
        if (Modifier.isPrivate(producerMethod.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Producer method %s#%s()", producerMethod.declaringClass().name(), producerMethod.name()));
            ResultHandle paramTypesArray = create.newArray(Class.class, create.load(referenceHandles.length));
            ResultHandle argsArray = create.newArray(Object.class, create.load(referenceHandles.length));
            for (int i = 0; i < referenceHandles.length; ++i) {
                create.writeArrayValue(paramTypesArray, i, create.loadClass(((org.jboss.jandex.Type)producerMethod.parameters().get(i)).name().toString()));
                create.writeArrayValue(argsArray, i, referenceHandles[i]);
            }
            reflectionRegistration.registerMethod(producerMethod);
            create.assign(instanceHandle, create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{create.loadClass(producerMethod.declaringClass().name().toString()), create.load(producerMethod.name()), paramTypesArray, declaringProviderInstanceHandle, argsArray}));
        } else {
            ResultHandle invokeMethodHandle = Modifier.isStatic(producerMethod.flags()) ? create.invokeStaticMethod(MethodDescriptor.of((MethodInfo)producerMethod), referenceHandles) : create.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)producerMethod), declaringProviderInstanceHandle, referenceHandles);
            create.assign(instanceHandle, invokeMethodHandle);
        }
        if (bean.getScope().isNormal()) {
            create.ifNull((ResultHandle)instanceHandle).trueBranch().throwException(IllegalProductException.class, "Normal scoped producer method may not return null: " + bean.getDeclaringBean().getImplClazz().name() + "." + bean.getTarget().get().asMethod().name() + "()");
        }
        if (BuiltinScope.DEPENDENT.is(bean.getDeclaringBean().getScope())) {
            create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_BEAN_DESTROY, declaringProviderHandle, new ResultHandle[]{declaringProviderInstanceHandle, ctxHandle});
        }
        BeanGenerator.destroyTransientReferences((BytecodeCreator)create, transientReferences);
        create.returnValue((ResultHandle)instanceHandle);
    }

    void implementCreateForClassBean(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, String providerTypeName, String baseName, Map<InjectionPointInfo, String> injectionPointToProviderSupplierField, Map<InterceptorInfo, String> interceptorToProviderSupplierField, ReflectionRegistration reflectionRegistration, String targetPackage, boolean isApplicationClass, MethodCreator create) {
        Object transientReferences;
        ArrayList<Injection> methodInjections = new ArrayList<Injection>();
        ArrayList<Injection> fieldInjections = new ArrayList<Injection>();
        for (Injection injection : bean.getInjections()) {
            if (injection.isField()) {
                fieldInjections.add(injection);
                continue;
            }
            if (!injection.isMethod() || injection.isConstructor()) continue;
            methodInjections.add(injection);
        }
        ResultHandle postConstructsHandle = null;
        ResultHandle aroundConstructsHandle = null;
        HashMap<InterceptorInfo, ResultHandle> interceptorToWrap = new HashMap<InterceptorInfo, ResultHandle>();
        if (bean.hasLifecycleInterceptors()) {
            ResultHandle interceptorInvocationHandle;
            ResultHandle interceptorHandle;
            ResultHandle interceptorSupplierHandle;
            BeanInfo.InterceptionInfo postConstructs = bean.getLifecycleInterceptors(InterceptionType.POST_CONSTRUCT);
            BeanInfo.InterceptionInfo aroundConstructs = bean.getLifecycleInterceptors(InterceptionType.AROUND_CONSTRUCT);
            HashSet<InterceptorInfo> wraps = new HashSet<InterceptorInfo>();
            wraps.addAll(aroundConstructs.interceptors);
            wraps.addAll(postConstructs.interceptors);
            HashMap<InterceptorInfo, ResultHandle> interceptorToResultHandle = new HashMap<InterceptorInfo, ResultHandle>();
            for (InterceptorInfo interceptor : wraps) {
                ResultHandle interceptorProviderSupplier = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderSupplierField.get(interceptor), (String)Supplier.class.getName()), create.getThis());
                ResultHandle interceptorProvider = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorProviderSupplier, new ResultHandle[0]);
                ResultHandle childCtxHandle = create.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD, new ResultHandle[]{create.getMethodParam(0)});
                ResultHandle interceptorInstanceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, interceptorProvider, new ResultHandle[]{childCtxHandle});
                interceptorToResultHandle.put(interceptor, interceptorInstanceHandle);
                ResultHandle wrapHandle = create.invokeStaticMethod(MethodDescriptor.ofMethod(InitializedInterceptor.class, (String)"of", InitializedInterceptor.class, (Class[])new Class[]{Object.class, InjectableInterceptor.class}), new ResultHandle[]{interceptorInstanceHandle, interceptorProvider});
                interceptorToWrap.put(interceptor, wrapHandle);
            }
            if (!postConstructs.isEmpty()) {
                postConstructsHandle = create.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (InterceptorInfo interceptor : postConstructs.interceptors) {
                    interceptorSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderSupplierField.get(interceptor), (String)Supplier.class.getName()), create.getThis());
                    interceptorHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorSupplierHandle, new ResultHandle[0]);
                    interceptorInvocationHandle = create.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_POST_CONSTRUCT, new ResultHandle[]{interceptorHandle, (ResultHandle)interceptorToResultHandle.get(interceptor)});
                    create.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, postConstructsHandle, new ResultHandle[]{interceptorInvocationHandle});
                }
            }
            if (!aroundConstructs.isEmpty()) {
                aroundConstructsHandle = create.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0]);
                for (InterceptorInfo interceptor : aroundConstructs.interceptors) {
                    interceptorSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)interceptorToProviderSupplierField.get(interceptor), (String)Supplier.class.getName()), create.getThis());
                    interceptorHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, interceptorSupplierHandle, new ResultHandle[0]);
                    interceptorInvocationHandle = create.invokeStaticMethod(MethodDescriptors.INTERCEPTOR_INVOCATION_AROUND_CONSTRUCT, new ResultHandle[]{interceptorHandle, (ResultHandle)interceptorToResultHandle.get(interceptor)});
                    create.invokeInterfaceMethod(MethodDescriptors.LIST_ADD, aroundConstructsHandle, new ResultHandle[]{interceptorInvocationHandle});
                }
            }
        }
        BeanInfo.InterceptionInfo aroundConstructs = bean.getLifecycleInterceptors(InterceptionType.AROUND_CONSTRUCT);
        AssignableResultHandle instanceHandle = create.createVariable(DescriptorUtils.extToInt((String)providerTypeName));
        if (!aroundConstructs.isEmpty()) {
            ResultHandle constructorHandle;
            Optional<Injection> constructorInjection = bean.getConstructorInjection();
            if (constructorInjection.isPresent()) {
                ArrayList<String> paramTypes = new ArrayList<String>();
                for (InjectionPointInfo injectionPoint : constructorInjection.get().injectionPoints) {
                    paramTypes.add(injectionPoint.getRequiredType().name().toString());
                }
                ResultHandle[] paramsHandles = new ResultHandle[2];
                paramsHandles[0] = create.loadClass(providerTypeName);
                ResultHandle paramsArray = create.newArray(Class.class, create.load(paramTypes.size()));
                ListIterator iterator = paramTypes.listIterator();
                while (iterator.hasNext()) {
                    create.writeArrayValue(paramsArray, iterator.nextIndex(), create.loadClass((String)iterator.next()));
                }
                paramsHandles[1] = paramsArray;
                constructorHandle = create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_CONSTRUCTOR, paramsHandles);
                reflectionRegistration.registerMethod(constructorInjection.get().target.asMethod());
            } else {
                ResultHandle[] paramsHandles = new ResultHandle[]{create.loadClass(providerTypeName), create.newArray(Class.class, create.load(0))};
                constructorHandle = create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_CONSTRUCTOR, paramsHandles);
                MethodInfo noArgsConstructor = bean.getTarget().get().asClass().method("<init>", new org.jboss.jandex.Type[0]);
                reflectionRegistration.registerMethod(noArgsConstructor);
            }
            transientReferences = new ArrayList<TransientReference>();
            List<ResultHandle> providerHandles = this.newProviderHandles(bean, beanCreator, create, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, (Map<InterceptorInfo, ResultHandle>)interceptorToWrap, (List<TransientReference>)transientReferences);
            FunctionCreator func = create.createFunction(Supplier.class);
            BytecodeCreator funcBytecode = func.getBytecode();
            ResultHandle retHandle = this.newInstanceHandle(bean, beanCreator, funcBytecode, create, providerTypeName, baseName, providerHandles, reflectionRegistration, isApplicationClass);
            BeanGenerator.destroyTransientReferences(funcBytecode, (Iterable<TransientReference>)transientReferences);
            funcBytecode.returnValue(retHandle);
            ResultHandle bindingsHandle = create.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : aroundConstructs.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                create.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)create, classOutput, bindingClass, binding, Types.getPackageName(beanCreator.getClassName()))});
            }
            ResultHandle invocationContextHandle = create.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_AROUND_CONSTRUCT, new ResultHandle[]{constructorHandle, aroundConstructsHandle, func.getInstance(), bindingsHandle});
            TryBlock tryCatch = create.tryBlock();
            CatchBlockCreator exceptionCatch = tryCatch.addCatch(Exception.class);
            exceptionCatch.throwException(RuntimeException.class, "Error invoking aroundConstructs", exceptionCatch.getCaughtException());
            tryCatch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_PROCEED, invocationContextHandle, new ResultHandle[0]);
            tryCatch.assign(instanceHandle, tryCatch.invokeInterfaceMethod(MethodDescriptors.INVOCATION_CONTEXT_GET_TARGET, invocationContextHandle, new ResultHandle[0]));
        } else {
            Iterator transientReferences2 = new ArrayList<TransientReference>();
            create.assign(instanceHandle, this.newInstanceHandle(bean, beanCreator, (BytecodeCreator)create, create, providerTypeName, baseName, this.newProviderHandles(bean, beanCreator, create, injectionPointToProviderSupplierField, interceptorToProviderSupplierField, (Map<InterceptorInfo, ResultHandle>)interceptorToWrap, (List<TransientReference>)((Object)transientReferences2)), reflectionRegistration, isApplicationClass));
            BeanGenerator.destroyTransientReferences((BytecodeCreator)create, transientReferences2);
        }
        for (Injection fieldInjection : fieldInjections) {
            TryBlock tryBlock = create.tryBlock();
            InjectionPointInfo injectionPoint = fieldInjection.injectionPoints.get(0);
            ResultHandle providerSupplierHandle = tryBlock.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), tryBlock.getThis());
            ResultHandle providerHandle = tryBlock.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
            ResultHandle childCtxHandle = tryBlock.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, tryBlock.getMethodParam(0)});
            ResultHandle referenceHandle = tryBlock.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle});
            FieldInfo injectedField = fieldInjection.target.asField();
            if (this.isReflectionFallbackNeeded(injectedField, targetPackage)) {
                if (Modifier.isPrivate(injectedField.flags())) {
                    this.privateMembers.add(isApplicationClass, String.format("@Inject field %s#%s", fieldInjection.target.asField().declaringClass().name(), fieldInjection.target.asField().name()));
                }
                reflectionRegistration.registerField(injectedField);
                tryBlock.invokeStaticMethod(MethodDescriptors.REFLECTIONS_WRITE_FIELD, new ResultHandle[]{tryBlock.loadClass(injectedField.declaringClass().name().toString()), tryBlock.load(injectedField.name()), instanceHandle, referenceHandle});
            } else {
                String fieldType = injectionPoint.getTarget().asField().type().name().toString();
                tryBlock.writeInstanceField(FieldDescriptor.of((String)providerTypeName, (String)injectedField.name(), (String)fieldType), (ResultHandle)instanceHandle, referenceHandle);
            }
            CatchBlockCreator catchBlock = tryBlock.addCatch(RuntimeException.class);
            catchBlock.throwException(RuntimeException.class, "Error injecting " + fieldInjection.target, catchBlock.getCaughtException());
        }
        for (Injection methodInjection : methodInjections) {
            transientReferences = new ArrayList();
            ResultHandle[] referenceHandles = new ResultHandle[methodInjection.injectionPoints.size()];
            int paramIdx = 0;
            for (InjectionPointInfo injectionPoint : methodInjection.injectionPoints) {
                ResultHandle providerSupplierHandle = create.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)injectionPointToProviderSupplierField.get(injectionPoint), (String)Supplier.class.getName()), create.getThis());
                ResultHandle providerHandle = create.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, providerSupplierHandle, new ResultHandle[0]);
                ResultHandle childCtxHandle = create.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{providerHandle, create.getMethodParam(0)});
                ResultHandle referenceHandle = create.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, providerHandle, new ResultHandle[]{childCtxHandle});
                referenceHandles[paramIdx++] = referenceHandle;
                if (!injectionPoint.isDependentTransientReference()) continue;
                transientReferences.add(new TransientReference(providerHandle, referenceHandle, childCtxHandle));
            }
            MethodInfo initializerMethod = methodInjection.target.asMethod();
            if (this.isReflectionFallbackNeeded(initializerMethod, targetPackage)) {
                if (Modifier.isPrivate(initializerMethod.flags())) {
                    this.privateMembers.add(isApplicationClass, String.format("@Inject initializer %s#%s()", initializerMethod.declaringClass().name(), initializerMethod.name()));
                }
                ResultHandle paramTypesArray = create.newArray(Class.class, create.load(referenceHandles.length));
                ResultHandle argsArray = create.newArray(Object.class, create.load(referenceHandles.length));
                for (int i = 0; i < referenceHandles.length; ++i) {
                    create.writeArrayValue(paramTypesArray, i, create.loadClass(((org.jboss.jandex.Type)initializerMethod.parameters().get(i)).name().toString()));
                    create.writeArrayValue(argsArray, i, referenceHandles[i]);
                }
                reflectionRegistration.registerMethod(initializerMethod);
                create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{create.loadClass(initializerMethod.declaringClass().name().toString()), create.load(methodInjection.target.asMethod().name()), paramTypesArray, instanceHandle, argsArray});
            } else {
                create.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)methodInjection.target.asMethod()), (ResultHandle)instanceHandle, referenceHandles);
            }
            BeanGenerator.destroyTransientReferences((BytecodeCreator)create, (Iterable<TransientReference>)transientReferences);
        }
        BeanInfo.InterceptionInfo postConstructs = bean.getLifecycleInterceptors(InterceptionType.POST_CONSTRUCT);
        if (!postConstructs.isEmpty()) {
            ResultHandle bindingsHandle = create.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance binding : postConstructs.bindings) {
                ClassInfo bindingClass = bean.getDeployment().getInterceptorBinding(binding.name());
                create.invokeInterfaceMethod(MethodDescriptors.SET_ADD, bindingsHandle, new ResultHandle[]{this.annotationLiterals.process((BytecodeCreator)create, classOutput, bindingClass, binding, Types.getPackageName(beanCreator.getClassName()))});
            }
            ResultHandle invocationContextHandle = create.invokeStaticMethod(MethodDescriptors.INVOCATION_CONTEXTS_POST_CONSTRUCT, new ResultHandle[]{instanceHandle, postConstructsHandle, bindingsHandle});
            TryBlock tryCatch = create.tryBlock();
            CatchBlockCreator exceptionCatch = tryCatch.addCatch(Exception.class);
            exceptionCatch.throwException(RuntimeException.class, "Error invoking postConstructs", exceptionCatch.getCaughtException());
            tryCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationContext.class, (String)"proceed", Object.class, (Class[])new Class[0]), invocationContextHandle, new ResultHandle[0]);
        }
        if (!bean.isInterceptor()) {
            List<MethodInfo> postConstructCallbacks = Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.POST_CONSTRUCT, bean.getDeployment().getIndex());
            for (MethodInfo callback : postConstructCallbacks) {
                if (this.isReflectionFallbackNeeded(callback, targetPackage)) {
                    if (Modifier.isPrivate(callback.flags())) {
                        this.privateMembers.add(isApplicationClass, String.format("@PostConstruct callback %s#%s()", callback.declaringClass().name(), callback.name()));
                    }
                    reflectionRegistration.registerMethod(callback);
                    create.invokeStaticMethod(MethodDescriptors.REFLECTIONS_INVOKE_METHOD, new ResultHandle[]{create.loadClass(callback.declaringClass().name().toString()), create.load(callback.name()), create.newArray(Class.class, create.load(0)), instanceHandle, create.newArray(Object.class, create.load(0))});
                    continue;
                }
                create.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback), (ResultHandle)instanceHandle, new ResultHandle[0]);
            }
        }
        create.returnValue((ResultHandle)instanceHandle);
    }

    protected void implementGet(BeanInfo bean, ClassCreator beanCreator, String providerTypeName, String baseName) {
        ResultHandle instance;
        MethodCreator get = (MethodCreator)beanCreator.getMethodCreator("get", (Object)providerTypeName, new Object[]{CreationalContext.class}).setModifiers(1);
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            instance = get.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)beanCreator.getClassName(), (String)"create", (Object)providerTypeName, (Object[])new Object[]{CreationalContext.class}), get.getThis(), new ResultHandle[]{get.getMethodParam(0)});
            boolean canBeOptimized = false;
            if (bean.isClassBean()) {
                canBeOptimized = bean.getLifecycleInterceptors(InterceptionType.PRE_DESTROY).isEmpty() && Beans.getCallbacks(bean.getTarget().get().asClass(), DotNames.PRE_DESTROY, bean.getDeployment().getIndex()).isEmpty();
            } else if (bean.isProducerMethod() || bean.isProducerField()) {
                boolean bl = canBeOptimized = bean.getDisposer() == null;
            }
            if (canBeOptimized) {
                ResultHandle creationalContext = get.checkCast(get.getMethodParam(0), CreationalContextImpl.class);
                get.ifNonZero(get.invokeVirtualMethod(MethodDescriptors.CREATIONAL_CTX_HAS_DEPENDENT_INSTANCES, creationalContext, new ResultHandle[0])).falseBranch().returnValue(instance);
            }
            get.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_ADD_DEP_TO_PARENT, new ResultHandle[]{get.getThis(), instance, get.getMethodParam(0)});
            get.returnValue(instance);
        } else if (BuiltinScope.SINGLETON.is(bean.getScope())) {
            ResultHandle container = get.invokeStaticMethod(MethodDescriptors.ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle creationalContext = get.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{get.getThis()});
            ResultHandle scope = get.loadClass(bean.getScope().getDotName().toString());
            ResultHandle context = get.invokeInterfaceMethod(MethodDescriptors.ARC_CONTAINER_GET_ACTIVE_CONTEXT, container, new ResultHandle[]{scope});
            get.returnValue(get.invokeInterfaceMethod(MethodDescriptors.CONTEXT_GET, context, new ResultHandle[]{get.getThis(), creationalContext}));
        } else if (bean.getScope().isNormal()) {
            get.returnValue(get.invokeVirtualMethod(MethodDescriptor.ofMethod((String)beanCreator.getClassName(), (String)FIELD_NAME_PROXY, (String)this.getProxyTypeName(bean, baseName), (String[])new String[0]), get.getThis(), new ResultHandle[0]));
        } else {
            instance = get.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)beanCreator.getClassName(), (String)"create", (Object)providerTypeName, (Object[])new Object[]{CreationalContext.class}), get.getThis(), new ResultHandle[]{get.getMethodParam(0)});
            get.returnValue(instance);
        }
        MethodCreator bridgeGet = (MethodCreator)beanCreator.getMethodCreator("get", Object.class, new Class[]{CreationalContext.class}).setModifiers(65);
        bridgeGet.returnValue(bridgeGet.invokeVirtualMethod(get.getMethodDescriptor(), bridgeGet.getThis(), new ResultHandle[]{bridgeGet.getMethodParam(0)}));
    }

    protected void implementGetTypes(ClassCreator beanCreator, FieldDescriptor typesField) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getTypes", Set.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.readInstanceField(typesField, getScope.getThis()));
    }

    protected void implementGetScope(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getScope", Class.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.loadClass(bean.getScope().getDotName().toString()));
    }

    protected void implementGetIdentifier(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getIdentifier", String.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.load(bean.getIdentifier()));
    }

    protected void implementGetQualifiers(BeanInfo bean, ClassCreator beanCreator, FieldDescriptor qualifiersField) {
        MethodCreator getQualifiers = (MethodCreator)beanCreator.getMethodCreator("getQualifiers", Set.class, new Class[0]).setModifiers(1);
        getQualifiers.returnValue(getQualifiers.readInstanceField(qualifiersField, getQualifiers.getThis()));
    }

    protected void implementGetDeclaringBean(ClassCreator beanCreator) {
        MethodCreator getDeclaringBean = (MethodCreator)beanCreator.getMethodCreator("getDeclaringBean", InjectableBean.class, new Class[0]).setModifiers(1);
        ResultHandle declaringProviderSupplierHandle = getDeclaringBean.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_DECLARING_PROVIDER_SUPPLIER, (String)Supplier.class.getName()), getDeclaringBean.getThis());
        getDeclaringBean.returnValue(getDeclaringBean.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, declaringProviderSupplierHandle, new ResultHandle[0]));
    }

    protected void implementGetAlternativePriority(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getAlternativePriority = (MethodCreator)beanCreator.getMethodCreator("getAlternativePriority", Integer.class, new Class[0]).setModifiers(1);
        getAlternativePriority.returnValue(getAlternativePriority.newInstance(MethodDescriptor.ofConstructor(Integer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{getAlternativePriority.load(bean.getAlternativePriority().intValue())}));
    }

    protected void implementIsDefaultBean(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator isDefaultBean = (MethodCreator)beanCreator.getMethodCreator("isDefaultBean", Boolean.TYPE, new Class[0]).setModifiers(1);
        isDefaultBean.returnValue(isDefaultBean.load(bean.isDefaultBean()));
    }

    protected void implementGetStereotypes(BeanInfo bean, ClassCreator beanCreator, FieldDescriptor stereotypesField) {
        MethodCreator getStereotypes = (MethodCreator)beanCreator.getMethodCreator("getStereotypes", Set.class, new Class[0]).setModifiers(1);
        getStereotypes.returnValue(getStereotypes.readInstanceField(stereotypesField, getStereotypes.getThis()));
    }

    protected void implementGetBeanClass(BeanInfo bean, ClassCreator beanCreator) {
        MethodCreator getBeanClass = (MethodCreator)beanCreator.getMethodCreator("getBeanClass", Class.class, new Class[0]).setModifiers(1);
        getBeanClass.returnValue(getBeanClass.loadClass(bean.getBeanClass().toString()));
    }

    protected void implementGetName(BeanInfo bean, ClassCreator beanCreator) {
        if (bean.getName() != null) {
            MethodCreator getName = (MethodCreator)beanCreator.getMethodCreator("getName", String.class, new Class[0]).setModifiers(1);
            getName.returnValue(getName.load(bean.getName()));
        }
    }

    protected void implementGetKind(ClassCreator beanCreator, InjectableBean.Kind kind) {
        MethodCreator getScope = (MethodCreator)beanCreator.getMethodCreator("getKind", InjectableBean.Kind.class, new Class[0]).setModifiers(1);
        getScope.returnValue(getScope.readStaticField(FieldDescriptor.of(InjectableBean.Kind.class, (String)kind.toString(), InjectableBean.Kind.class)));
    }

    protected void implementSupplierGet(ClassCreator beanCreator) {
        MethodCreator get = (MethodCreator)beanCreator.getMethodCreator("get", Object.class, new Class[0]).setModifiers(1);
        get.returnValue(get.getThis());
    }

    private String getProxyTypeName(BeanInfo bean, String baseName) {
        return this.getPackageName(bean) + "." + baseName + "_ClientProxy";
    }

    private ResultHandle wrapCurrentInjectionPoint(ClassOutput classOutput, ClassCreator beanCreator, BeanInfo bean, MethodCreator constructor, InjectionPointInfo injectionPoint, int paramIdx, ResultHandle tccl, ReflectionRegistration reflectionRegistration) {
        ResultHandle requiredQualifiersHandle = BeanGenerator.collectInjectionPointQualifiers(classOutput, beanCreator, bean.getDeployment(), constructor, injectionPoint, this.annotationLiterals);
        ResultHandle annotationsHandle = BeanGenerator.collectInjectionPointAnnotations(classOutput, beanCreator, bean.getDeployment(), constructor, injectionPoint, this.annotationLiterals, this.injectionPointAnnotationsPredicate);
        ResultHandle javaMemberHandle = BeanGenerator.getJavaMemberHandle(constructor, injectionPoint, reflectionRegistration);
        return constructor.newInstance(MethodDescriptor.ofConstructor(CurrentInjectionPointProvider.class, (Class[])new Class[]{InjectableBean.class, Supplier.class, Type.class, Set.class, Set.class, Member.class, Integer.TYPE}), new ResultHandle[]{constructor.getThis(), constructor.getMethodParam(paramIdx), Types.getTypeHandle((BytecodeCreator)constructor, injectionPoint.getRequiredType(), tccl), requiredQualifiersHandle, annotationsHandle, javaMemberHandle, constructor.load(injectionPoint.getPosition())});
    }

    private void initializeProxy(BeanInfo bean, String baseName, ClassCreator beanCreator) {
        String proxyTypeName = this.getProxyTypeName(bean, baseName);
        beanCreator.getFieldCreator(FIELD_NAME_PROXY, proxyTypeName).setModifiers(66);
        MethodCreator proxy = (MethodCreator)beanCreator.getMethodCreator(FIELD_NAME_PROXY, proxyTypeName, new String[0]).setModifiers(2);
        AssignableResultHandle proxyInstance = proxy.createVariable(DescriptorUtils.extToInt((String)proxyTypeName));
        proxy.assign(proxyInstance, proxy.readInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_PROXY, (String)proxyTypeName), proxy.getThis()));
        BytecodeCreator proxyNull = proxy.ifNull((ResultHandle)proxyInstance).trueBranch();
        proxyNull.assign(proxyInstance, proxyNull.newInstance(MethodDescriptor.ofConstructor((String)proxyTypeName, (String[])new String[]{beanCreator.getClassName()}), new ResultHandle[]{proxyNull.getThis()}));
        proxyNull.writeInstanceField(FieldDescriptor.of((String)beanCreator.getClassName(), (String)FIELD_NAME_PROXY, (String)proxyTypeName), proxyNull.getThis(), (ResultHandle)proxyInstance);
        proxy.returnValue((ResultHandle)proxyInstance);
    }

    static ResultHandle getJavaMemberHandle(MethodCreator constructor, InjectionPointInfo injectionPoint, ReflectionRegistration reflectionRegistration) {
        ResultHandle javaMemberHandle;
        if (AnnotationTarget.Kind.FIELD.equals((Object)injectionPoint.getTarget().kind())) {
            FieldInfo field = injectionPoint.getTarget().asField();
            javaMemberHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_FIELD, new ResultHandle[]{constructor.loadClass(field.declaringClass().name().toString()), constructor.load(field.name())});
            reflectionRegistration.registerField(field);
        } else {
            MethodInfo method = injectionPoint.getTarget().asMethod();
            reflectionRegistration.registerMethod(method);
            if (method.name().equals("<init>")) {
                ResultHandle[] paramsHandles = new ResultHandle[2];
                paramsHandles[0] = constructor.loadClass(method.declaringClass().name().toString());
                ResultHandle paramsArray = constructor.newArray(Class.class, constructor.load(method.parameters().size()));
                ListIterator iterator = method.parameters().listIterator();
                while (iterator.hasNext()) {
                    constructor.writeArrayValue(paramsArray, iterator.nextIndex(), constructor.loadClass(((org.jboss.jandex.Type)iterator.next()).name().toString()));
                }
                paramsHandles[1] = paramsArray;
                javaMemberHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_CONSTRUCTOR, paramsHandles);
            } else {
                ResultHandle[] paramsHandles = new ResultHandle[3];
                paramsHandles[0] = constructor.loadClass(method.declaringClass().name().toString());
                paramsHandles[1] = constructor.load(method.name());
                ResultHandle paramsArray = constructor.newArray(Class.class, constructor.load(method.parameters().size()));
                ListIterator iterator = method.parameters().listIterator();
                while (iterator.hasNext()) {
                    constructor.writeArrayValue(paramsArray, iterator.nextIndex(), constructor.loadClass(((org.jboss.jandex.Type)iterator.next()).name().toString()));
                }
                paramsHandles[2] = paramsArray;
                javaMemberHandle = constructor.invokeStaticMethod(MethodDescriptors.REFLECTIONS_FIND_METHOD, paramsHandles);
            }
        }
        return javaMemberHandle;
    }

    static ResultHandle collectInjectionPointAnnotations(ClassOutput classOutput, ClassCreator beanCreator, BeanDeployment beanDeployment, MethodCreator constructor, InjectionPointInfo injectionPoint, AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> injectionPointAnnotationsPredicate) {
        Collection<AnnotationInstance> annotations;
        ResultHandle annotationsHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        if (AnnotationTarget.Kind.FIELD.equals((Object)injectionPoint.getTarget().kind())) {
            FieldInfo field = injectionPoint.getTarget().asField();
            annotations = beanDeployment.getAnnotations((AnnotationTarget)field);
        } else {
            MethodInfo method = injectionPoint.getTarget().asMethod();
            annotations = Annotations.getParameterAnnotations(beanDeployment, method, injectionPoint.getPosition());
        }
        for (AnnotationInstance annotation : annotations) {
            ResultHandle annotationHandle;
            if (!injectionPointAnnotationsPredicate.test(annotation.name())) continue;
            if (DotNames.INJECT.equals((Object)annotation.name())) {
                annotationHandle = constructor.readStaticField(FieldDescriptor.of(InjectLiteral.class, (String)"INSTANCE", InjectLiteral.class));
            } else {
                ClassInfo literalClass = IndexClassLookupUtils.getClassByName(beanDeployment.getIndex(), annotation.name());
                annotationHandle = annotationLiterals.process((BytecodeCreator)constructor, classOutput, literalClass, annotation, Types.getPackageName(beanCreator.getClassName()));
            }
            constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, annotationsHandle, new ResultHandle[]{annotationHandle});
        }
        return annotationsHandle;
    }

    static ResultHandle collectInjectionPointQualifiers(ClassOutput classOutput, ClassCreator beanCreator, BeanDeployment beanDeployment, MethodCreator constructor, InjectionPointInfo injectionPoint, AnnotationLiteralProcessor annotationLiterals) {
        ResultHandle requiredQualifiersHandle;
        if (injectionPoint.hasDefaultedQualifier()) {
            requiredQualifiersHandle = constructor.readStaticField(FieldDescriptors.QUALIFIERS_IP_QUALIFIERS);
        } else {
            requiredQualifiersHandle = constructor.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (AnnotationInstance qualifierAnnotation : injectionPoint.getRequiredQualifiers()) {
                BuiltinQualifier qualifier = BuiltinQualifier.of(qualifierAnnotation);
                ResultHandle qualifierHandle = qualifier != null ? qualifier.getLiteralInstance((BytecodeCreator)constructor) : annotationLiterals.process((BytecodeCreator)constructor, classOutput, beanDeployment.getQualifier(qualifierAnnotation.name()), qualifierAnnotation, Types.getPackageName(beanCreator.getClassName()));
                constructor.invokeInterfaceMethod(MethodDescriptors.SET_ADD, requiredQualifiersHandle, new ResultHandle[]{qualifierHandle});
            }
        }
        return requiredQualifiersHandle;
    }

    static void destroyTransientReferences(BytecodeCreator bytecode, Iterable<TransientReference> transientReferences) {
        for (TransientReference transientReference : transientReferences) {
            bytecode.invokeStaticMethod(MethodDescriptors.INJECTABLE_REFERENCE_PROVIDERS_DESTROY, new ResultHandle[]{transientReference.provider, transientReference.instance, transientReference.creationalContext});
        }
    }

    static class TransientReference {
        final ResultHandle provider;
        final ResultHandle instance;
        final ResultHandle creationalContext;

        public TransientReference(ResultHandle provider, ResultHandle contextualInstance, ResultHandle creationalContext) {
            this.provider = provider;
            this.instance = contextualInstance;
            this.creationalContext = creationalContext;
        }
    }
}

