/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.internal.ComponentId;
import io.opentelemetry.sdk.internal.SemConvAttributes;
import io.opentelemetry.sdk.logs.export.LogRecordProcessorInstrumentation;
import io.opentelemetry.sdk.logs.export.LongCallable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class SemConvLogRecordProcessorInstrumentation
implements LogRecordProcessorInstrumentation {
    private final Object lock = new Object();
    private final AtomicBoolean builtQueueMetrics = new AtomicBoolean(false);
    private final Supplier<MeterProvider> meterProvider;
    private final Attributes standardAttrs;
    private final Attributes droppedAttrs;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter processedLogs;

    SemConvLogRecordProcessorInstrumentation(ComponentId componentId, Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
        this.standardAttrs = Attributes.of((AttributeKey)SemConvAttributes.OTEL_COMPONENT_TYPE, (Object)componentId.getTypeName(), (AttributeKey)SemConvAttributes.OTEL_COMPONENT_NAME, (Object)componentId.getComponentName());
        this.droppedAttrs = Attributes.of((AttributeKey)SemConvAttributes.OTEL_COMPONENT_TYPE, (Object)componentId.getTypeName(), (AttributeKey)SemConvAttributes.OTEL_COMPONENT_NAME, (Object)componentId.getComponentName(), (AttributeKey)SemConvAttributes.ERROR_TYPE, (Object)"queue_full");
    }

    @Override
    public void dropLogs(int count) {
        this.processedLogs().add((long)count, this.droppedAttrs);
    }

    @Override
    public void finishLogs(int count, @Nullable String error) {
        if (error == null) {
            this.processedLogs().add((long)count, this.standardAttrs);
            return;
        }
        Attributes attributes = this.standardAttrs.toBuilder().put(SemConvAttributes.ERROR_TYPE, (Object)error).build();
        this.processedLogs().add((long)count, attributes);
    }

    @Override
    public void buildQueueMetricsOnce(long capacity, LongCallable getSize) {
        if (!this.builtQueueMetrics.compareAndSet(false, true)) {
            return;
        }
        this.meter().upDownCounterBuilder("otel.sdk.processor.log.queue.capacity").setUnit("{log_record}").setDescription("The maximum number of log records the queue of a given instance of an SDK Log Record processor can hold. ").buildWithCallback(m -> m.record(capacity, this.standardAttrs));
        this.meter().upDownCounterBuilder("otel.sdk.processor.log.queue.size").setUnit("{log_record}").setDescription("The number of log records in the queue of a given instance of an SDK log processor.").buildWithCallback(m -> m.record(getSize.get(), this.standardAttrs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter processedLogs() {
        LongCounter processedLogs = this.processedLogs;
        if (processedLogs == null) {
            Object object = this.lock;
            synchronized (object) {
                processedLogs = this.processedLogs;
                if (processedLogs == null) {
                    this.processedLogs = processedLogs = this.meter().counterBuilder("otel.sdk.processor.log.processed").setUnit("{log_record}").setDescription("The number of log records for which the processing has finished, either successful or failed.").build();
                }
            }
        }
        return processedLogs;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("io.opentelemetry.sdk.logs");
        }
        return this.meter;
    }
}

