/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8.internal;

import com.sun.management.UnixOperatingSystemMXBean;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;

public final class ExperimentalFileDescriptor {
    private static final Class<?> unixOperatingSystemMxBeanClass = ExperimentalFileDescriptor.loadClass("com.sun.management.UnixOperatingSystemMXBean");

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className, false, ExperimentalFileDescriptor.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return ExperimentalFileDescriptor.registerObservers(openTelemetry, ManagementFactory.getOperatingSystemMXBean());
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, OperatingSystemMXBean osBean) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        if (unixOperatingSystemMxBeanClass != null && unixOperatingSystemMxBeanClass.isInstance(osBean)) {
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.file_descriptor.count").setDescription("Number of open file descriptors as reported by the JVM.").setUnit("{file_descriptor}").buildWithCallback(observableMeasurement -> {
                long openFileDescriptorCount = ((UnixOperatingSystemMXBean)osBean).getOpenFileDescriptorCount();
                if (openFileDescriptorCount >= 0L) {
                    observableMeasurement.record(openFileDescriptorCount);
                }
            }));
        }
        return observables;
    }

    private ExperimentalFileDescriptor() {
    }
}

