/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.util;

import io.leangen.graphql.metadata.strategy.type.TypeInfoGenerator;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.gson.GsonValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.jackson.JacksonValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.simple.ScalarOnlyValueMapperFactory;
import io.leangen.graphql.util.ClassUtils;

public class Defaults {
    private static JsonLib jsonLibrary() {
        for (JsonLib jsonLib : JsonLib.values()) {
            try {
                ClassUtils.forName(jsonLib.requiredClass);
                return jsonLib;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new IllegalStateException("No JSON deserialization library found on classpath");
    }

    public static ValueMapperFactory valueMapperFactory(String basePackage, TypeInfoGenerator typeInfoGenerator) {
        switch (Defaults.jsonLibrary()) {
            case GSON: {
                return new GsonValueMapperFactory(basePackage, typeInfoGenerator);
            }
            case JACKSON: {
                return new JacksonValueMapperFactory(basePackage, typeInfoGenerator);
            }
        }
        return new ScalarOnlyValueMapperFactory();
    }

    private static enum JsonLib {
        JACKSON("com.fasterxml.jackson.databind.ObjectMapper"),
        GSON("com.google.gson.Gson"),
        SCALAR("java.lang.Object");

        public final String requiredClass;

        private JsonLib(String requiredClass) {
            this.requiredClass = requiredClass;
        }
    }
}

