/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.generator.types.MappedGraphQLObjectType;
import io.leangen.graphql.metadata.InputField;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.GraphQLUtils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ObjectTypeMapper
extends CachingMapper<GraphQLObjectType, GraphQLInputObjectType> {
    @Override
    public GraphQLObjectType toGraphQLType(String typeName, AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLObjectType.Builder typeBuilder = GraphQLObjectType.newObject().name(typeName).description(buildContext.typeInfoGenerator.generateTypeDescription(javaType));
        List<GraphQLFieldDefinition> fields = this.getFields(javaType, buildContext, operationMapper);
        fields.forEach(arg_0 -> ((GraphQLObjectType.Builder)typeBuilder).field(arg_0));
        List<GraphQLOutputType> interfaces = this.getInterfaces(javaType, abstractTypes, fields, buildContext, operationMapper);
        interfaces.forEach(inter -> {
            if (inter instanceof GraphQLInterfaceType) {
                typeBuilder.withInterface((GraphQLInterfaceType)inter);
            } else {
                typeBuilder.withInterface((GraphQLTypeReference)inter);
            }
        });
        MappedGraphQLObjectType type = new MappedGraphQLObjectType(typeBuilder.build(), javaType);
        interfaces.forEach(inter -> buildContext.typeRepository.registerCovariantType(inter.getName(), javaType, (GraphQLOutputType)type));
        buildContext.typeRepository.registerObjectType(type);
        return type;
    }

    @Override
    public GraphQLInputObjectType toGraphQLInputType(String typeName, AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        GraphQLInputObjectType.Builder typeBuilder = GraphQLInputObjectType.newInputObject().name(typeName).description(buildContext.typeInfoGenerator.generateInputTypeDescription(javaType));
        buildContext.inputFieldStrategy.getInputFields(javaType).forEach(field -> typeBuilder.field(operationMapper.toGraphQLInputField((InputField)field, abstractTypes, buildContext)));
        if (ClassUtils.isAbstract(javaType)) {
            typeBuilder.field(GraphQLInputObjectField.newInputObjectField().name("_type_").type((GraphQLInputType)Scalars.GraphQLString).build());
        }
        return typeBuilder.build();
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return true;
    }

    protected List<GraphQLFieldDefinition> getFields(AnnotatedType javaType, BuildContext buildContext, OperationMapper operationMapper) {
        List<GraphQLFieldDefinition> fields = buildContext.operationRepository.getChildQueries(javaType).stream().map(childQuery -> operationMapper.toGraphQLOperation((Operation)childQuery, buildContext)).collect(Collectors.toList());
        if (ClassUtils.isAbstract(javaType) || !buildContext.interfaceStrategy.getInterfaces(javaType).isEmpty()) {
            fields.add(GraphQLFieldDefinition.newFieldDefinition().name("_type_").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(env -> env.getSource() == null ? null : env.getSource().getClass().getSimpleName()).build());
        }
        return fields;
    }

    protected List<GraphQLOutputType> getInterfaces(AnnotatedType javaType, Set<Type> abstractTypes, List<GraphQLFieldDefinition> fields, BuildContext buildContext, OperationMapper operationMapper) {
        ArrayList<GraphQLOutputType> interfaces = new ArrayList<GraphQLOutputType>();
        if (fields.stream().anyMatch(GraphQLUtils::isRelayId)) {
            interfaces.add((GraphQLOutputType)buildContext.node);
        }
        buildContext.interfaceStrategy.getInterfaces(javaType).forEach(inter -> interfaces.add(operationMapper.toGraphQLType((AnnotatedType)inter, abstractTypes, buildContext)));
        return interfaces;
    }
}

