/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLScalarType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.common.CachingMapper;
import io.leangen.graphql.generator.mapping.strategy.ScalarMappingStrategy;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectScalarAdapter
extends CachingMapper<GraphQLScalarType, GraphQLScalarType>
implements OutputConverter<Object, Map<String, ?>> {
    private final ScalarMappingStrategy scalarStrategy;
    private static final AnnotatedType MAP = GenericTypeReflector.annotate(LinkedHashMap.class);

    public ObjectScalarAdapter(ScalarMappingStrategy scalarStrategy) {
        this.scalarStrategy = scalarStrategy;
    }

    @Override
    public GraphQLScalarType toGraphQLType(String typeName, AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        buildContext.knownInputTypes.add(typeName);
        return Scalars.graphQLObjectScalar(typeName);
    }

    @Override
    public GraphQLScalarType toGraphQLInputType(String typeName, AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        buildContext.knownTypes.add(typeName);
        return this.toGraphQLType(typeName, javaType, abstractTypes, operationMapper, buildContext);
    }

    @Override
    protected void registerAbstract(AnnotatedType type, Set<Type> abstractTypes, BuildContext buildContext) {
        abstractTypes.addAll(this.collectAbstract(type, new HashSet<Type>(), buildContext));
    }

    @Override
    public Map<String, ?> convertOutput(Object original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return (Map)resolutionEnvironment.valueMapper.fromInput(original, type.getType(), MAP);
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return this.scalarStrategy.supports(type);
    }
}

