/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.execution.complexity;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.NoOpInstrumentation;
import graphql.execution.instrumentation.parameters.DataFetchParameters;
import graphql.execution.instrumentation.parameters.ExecutionParameters;
import graphql.execution.instrumentation.parameters.FieldFetchParameters;
import graphql.execution.instrumentation.parameters.FieldParameters;
import graphql.execution.instrumentation.parameters.ValidationParameters;
import graphql.language.AstPrinter;
import graphql.language.Document;
import graphql.language.Node;
import graphql.validation.ValidationError;
import io.leangen.graphql.execution.complexity.ComplexityAnalyzer;
import io.leangen.graphql.execution.complexity.ComplexityFunction;
import io.leangen.graphql.execution.complexity.ResolvedField;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexityAnalysisInstrumentation
implements Instrumentation {
    private final ComplexityFunction complexityFunction;
    private final int maximumComplexity;
    private static final Logger log = LoggerFactory.getLogger(ComplexityAnalysisInstrumentation.class);

    public ComplexityAnalysisInstrumentation(ComplexityFunction complexityFunction, int maximumComplexity) {
        this.complexityFunction = complexityFunction;
        this.maximumComplexity = maximumComplexity;
    }

    public InstrumentationContext<ExecutionResult> beginExecution(ExecutionParameters parameters) {
        return NoOpInstrumentation.INSTANCE.beginExecution(parameters);
    }

    public InstrumentationContext<Document> beginParse(ExecutionParameters parameters) {
        return NoOpInstrumentation.INSTANCE.beginParse(parameters);
    }

    public InstrumentationContext<List<ValidationError>> beginValidation(ValidationParameters parameters) {
        return NoOpInstrumentation.INSTANCE.beginValidation(parameters);
    }

    public InstrumentationContext<ExecutionResult> beginDataFetch(DataFetchParameters parameters) {
        ResolvedField root = new ComplexityAnalyzer(this.complexityFunction, this.maximumComplexity).collectFields(parameters.getExecutionContext());
        if (log.isDebugEnabled()) {
            log.debug("Operation {} has total complexity of {}", (Object)AstPrinter.printAst((Node)((Node)parameters.getExecutionContext().getOperationDefinition().getSelectionSet().getSelections().get(0))), (Object)root.getComplexityScore());
        }
        log.info("Total operation complexity: {}", (Object)root.getComplexityScore());
        return NoOpInstrumentation.INSTANCE.beginDataFetch(parameters);
    }

    public InstrumentationContext<ExecutionResult> beginField(FieldParameters parameters) {
        return NoOpInstrumentation.INSTANCE.beginField(parameters);
    }

    public InstrumentationContext<Object> beginFieldFetch(FieldFetchParameters parameters) {
        return NoOpInstrumentation.INSTANCE.beginFieldFetch(parameters);
    }
}

