/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.metadata.strategy.query;

import graphql.execution.batched.Batched;
import io.leangen.graphql.annotations.GraphQLComplexity;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.execution.MethodInvoker;
import io.leangen.graphql.metadata.execution.SingletonMethodInvoker;
import io.leangen.graphql.metadata.strategy.query.AnnotatedArgumentBuilder;
import io.leangen.graphql.metadata.strategy.query.FilteredResolverBuilder;
import io.leangen.graphql.metadata.strategy.query.MethodOperationNameGenerator;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PublicResolverBuilder
extends FilteredResolverBuilder {
    public PublicResolverBuilder(String basePackage) {
        this.basePackage = basePackage;
        this.operationNameGenerator = new MethodOperationNameGenerator();
        this.argumentExtractor = new AnnotatedArgumentBuilder();
    }

    @Override
    public Collection<Resolver> buildQueryResolvers(Object querySourceBean, AnnotatedType beanType) {
        return this.buildQueryResolvers(querySourceBean, beanType, this.getFilters());
    }

    @Override
    public Collection<Resolver> buildMutationResolvers(Object querySourceBean, AnnotatedType beanType) {
        return this.buildMutationResolvers(querySourceBean, beanType, this.getFilters());
    }

    private Collection<Resolver> buildQueryResolvers(Object querySourceBean, AnnotatedType beanType, List<Predicate<Member>> filters) {
        Class<?> rawType = ClassUtils.getRawType(beanType.getType());
        if (rawType.isArray() || rawType.isPrimitive()) {
            return Collections.emptyList();
        }
        return Arrays.stream(rawType.getMethods()).filter(method -> !method.isBridge() && !method.isSynthetic()).filter(method -> this.isPackageAcceptable((Method)method, rawType)).filter(this::isQuery).filter(filters.stream().reduce(Predicate::and).orElse(acceptAll)).map(method -> new Resolver(this.operationNameGenerator.generateQueryName((Method)method, beanType, querySourceBean), this.operationNameGenerator.generateQueryName((Method)method, beanType, querySourceBean), method.isAnnotationPresent(Batched.class), querySourceBean == null ? new MethodInvoker((Method)method, beanType) : new SingletonMethodInvoker(querySourceBean, (Method)method, beanType), this.argumentExtractor.buildResolverArguments((Method)method, beanType), method.isAnnotationPresent(GraphQLComplexity.class) ? method.getAnnotation(GraphQLComplexity.class).value() : null)).collect(Collectors.toList());
    }

    private Collection<Resolver> buildMutationResolvers(Object querySourceBean, AnnotatedType beanType, List<Predicate<Member>> filters) {
        Class<?> rawType = ClassUtils.getRawType(beanType.getType());
        if (rawType.isArray() || rawType.isPrimitive()) {
            return Collections.emptyList();
        }
        return Arrays.stream(rawType.getMethods()).filter(method -> this.isPackageAcceptable((Method)method, rawType)).filter(this::isMutation).filter(filters.stream().reduce(Predicate::and).orElse(acceptAll)).map(method -> new Resolver(this.operationNameGenerator.generateMutationName((Method)method, beanType, querySourceBean), this.operationNameGenerator.generateMutationName((Method)method, beanType, querySourceBean), method.isAnnotationPresent(Batched.class), querySourceBean == null ? new MethodInvoker((Method)method, beanType) : new SingletonMethodInvoker(querySourceBean, (Method)method, beanType), this.argumentExtractor.buildResolverArguments((Method)method, beanType), method.isAnnotationPresent(GraphQLComplexity.class) ? method.getAnnotation(GraphQLComplexity.class).value() : null)).collect(Collectors.toList());
    }

    protected boolean isQuery(Method method) {
        return !this.isMutation(method);
    }

    protected boolean isMutation(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    private boolean isPackageAcceptable(Method method, Class<?> beanType) {
        String basePackage = Utils.notEmpty(this.basePackage) ? this.basePackage : beanType.getPackage().getName();
        return method.getDeclaringClass().equals(beanType) || method.getDeclaringClass().getPackage().getName().startsWith(basePackage);
    }
}

