/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import io.leangen.graphql.generator.OperationSource;
import io.leangen.graphql.generator.OperationSourceRepository;
import io.leangen.graphql.metadata.Operation;
import io.leangen.graphql.metadata.Resolver;
import io.leangen.graphql.metadata.strategy.query.OperationBuilder;
import io.leangen.graphql.metadata.strategy.query.ResolverBuilder;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OperationRepository {
    private final Set<Operation> rootQueries;
    private final Set<Operation> mutations;
    private final OperationSourceRepository operationSourceRepository;
    private final OperationBuilder operationBuilder;

    public OperationRepository(OperationSourceRepository operationSourceRepository, OperationBuilder operationBuilder) {
        this.operationSourceRepository = operationSourceRepository;
        this.operationBuilder = operationBuilder;
        Collection<Resolver> resolvers = this.buildQueryResolvers(operationSourceRepository.getOperationSources());
        Collection<Resolver> mutationResolvers = this.buildMutationResolvers(operationSourceRepository.getOperationSources());
        this.rootQueries = this.buildQueries(resolvers);
        this.mutations = this.buildMutations(mutationResolvers);
    }

    private Set<Operation> buildQueries(Collection<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).entrySet().stream().map(entry -> this.operationBuilder.buildQuery((List)entry.getValue())).collect(Collectors.toSet());
    }

    private Set<Operation> buildMutations(Collection<Resolver> resolvers) {
        return resolvers.stream().collect(Collectors.groupingBy(Resolver::getOperationName)).entrySet().stream().map(entry -> this.operationBuilder.buildMutation((List)entry.getValue())).collect(Collectors.toSet());
    }

    public Collection<Operation> getQueries() {
        return this.rootQueries;
    }

    public Collection<Operation> getMutations() {
        return this.mutations;
    }

    public Set<Operation> getNestedQueries(AnnotatedType domainType) {
        OperationSource domainSource = this.operationSourceRepository.nestedSourceForType(domainType);
        return this.buildNestedQueries(domainSource);
    }

    public Collection<Operation> getChildQueries(AnnotatedType domainType) {
        HashMap children = new HashMap();
        Map nestedQueries = this.getNestedQueries(domainType).stream().collect(Collectors.toMap(Operation::getName, Function.identity()));
        Map embeddableQueries = this.getEmbeddableQueries(domainType.getType()).stream().collect(Collectors.toMap(Operation::getName, Function.identity()));
        children.putAll(nestedQueries);
        children.putAll(embeddableQueries);
        return children.values();
    }

    public Set<Operation> getEmbeddableQueries(Type domainType) {
        return this.getQueries().stream().map(Operation::unbatch).filter(query -> query.isEmbeddableForType(domainType)).collect(Collectors.toSet());
    }

    private Set<Operation> buildNestedQueries(OperationSource operationSource) {
        return this.buildQueries(this.buildQueryResolvers(Collections.singleton(operationSource)));
    }

    private Collection<Resolver> buildQueryResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildQueryResolvers(operationSource.getServiceSingleton(), operationSource.getJavaType()));
    }

    private Collection<Resolver> buildMutationResolvers(Collection<OperationSource> operationSources) {
        return this.buildResolvers(operationSources, (operationSource, builder) -> builder.buildMutationResolvers(operationSource.getServiceSingleton(), operationSource.getJavaType()));
    }

    private Collection<Resolver> buildResolvers(Collection<OperationSource> operationSources, BiFunction<OperationSource, ResolverBuilder, Collection<Resolver>> building) {
        return operationSources.stream().flatMap(operationSource -> operationSource.getResolverBuilders().stream().flatMap(builder -> ((Collection)building.apply((OperationSource)operationSource, (ResolverBuilder)builder)).stream()).distinct()).collect(Collectors.toList());
    }
}

