/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.extensions;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.Swagger2MarkupProperties;
import io.github.swagger2markup.extensions.ContentExtension;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.ContentContext;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.github.swagger2markup.utils.IOUtils;
import io.github.swagger2markup.utils.URIUtils;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpringRestDocsExtension
extends PathsDocumentExtension {
    private static final Logger logger = LoggerFactory.getLogger(SpringRestDocsExtension.class);
    private static final Map<String, String> DEFAULT_SNIPPETS = new LinkedHashMap<String, String>(){
        {
            this.put("http-request", "Example HTTP request");
            this.put("http-response", "Example HTTP response");
            this.put("curl-request", "Example Curl request");
        }
    };
    private static final String PROPERTY_SNIPPET_BASE_URI = "snippetBaseUri";
    private static final String DEFAULT_EXTENSION_ID = "springRestDocs";
    private static final String PROPERTY_DEFAULT_SNIPPETS = "defaultSnippets";
    private static final String PROPERTY_MARKUP_LANGUAGE = "markupLanguage";
    protected URI snippetBaseUri;
    protected Map<String, String> snippets = new LinkedHashMap<String, String>();
    private String extensionId = "springRestDocs";
    private MarkupLanguage extensionMarkupLanguage = MarkupLanguage.ASCIIDOC;

    public SpringRestDocsExtension(URI snippetBaseUri, MarkupLanguage extensionMarkupLanguage) {
        this(null, snippetBaseUri, extensionMarkupLanguage);
    }

    public SpringRestDocsExtension(String extensionId, URI snippetBaseUri, MarkupLanguage extensionMarkupLanguage) {
        Validate.notNull((Object)extensionId);
        Validate.notNull((Object)snippetBaseUri);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extensionId})) {
            this.extensionId = extensionId;
        }
        this.snippetBaseUri = snippetBaseUri;
        this.extensionMarkupLanguage = extensionMarkupLanguage;
    }

    public SpringRestDocsExtension() {
    }

    public void init(Swagger2MarkupConverter.Context globalContext) {
        Swagger2MarkupProperties extensionsProperties = globalContext.getConfig().getExtensionsProperties();
        Optional snippetBaseUriProperty = extensionsProperties.getURI(this.extensionId + "." + PROPERTY_SNIPPET_BASE_URI);
        boolean withDefaultSnippets = extensionsProperties.getBoolean(this.extensionId + "." + PROPERTY_DEFAULT_SNIPPETS, true);
        if (withDefaultSnippets) {
            this.withDefaultSnippets();
        }
        if (snippetBaseUriProperty.isPresent()) {
            this.snippetBaseUri = URIUtils.convertUriWithoutSchemeToFileScheme((URI)((URI)snippetBaseUriProperty.get()));
        } else if (globalContext.getSwaggerLocation() == null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Disable SpringRestDocsExtension > Can't set default snippetBaseUri from swaggerLocation. You have to explicitly configure the snippetBaseUri.");
            }
        } else {
            this.snippetBaseUri = URIUtils.uriParent((URI)globalContext.getSwaggerLocation());
        }
        Optional extensionMarkupLanguageProperty = extensionsProperties.getMarkupLanguage(this.extensionId + "." + PROPERTY_MARKUP_LANGUAGE);
        if (extensionMarkupLanguageProperty.isPresent()) {
            this.extensionMarkupLanguage = (MarkupLanguage)extensionMarkupLanguageProperty.get();
        }
    }

    public SpringRestDocsExtension withDefaultSnippets() {
        this.snippets.putAll(DEFAULT_SNIPPETS);
        return this;
    }

    public SpringRestDocsExtension withExplicitSnippets(Map<String, String> snippets) {
        this.snippets.putAll(snippets);
        return this;
    }

    public URI operationSnippetUri(PathsDocumentExtension.Context context, PathOperation operation, String snippetName) {
        return this.snippetBaseUri.resolve(IOUtils.normalizeName((String)operation.getId()) + "/").resolve(context.getMarkupDocBuilder().addFileExtension(snippetName));
    }

    public void apply(PathsDocumentExtension.Context context) {
        Validate.notNull((Object)context);
        switch (context.getPosition()) {
            case OPERATION_END: {
                this.snippets(context);
            }
        }
    }

    public void snippets(PathsDocumentExtension.Context context) {
        for (Map.Entry<String, String> snippets : this.snippets.entrySet()) {
            this.snippetSection(context, snippets.getKey(), snippets.getValue());
        }
    }

    public void snippetSection(PathsDocumentExtension.Context context, String snippetName, String title) {
        ContentExtension content = new ContentExtension(this.globalContext, (ContentContext)context);
        URI snippetUri = this.operationSnippetUri(context, (PathOperation)context.getOperation().get(), snippetName);
        logger.info("Processing Spring REST Docs snippet: {}", (Object)snippetUri.toString());
        content.importContent(snippetUri, reader -> {
            context.getMarkupDocBuilder().sectionTitleLevel(1 + this.levelOffset(context), title);
            context.getMarkupDocBuilder().importMarkup(reader, this.extensionMarkupLanguage, this.levelOffset(context) + 1);
        });
    }
}

