/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util.tolerances;

import com.google.common.collect.Range;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RTTolerance {
    @Nonnull
    private final Float rtTolerance;
    private final boolean isAbsolute;

    public RTTolerance(float rtTolerance, boolean isAbsolute) {
        this.rtTolerance = Float.valueOf(rtTolerance);
        this.isAbsolute = isAbsolute;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public float getTolerance() {
        return this.rtTolerance.floatValue();
    }

    public Range<Float> getToleranceRange(float rtValue) {
        float absoluteTolerance = this.isAbsolute ? this.rtTolerance.floatValue() : rtValue * this.rtTolerance.floatValue();
        return Range.closed((Comparable)Float.valueOf(rtValue - absoluteTolerance), (Comparable)Float.valueOf(rtValue + absoluteTolerance));
    }

    public boolean checkWithinTolerance(float rt1, float rt2) {
        return this.getToleranceRange(rt1).contains((Comparable)Float.valueOf(rt2));
    }

    public String toString() {
        return this.isAbsolute ? this.rtTolerance + " sec" : 100.0 * (double)this.rtTolerance.floatValue() + " %";
    }
}

