/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util;

import com.google.common.collect.Range;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class RawDataFileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<MsScan> getScans(RawDataFile rawDataFile, String msFunction) {
        List<MsScan> scans;
        ArrayList<MsScan> msScanList = new ArrayList<MsScan>();
        List<MsScan> list = scans = rawDataFile.getScans();
        synchronized (list) {
            for (MsScan scan : scans) {
                String scanMsFunction = scan.getMsFunction();
                if (scanMsFunction == null || !scanMsFunction.equals(msFunction)) continue;
                msScanList.add(scan);
            }
        }
        return msScanList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<MsScan> getScans(RawDataFile rawDataFile, Range<Float> rtRange) {
        List<MsScan> scans;
        ArrayList<MsScan> msScanList = new ArrayList<MsScan>();
        List<MsScan> list = scans = rawDataFile.getScans();
        synchronized (list) {
            for (MsScan scan : scans) {
                Float scanRT = scan.getRetentionTime();
                if (scanRT == null || !rtRange.contains((Comparable)scanRT)) continue;
                msScanList.add(scan);
            }
        }
        return new ArrayList<MsScan>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<MsScan> getScans(RawDataFile rawDataFile, String msFunction, Range<Float> rtRange) {
        List<MsScan> scans;
        ArrayList<MsScan> msScanList = new ArrayList<MsScan>();
        List<MsScan> list = scans = rawDataFile.getScans();
        synchronized (list) {
            for (MsScan scan : scans) {
                Float scanRT = scan.getRetentionTime();
                String scanMsFunction = scan.getMsFunction();
                if (scanRT == null || scanMsFunction == null || !scanMsFunction.equals(msFunction) || !rtRange.contains((Comparable)scanRT)) continue;
                msScanList.add(scan);
            }
        }
        return new ArrayList<MsScan>();
    }

    @Nonnull
    public static Integer getNextChromatogramNumber(RawDataFile rawDataFile) {
        int chromatogramNumber = 1;
        List<Chromatogram> chromatograms = rawDataFile.getChromatograms();
        for (Chromatogram chromatogram : chromatograms) {
            int currentChromatogramNumber = chromatogram.getChromatogramNumber();
            if (currentChromatogramNumber <= chromatogramNumber) continue;
            chromatogramNumber = currentChromatogramNumber;
        }
        return chromatogramNumber;
    }
}

