/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.github.msdk.datamodel.MsSpectrum;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MsSpectrumUtil {
    @Nullable
    public static Range<Double> getMzRange(@Nonnull double[] mzValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        if (size == 0) {
            return null;
        }
        double min = mzValues[0];
        double max = mzValues[size - 1];
        return Range.closed((Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max));
    }

    @Nonnull
    public static Float getTIC(@Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        float tic = 0.0f;
        for (int i = 0; i < size; ++i) {
            tic += intensityValues[i];
        }
        return Float.valueOf(tic);
    }

    @Nonnull
    public static Float getTIC(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size, @Nonnull Range<Double> mzRange) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        Preconditions.checkNotNull(mzRange);
        float tic = 0.0f;
        for (int i = 0; i < size; ++i) {
            if (!mzRange.contains((Comparable)Double.valueOf(mzValues[i]))) continue;
            tic += intensityValues[i];
        }
        return Float.valueOf(tic);
    }

    @Nonnull
    public static Float getMaxIntensity(@Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        Integer topIndex = MsSpectrumUtil.getBasePeakIndex(intensityValues, size);
        if (topIndex == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(intensityValues[topIndex]);
    }

    @Nonnull
    public static Float getMaxIntensity(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size, @Nonnull Range<Double> mzRange) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        Preconditions.checkNotNull(mzRange);
        Integer topIndex = MsSpectrumUtil.getBasePeakIndex(mzValues, intensityValues, size, mzRange);
        if (topIndex == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(intensityValues[topIndex]);
    }

    @Nullable
    public static Integer getBasePeakIndex(@Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        Integer topIndex = null;
        for (int i = 0; i < size; ++i) {
            if (topIndex != null && !(intensityValues[i] > intensityValues[topIndex])) continue;
            topIndex = i;
        }
        return topIndex;
    }

    @Nullable
    public static Integer getBasePeakIndex(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size, @Nonnull Range<Double> mzRange) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        Preconditions.checkNotNull(mzRange);
        Integer topIndex = null;
        for (int i = 0; i < size; ++i) {
            if (topIndex != null && !(intensityValues[i] > intensityValues[topIndex]) || !mzRange.contains((Comparable)Double.valueOf(mzValues[i]))) continue;
            topIndex = i;
        }
        return topIndex;
    }

    public static void normalizeIntensity(@Nonnull float[] intensityValues, @Nonnull Integer size, @Nonnull Float scale) {
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        Preconditions.checkNotNull((Object)scale);
        float max = MsSpectrumUtil.getMaxIntensity(intensityValues, size).floatValue();
        for (int i = 0; i < intensityValues.length; ++i) {
            intensityValues[i] = intensityValues[i] / max * scale.floatValue();
        }
    }

    @Nonnull
    public static String msSpectrumToString(MsSpectrum spectrum) {
        return MsSpectrumUtil.msSpectrumToString(spectrum.getMzValues(), spectrum.getIntensityValues(), spectrum.getNumberOfDataPoints());
    }

    @Nonnull
    public static String msSpectrumToString(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkPositionIndex((int)size, (int)mzValues.length);
        Preconditions.checkPositionIndex((int)size, (int)intensityValues.length);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            b.append(mzValues[i]);
            b.append(" ");
            b.append(intensityValues[i]);
            if (i >= size - 1) continue;
            b.append("\n");
        }
        return b.toString();
    }
}

