/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util;

import com.google.common.base.Strings;
import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.IonType;
import io.github.msdk.datamodel.PolarityType;
import io.github.msdk.datamodel.SimpleIonType;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class IonTypeUtil {
    private static final Pattern ionTypePattern = Pattern.compile("\\[(\\d*)M([+-]?.*)\\](\\d*)([+-])");
    private static final Pattern adductPattern = Pattern.compile("([+-])(\\d*)([\\w]+)");
    private static final Pattern elementPattern = Pattern.compile("([A-Z][a-z]*)(\\d*)");

    @Nonnull
    public static IonType createIonType(@Nonnull String adduct) {
        Matcher m = ionTypePattern.matcher(adduct);
        if (!m.matches()) {
            throw new MSDKRuntimeException("Cannot parse ion type " + adduct);
        }
        String numOfMoleculesGroup = m.group(1);
        String adductFormulaGroup = m.group(2);
        String chargeGroup = m.group(3);
        String polarityGroup = m.group(4);
        try {
            PolarityType polarity;
            switch (polarityGroup) {
                case "+": {
                    polarity = PolarityType.POSITIVE;
                    break;
                }
                case "-": {
                    polarity = PolarityType.NEGATIVE;
                    break;
                }
                default: {
                    polarity = PolarityType.UNKNOWN;
                }
            }
            Integer numberOfMolecules = 1;
            if (!Strings.isNullOrEmpty((String)numOfMoleculesGroup)) {
                numberOfMolecules = Integer.parseInt(numOfMoleculesGroup);
            }
            Integer charge = 1;
            if (!Strings.isNullOrEmpty((String)chargeGroup)) {
                charge = Integer.parseInt(chargeGroup);
            }
            String adductFormula = IonTypeUtil.parseAdductFormula(adductFormulaGroup);
            SimpleIonType ionType = new SimpleIonType(adduct, polarity, numberOfMolecules, adductFormula, charge);
            return ionType;
        }
        catch (Exception e) {
            throw new MSDKRuntimeException("Cannot parse ion type " + adduct);
        }
    }

    private static String parseAdductFormula(String adductFormula) {
        Hashtable<String, Integer> elementCounts = new Hashtable<String, Integer>();
        Matcher m = adductPattern.matcher(adductFormula);
        while (m.find()) {
            String plusMinus = m.group(1);
            Integer multiplier = 1;
            if (!Strings.isNullOrEmpty((String)m.group(2))) {
                multiplier = Integer.parseInt(m.group(2));
            }
            String formula = m.group(3);
            Matcher f = elementPattern.matcher(formula);
            while (f.find()) {
                String element = f.group(1);
                Integer count = multiplier;
                if (!Strings.isNullOrEmpty((String)f.group(2))) {
                    count = count * Integer.parseInt(f.group(2));
                }
                if (plusMinus.equals("-")) {
                    count = count * -1;
                }
                if (elementCounts.containsKey(element)) {
                    count = count + (Integer)elementCounts.get(element);
                }
                elementCounts.put(element, count);
            }
        }
        StringBuilder formula = new StringBuilder();
        Integer cCount = (Integer)elementCounts.get("C");
        if (cCount != null && cCount != 0) {
            formula.append("C");
            if (cCount != 1) {
                formula.append(cCount);
            }
        }
        elementCounts.remove("C");
        Integer hCount = (Integer)elementCounts.get("H");
        if (hCount != null && hCount != 0) {
            formula.append("H");
            if (hCount != 1) {
                formula.append(hCount);
            }
        }
        elementCounts.remove("H");
        Object[] elements = elementCounts.keySet().toArray(new String[0]);
        Arrays.sort(elements);
        for (Object element : elements) {
            Integer count = (Integer)elementCounts.get(element);
            if (count == 0) continue;
            formula.append((String)element);
            if (count == 1) continue;
            formula.append(count);
        }
        return formula.toString();
    }
}

