/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DataPointSorter {
    public static void sortDataPoints(double[] mzBuffer, float[] intensityBuffer, int size, SortingProperty prop, SortingDirection dir) {
        ArrayList<Integer> idx = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            idx.add(i);
        }
        DataPointComparator comp = new DataPointComparator(mzBuffer, intensityBuffer, prop, dir);
        Collections.sort(idx, comp);
        DataPointSorter.remapArray(mzBuffer, idx);
        DataPointSorter.remapArray(intensityBuffer, idx);
    }

    private static void remapArray(Object array, List<Integer> indices) {
        ArrayList<Integer> idx = new ArrayList<Integer>(indices);
        for (int i = 0; i < idx.size(); ++i) {
            int newIndex = (Integer)idx.get(i);
            if (newIndex == i) continue;
            Object tmp = Array.get(array, i);
            Array.set(array, i, Array.get(array, newIndex));
            int swapIndex = idx.indexOf(i);
            Array.set(array, newIndex, tmp);
            idx.set(swapIndex, newIndex);
            idx.set(i, i);
        }
    }

    public static void sortDataPoints(final Float[] rtBuffer, double[] mzBuffer, float[] intensityBuffer, int size) {
        ArrayList<Integer> idx = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            idx.add(i);
        }
        Collections.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return rtBuffer[i1].compareTo(rtBuffer[i2]);
            }
        });
        DataPointSorter.remapArray(rtBuffer, idx);
        DataPointSorter.remapArray(mzBuffer, idx);
        DataPointSorter.remapArray(intensityBuffer, idx);
    }

    private static class DataPointComparator
    implements Comparator<Integer> {
        private final double[] mzBuffer;
        private final float[] intensityBuffer;
        private final SortingProperty prop;
        private final SortingDirection dir;

        DataPointComparator(double[] mzBuffer, float[] intensityBuffer, SortingProperty prop, SortingDirection dir) {
            this.mzBuffer = mzBuffer;
            this.intensityBuffer = intensityBuffer;
            this.prop = prop;
            this.dir = dir;
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            switch (this.prop) {
                case INTENSITY: {
                    if (this.dir == SortingDirection.ASCENDING) {
                        return Float.compare(this.intensityBuffer[i1], this.intensityBuffer[i2]);
                    }
                    return Float.compare(this.intensityBuffer[i2], this.intensityBuffer[i1]);
                }
                case MZ: {
                    if (this.dir == SortingDirection.ASCENDING) {
                        return Double.compare(this.mzBuffer[i1], this.mzBuffer[i2]);
                    }
                    return Double.compare(this.mzBuffer[i2], this.mzBuffer[i1]);
                }
            }
            return 0;
        }
    }

    public static enum SortingDirection {
        ASCENDING,
        DESCENDING;

    }

    public static enum SortingProperty {
        MZ,
        INTENSITY;

    }
}

