/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.FileType;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleRawDataFile
implements RawDataFile {
    @Nonnull
    private String rawDataFileName;
    @Nonnull
    private Optional<File> originalRawDataFile;
    @Nonnull
    private FileType rawDataFileType;
    @Nonnull
    private final ArrayList<MsScan> scans;
    @Nonnull
    private final ArrayList<Chromatogram> chromatograms;

    public SimpleRawDataFile(@Nonnull String rawDataFileName, @Nonnull Optional<File> originalRawDataFile, @Nonnull FileType rawDataFileType) {
        Preconditions.checkNotNull((Object)((Object)rawDataFileType));
        this.rawDataFileName = rawDataFileName;
        this.originalRawDataFile = originalRawDataFile;
        this.rawDataFileType = rawDataFileType;
        this.scans = new ArrayList();
        this.chromatograms = new ArrayList();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.rawDataFileName;
    }

    public void setName(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name);
        this.rawDataFileName = name;
    }

    @Override
    @Nullable
    public Optional<File> getOriginalFile() {
        return this.originalRawDataFile;
    }

    @Override
    @Nonnull
    public String getOriginalFilename() {
        if (this.originalRawDataFile.isPresent()) {
            return this.originalRawDataFile.get().getName();
        }
        return "Unknown";
    }

    public void setOriginalFile(@Nullable File newOriginalFile) {
        this.originalRawDataFile = Optional.ofNullable(newOriginalFile);
    }

    @Override
    @Nonnull
    public FileType getRawDataFileType() {
        return this.rawDataFileType;
    }

    public void setRawDataFileType(@Nonnull FileType rawDataFileType) {
        Preconditions.checkNotNull((Object)((Object)rawDataFileType));
        this.rawDataFileType = rawDataFileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<String> getMsFunctions() {
        ArrayList<String> msFunctionList = new ArrayList<String>();
        ArrayList<MsScan> arrayList = this.scans;
        synchronized (arrayList) {
            for (MsScan scan : this.scans) {
                String f = scan.getMsFunction();
                if (f == null || msFunctionList.contains(f)) continue;
                msFunctionList.add(f);
            }
        }
        return msFunctionList;
    }

    @Override
    @Nonnull
    public List<MsScan> getScans() {
        return ImmutableList.copyOf(this.scans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScan(@Nonnull MsScan scan) {
        Preconditions.checkNotNull((Object)scan);
        ArrayList<MsScan> arrayList = this.scans;
        synchronized (arrayList) {
            this.scans.add(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScan(@Nonnull MsScan scan) {
        Preconditions.checkNotNull((Object)scan);
        ArrayList<MsScan> arrayList = this.scans;
        synchronized (arrayList) {
            this.scans.remove(scan);
        }
    }

    @Override
    @Nonnull
    public List<Chromatogram> getChromatograms() {
        return ImmutableList.copyOf(this.chromatograms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChromatogram(@Nonnull Chromatogram chromatogram) {
        Preconditions.checkNotNull((Object)chromatogram);
        ArrayList<Chromatogram> arrayList = this.chromatograms;
        synchronized (arrayList) {
            this.chromatograms.add(chromatogram);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChromatogram(@Nonnull Chromatogram chromatogram) {
        Preconditions.checkNotNull((Object)chromatogram);
        ArrayList<Chromatogram> arrayList = this.chromatograms;
        synchronized (arrayList) {
            this.chromatograms.remove(chromatogram);
        }
    }

    @Override
    public void dispose() {
    }
}

