/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.Feature;
import io.github.msdk.datamodel.FeatureTable;
import io.github.msdk.datamodel.FeatureTableRow;
import io.github.msdk.datamodel.Sample;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleFeatureTableRow
implements FeatureTableRow {
    @Nonnull
    private final FeatureTable featureTable;
    @Nonnull
    private final Map<Sample, Feature> features = new HashMap<Sample, Feature>();
    @Nullable
    private Integer charge;

    public SimpleFeatureTableRow(@Nonnull FeatureTable featureTable) {
        Preconditions.checkNotNull((Object)featureTable);
        this.featureTable = featureTable;
    }

    @Override
    @Nonnull
    public FeatureTable getFeatureTable() {
        return this.featureTable;
    }

    @Override
    public Double getMz() {
        Collection<Feature> allFeatures = this.features.values();
        double averageMz = allFeatures.stream().mapToDouble(Feature::getMz).average().getAsDouble();
        return averageMz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getRT() {
        Map<Sample, Feature> map = this.features;
        synchronized (map) {
            Collection<Feature> allFeatures = this.features.values();
            float averageRt = (float)allFeatures.stream().mapToDouble(Feature::getRetentionTime).average().getAsDouble();
            return Float.valueOf(averageRt);
        }
    }

    @Override
    public Integer getCharge() {
        return this.charge;
    }

    public void setCharge(@Nullable Integer charge) {
        this.charge = charge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature getFeature(Sample sample) {
        Map<Sample, Feature> map = this.features;
        synchronized (map) {
            return this.features.get(sample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature getFeature(Integer index) {
        assert (this.featureTable != null);
        Map<Sample, Feature> map = this.features;
        synchronized (map) {
            List<Sample> samples = this.featureTable.getSamples();
            return this.getFeature(samples.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeature(@Nonnull Sample sample, @Nonnull Feature feature) {
        Map<Sample, Feature> map = this.features;
        synchronized (map) {
            List<Sample> allSamples;
            if (this.featureTable != null && !(allSamples = this.featureTable.getSamples()).contains(sample)) {
                throw new MSDKRuntimeException("Cannot add feature, because the feature table does not contain sample " + sample.getName());
            }
            this.features.put(sample, feature);
        }
    }
}

