/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.collect.Range;
import io.github.msdk.datamodel.ChromatogramType;
import io.github.msdk.datamodel.IonAnnotation;
import io.github.msdk.datamodel.IsolationInfo;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SeparationType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Chromatogram {
    @Nullable
    public RawDataFile getRawDataFile();

    @Nonnull
    public Integer getChromatogramNumber();

    @Nonnull
    public ChromatogramType getChromatogramType();

    @Nonnull
    public Integer getNumberOfDataPoints();

    @Nonnull
    default public float[] getRetentionTimes() {
        return this.getRetentionTimes(null);
    }

    @Nonnull
    public float[] getRetentionTimes(@Nullable float[] var1);

    @Nonnull
    default public float[] getIntensityValues() {
        return this.getIntensityValues(null);
    }

    @Nonnull
    public float[] getIntensityValues(@Nullable float[] var1);

    @Nullable
    default public double[] getMzValues() {
        return this.getMzValues(null);
    }

    @Nullable
    public double[] getMzValues(@Nullable double[] var1);

    @Nullable
    public Double getMz();

    @Nonnull
    public List<IsolationInfo> getIsolations();

    @Nonnull
    public SeparationType getSeparationType();

    public IonAnnotation getIonAnnotation();

    @Nullable
    public Range<Float> getRtRange();
}

