/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.element.svg;

import org.vaadin.firitin.element.svg.SvgGraphicsElement;

public class PathElement
extends SvgGraphicsElement {
    private StringBuilder pathData;

    public PathElement() {
        super("path");
    }

    public PathElement d(String d) {
        this.pathData = null;
        this.setWriteOnlyAttribute("d", d);
        return this;
    }

    public PathElement dRW(String d) {
        this.setAttribute("d", d);
        return this;
    }

    public PathElement clear() {
        this.pathData = new StringBuilder();
        this.scheduleBeforeClientResponse();
        return this;
    }

    public PathElement pathLength(double pathLength) {
        this.setWriteOnlyAttribute("pathLength", String.valueOf(pathLength));
        return this;
    }

    public PathElement pathLengthRW(double pathLength) {
        this.setAttribute("pathLength", String.valueOf(pathLength));
        return this;
    }

    public PathElement moveTo(double x, double y) {
        this.appendCommand("M", x, y);
        return this;
    }

    public PathElement moveToRelative(double dx, double dy) {
        this.appendCommand("m", dx, dy);
        return this;
    }

    public PathElement lineTo(double x, double y) {
        this.appendCommand("L", x, y);
        return this;
    }

    public PathElement lineToRelative(double dx, double dy) {
        this.appendCommand("l", dx, dy);
        return this;
    }

    public PathElement horizontalLineTo(double x) {
        this.appendCommand("H", x);
        return this;
    }

    public PathElement horizontalLineToRelative(double dx) {
        this.appendCommand("h", dx);
        return this;
    }

    public PathElement verticalLineTo(double y) {
        this.appendCommand("V", y);
        return this;
    }

    public PathElement verticalLineToRelative(double dy) {
        this.appendCommand("v", dy);
        return this;
    }

    public PathElement closePath() {
        this.pathData.append(" Z");
        this.scheduleBeforeClientResponse();
        return this;
    }

    public PathElement cubicBezierTo(double x1, double y1, double x2, double y2, double x, double y) {
        this.appendCommand("C", x1, y1, x2, y2, x, y);
        return this;
    }

    public PathElement cubicBezierToRelative(double dx1, double dy1, double dx2, double dy2, double dx, double dy) {
        this.appendCommand("c", dx1, dy1, dx2, dy2, dx, dy);
        return this;
    }

    public PathElement smoothCubicBezierTo(double x2, double y2, double x, double y) {
        this.appendCommand("S", x2, y2, x, y);
        return this;
    }

    public PathElement smoothCubicBezierToRelative(double dx2, double dy2, double dx, double dy) {
        this.appendCommand("s", dx2, dy2, dx, dy);
        return this;
    }

    public PathElement quadraticBezierTo(double x1, double y1, double x, double y) {
        this.appendCommand("Q", x1, y1, x, y);
        return this;
    }

    public PathElement quadraticBezierToRelative(double dx1, double dy1, double dx, double dy) {
        this.appendCommand("q", dx1, dy1, dx, dy);
        return this;
    }

    public PathElement smoothQuadraticBezierTo(double x, double y) {
        this.appendCommand("T", x, y);
        return this;
    }

    public PathElement smoothQuadraticBezierToRelative(double dx, double dy) {
        this.appendCommand("t", dx, dy);
        return this;
    }

    public PathElement arcTo(double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        this.pathData.append(" A ").append(rx).append(",").append(ry).append(" ").append(xAxisRotation).append(" ").append(largeArcFlag ? 1 : 0).append(",").append(sweepFlag ? 1 : 0).append(" ").append(x).append(",").append(y);
        this.scheduleBeforeClientResponse();
        return this;
    }

    public PathElement arcToRelative(double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double dx, double dy) {
        this.pathData.append(" a ").append(rx).append(",").append(ry).append(" ").append(xAxisRotation).append(" ").append(largeArcFlag ? 1 : 0).append(",").append(sweepFlag ? 1 : 0).append(" ").append(dx).append(",").append(dy);
        this.scheduleBeforeClientResponse();
        return this;
    }

    private void appendCommand(String command, double ... values) {
        if (this.pathData == null) {
            this.pathData = new StringBuilder();
        } else {
            this.pathData.append(" ");
        }
        this.pathData.append(command);
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                this.pathData.append(",");
            }
            this.pathData.append(values[i]);
        }
        this.scheduleBeforeClientResponse();
    }

    @Override
    protected void flushPendingAttributes() {
        if (this.pathData != null) {
            this.setWriteOnlyAttribute("d", this.pathData.toString());
            this.pathData = null;
        }
        super.flushPendingAttributes();
    }
}

