/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.geolocation;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import org.vaadin.firitin.geolocation.GeolocationErrorEvent;
import org.vaadin.firitin.geolocation.GeolocationEvent;
import org.vaadin.firitin.geolocation.GeolocationOptions;

public class Geolocation {
    private DomListenerRegistration geoupdate;
    private DomListenerRegistration geoerror;
    private UI ui;
    private Integer id;

    public static Geolocation watchPosition(UpdateListener listener, ErrorListener errorListener) {
        return Geolocation.watchPosition(listener, errorListener, new GeolocationOptions());
    }

    public static Geolocation watchPosition(UpdateListener listener, ErrorListener errorListener, GeolocationOptions options) {
        UI ui = UI.getCurrent();
        return Geolocation.watchPosition(ui, listener, errorListener, options);
    }

    public static Geolocation watchPosition(UI ui, UpdateListener listener, ErrorListener errorListener, GeolocationOptions options) {
        return Geolocation.checkPosition(ui, listener, errorListener, options, false);
    }

    public static void getCurrentPosition(UpdateListener listener, ErrorListener errorListener, GeolocationOptions options) {
        Geolocation.checkPosition(UI.getCurrent(), listener, errorListener, options, true);
    }

    public static void getCurrentPosition(UI ui, UpdateListener listener, ErrorListener errorListener, GeolocationOptions options) {
        Geolocation.checkPosition(ui, listener, errorListener, options, true);
    }

    public static void getCurrentPosition(UpdateListener listener, ErrorListener errorListener) {
        Geolocation.getCurrentPosition(listener, errorListener, new GeolocationOptions());
    }

    private static Geolocation checkPosition(UI ui, UpdateListener listener, ErrorListener errorListener, GeolocationOptions options, boolean get) {
        Geolocation geolocation = new Geolocation();
        geolocation.ui = ui;
        Element eventSourceElement = ui.getElement();
        Component activeModalComponent = ui.getInternals().getActiveModalComponent();
        if (activeModalComponent != null) {
            eventSourceElement = activeModalComponent.getElement();
        }
        String method = get ? "getCurrentPosition" : "watchPosition";
        geolocation.geoupdate = eventSourceElement.addEventListener("geoupdate", (DomEventListener & Serializable)e -> {
            try {
                GeolocationEvent geolocationEvent = (GeolocationEvent)e.getEventDetail(GeolocationEvent.class);
                listener.geolocationUpdate(geolocationEvent);
                if (get) {
                    geolocation.clearListeners();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        geolocation.geoupdate.addEventDetail();
        geolocation.geoerror = eventSourceElement.addEventListener("geoerror", (DomEventListener & Serializable)e -> {
            GeolocationErrorEvent error = (GeolocationErrorEvent)e.getEventDetail(GeolocationErrorEvent.class);
            errorListener.geolocationError(error);
            if (get) {
                geolocation.clearListeners();
            }
        });
        geolocation.geoerror.addEventDetail();
        ui.getElement().executeJs("const el = $1;\nconst options = $0;\nreturn navigator.geolocation." + method + "(\n        p => {\n          var timestamp = p.timestamp;\n          // Desktop Safari has weird epoch of 2001-1-1 ...\n          const safari = (Date.now() - timestamp) > 1000*60*60*24*1000;\n          if(safari) {\n            timestamp = timestamp + 978307200000;\n          }\n          const event = new CustomEvent('geoupdate', {\n            detail: {\n                 coords : {\n                     longitude : p.coords.longitude,\n                     latitude : p.coords.latitude,\n                     accuracy : p.coords.accuracy,\n                     altitude : p.coords.altitude,\n                     altitudeAccuracy : p.coords.altitudeAccuracy,\n                     heading : p.coords.heading,\n                     speed : p.coords.speed\n                 },\n                 timestamp: timestamp\n            }\n         });\n         el.dispatchEvent(event);\n       },\n       e => {\n         const event = new CustomEvent('geoerror', {detail: {code: e.code, message: e.message}});\n         el.dispatchEvent(event);\n       },\n       options\n     );\n", new Object[]{options, eventSourceElement}).then(Integer.class, (SerializableConsumer & Serializable)s -> geolocation.setId((Integer)s));
        return geolocation;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public void cancel() {
        this.ui.getElement().executeJs("navigator.geolocation.clearWatch($0);", new Object[]{this.id});
        this.clearListeners();
    }

    private void clearListeners() {
        if (this.geoerror != null) {
            this.geoerror.remove();
            this.geoerror = null;
        }
        if (this.geoupdate != null) {
            this.geoupdate.remove();
            this.geoupdate = null;
        }
        this.id = null;
    }

    public static interface UpdateListener {
        public void geolocationUpdate(GeolocationEvent var1);
    }

    public static interface ErrorListener {
        public void geolocationError(GeolocationErrorEvent var1);
    }
}

