/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;

public class BrowserPrompt {
    public static CompletableFuture<Integer> promptInteger(String message) {
        return BrowserPrompt.showPrompt(message, "").thenApply(Integer::parseInt);
    }

    public static CompletableFuture<String> promptString(String message) {
        return BrowserPrompt.showPrompt(message, "");
    }

    public static CompletableFuture<String> promptString(String message, String defaultValue) {
        UI ui = UI.getCurrent();
        return BrowserPrompt.showPrompt(ui, message, defaultValue);
    }

    public static CompletableFuture<String> promptString(UI ui, String message, String defaultValue) {
        CompletableFuture<String> stringCompletableFuture = new CompletableFuture<String>();
        ui.getPage().executeJs("return prompt($0, $1)", new Serializable[]{message, defaultValue}).then(String.class, (SerializableConsumer & Serializable)s -> {
            if (s != null) {
                stringCompletableFuture.complete((String)s);
            } else {
                stringCompletableFuture.completeExceptionally(new RuntimeException("Prompt cancelled"));
            }
        });
        return stringCompletableFuture;
    }

    @Deprecated(forRemoval=true)
    public static CompletableFuture<String> showPrompt(String message) {
        return BrowserPrompt.promptString(message, "");
    }

    @Deprecated(forRemoval=true)
    public static CompletableFuture<String> showPrompt(String message, String defaultValue) {
        return BrowserPrompt.promptString(message, defaultValue);
    }

    @Deprecated(forRemoval=true)
    public static CompletableFuture<String> showPrompt(UI ui, String message, String defaultValue) {
        return BrowserPrompt.promptString(ui, message, defaultValue);
    }
}

