/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import jakarta.servlet.http.Cookie;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentHasEnabled;
import org.vaadin.firitin.fluency.ui.FluentHasTooltip;

public class DynamicFileDownloader
extends Anchor
implements FluentComponent<DynamicFileDownloader>,
FluentHasEnabled<DynamicFileDownloader>,
FluentHasTooltip<DynamicFileDownloader> {
    private static final int POLLING_INTERVAL = 999;
    protected RequestHandler requestHandler;
    StreamResource resource = new StreamResource("dummy", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0]));
    FileNameGenerator fileNameGenerator = r -> "downloadedFile";
    private Button button;
    private DomListenerRegistration disableOnclick;
    private ContentTypeGenerator contentTypeGenerator = () -> "application/octet-stream";
    private SerializableConsumer<OutputStream> contentWriter;
    private Integer originalPollingInterval;
    private boolean newWindow;
    private UI ui;
    private boolean hasFinishedListeners;
    private boolean hasStartedListeners;

    public DynamicFileDownloader(ContentWriter writer) {
        this.add(new Component[]{new VButton(VaadinIcon.DOWNLOAD.create())});
        this.setWriter(writer);
    }

    public DynamicFileDownloader(String linkText, ContentWriter contentWriter) {
        this();
        this.setText(linkText);
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader(String linkText, String fileName, ContentWriter contentWriter) {
        this();
        this.setText(linkText);
        this.fileNameGenerator = r -> fileName;
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader(Component downloadComponent, String fileName, ContentWriter contentWriter) {
        this();
        this.add(new Component[]{downloadComponent});
        this.fileNameGenerator = r -> fileName;
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader(Component downloadComponent, ContentWriter contentWriter) {
        this();
        this.add(new Component[]{downloadComponent});
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader() {
    }

    public void setDisableOnClick(boolean disableOnClick) {
        if (this.disableOnclick != null) {
            this.disableOnclick.remove();
        }
        if (disableOnClick) {
            this.getElement().executeJs("const el = this;\nthis.addEventListener(\"click\", e => {\n    setTimeout(() => el.removeAttribute(\"href\"), 0);\n});\n", new Serializable[0]);
            this.disableOnclick = this.getElement().addEventListener("click", (DomEventListener & Serializable)e -> this.setEnabled(false));
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isAttached()) {
            this.adjustHref();
        }
    }

    @ClientCallable
    private void ping() {
    }

    private void setWriter(ContentWriter contentWriter) {
        this.contentWriter = (SerializableConsumer & Serializable)out -> {
            try {
                contentWriter.writeContent((OutputStream)out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.ui = attachEvent.getUI();
        this.prepareRequestHandler(attachEvent);
    }

    private void prepareRequestHandler(AttachEvent attachEvent) {
        this.ensurePollingOrPush(attachEvent);
        this.getElement().setAttribute("fakesr", (AbstractStreamResource)this.resource);
        String identifier = this.adjustHref();
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.requestHandler = new RequestHandler(){
                final /* synthetic */ UI val$ui;
                final /* synthetic */ String val$identifier;
                {
                    this.val$ui = uI;
                    this.val$identifier = string;
                }

                public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
                    String id;
                    if (DynamicFileDownloader.this.hasStartedListeners) {
                        this.val$ui.access((Command & Serializable)() -> DynamicFileDownloader.this.getEventBus().fireEvent((ComponentEvent)new DownloadStartedEvent(DynamicFileDownloader.this, false)));
                    }
                    if ((id = request.getParameter("id")) != null && id.equals(this.val$identifier)) {
                        response.setStatus(200);
                        String filename = DynamicFileDownloader.this.getFileName(session, request);
                        if (filename == null) {
                            filename = DynamicFileDownloader.this.fileNameGenerator.getFileName(request);
                        }
                        response.setHeader("Content-Disposition", (DynamicFileDownloader.this.newWindow ? "" : "attachment;") + "filename*=UTF-8''" + URLEncoder.encode(filename, StandardCharsets.UTF_8));
                        response.setHeader("Content-Type", DynamicFileDownloader.this.contentTypeGenerator.getContentType());
                        Cookie marker = new Cookie("filedownloadmarker-" + id, "filewritten");
                        marker.setPath("/");
                        marker.setMaxAge(3600);
                        response.addCookie(marker);
                        try {
                            DynamicFileDownloader.this.contentWriter.accept((Object)response.getOutputStream());
                        }
                        catch (Exception e) {
                            try {
                                response.setStatus(500);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DynamicFileDownloader.this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> DynamicFileDownloader.this.getEventBus().fireEvent((ComponentEvent)new DownloadFailedEvent(DynamicFileDownloader.this, e))));
                            e.printStackTrace();
                            return true;
                        }
                        if (DynamicFileDownloader.this.hasFinishedListeners) {
                            this.val$ui.access((Command & Serializable)() -> DynamicFileDownloader.this.getEventBus().fireEvent((ComponentEvent)new DownloadFinishedEvent(DynamicFileDownloader.this, false)));
                        }
                        return true;
                    }
                    return false;
                }
            };
            ui.getSession().addRequestHandler(this.requestHandler);
            if (!this.newWindow) {
                this.getElement().setAttribute("download", "");
            } else {
                this.setRouterIgnore(true);
                this.setTarget("_blank");
            }
        });
    }

    private String adjustHref() {
        String identifier = this.resource.getId();
        VaadinSession session = ((UI)this.getUI().get()).getSession();
        if (this.isEnabled()) {
            if (this.requestHandler != null && !session.getRequestHandlers().contains(this.requestHandler)) {
                session.addRequestHandler(this.requestHandler);
            }
            this.getElement().executeJs("const id = '%s';\nthis.setAttribute(\"href\",\n        this.getAttribute(\"fakesr\").substring(0, this.getAttribute(\"fakesr\").indexOf(\"VAADIN\"))\n                + \"?v-r=dfd&id=\" + id);\n\nthis.onclick = e=> {\n\n    if(this.downloadStartedListener) {\n        setTimeout(() => {\n            this.$server.ping();\n        }, 100);\n    }\n\n    // start an interval that checks if a cookie with identifier has been set,\n    // if so, stop interval, hit server for possible errors & UI modifications\n    this.interval = setInterval(() => {\n        if(document.cookie.indexOf(id + '=filewritten') > -1) {\n            var d = new Date();\n            d.setDate(d.getDate() - 1);\n            var expires = \";expires=\" + d;\n            document.cookie = \"filedownloadmarker-\"+ id + \"=registered\" + expires + \"; path=/\";\n            clearInterval(this.interval);\n            this.$server.ping();\n        }\n    }, 1000);\n}\n".formatted(identifier), new Serializable[0]);
        } else {
            this.getElement().executeJs("this.removeAttribute('href');", new Serializable[0]);
            if (this.requestHandler != null) {
                session.removeRequestHandler(this.requestHandler);
            }
        }
        return identifier;
    }

    protected void ensurePollingOrPush(AttachEvent attachEvent) {
        try {
            UI ui = attachEvent.getUI();
            if (ui.getPushConfiguration().getPushMode().isEnabled()) {
                return;
            }
        }
        catch (Exception e) {
            Logger.getLogger(DynamicFileDownloader.class.getName()).log(Level.WARNING, "Failed to set polling interval", e);
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.cleanupRequestHandler(detachEvent);
        super.onDetach(detachEvent);
    }

    private void cleanupRequestHandler(DetachEvent detachEvent) {
        try {
            if (this.originalPollingInterval != null && detachEvent.getUI().getPollInterval() == 999 && !detachEvent.getUI().isClosing()) {
                detachEvent.getUI().setPollInterval(this.originalPollingInterval.intValue());
            }
        }
        catch (Exception e) {
            Logger.getLogger(DynamicFileDownloader.class.getName()).log(Level.WARNING, "Failed to reset polling interval", e);
        }
        detachEvent.getSession().removeRequestHandler(this.requestHandler);
    }

    public Registration addDownloadFinishedListener(ComponentEventListener<DownloadFinishedEvent> listener) {
        this.hasFinishedListeners = true;
        return this.addListener(DownloadFinishedEvent.class, listener);
    }

    public Registration addDownloadStartedListener(ComponentEventListener<DownloadStartedEvent> listener) {
        this.hasStartedListeners = true;
        this.getElement().setProperty("downloadStartedListener", true);
        return this.addListener(DownloadStartedEvent.class, listener);
    }

    public Registration addDownloadFailedListener(ComponentEventListener<DownloadFailedEvent> listener) {
        return this.addListener(DownloadFailedEvent.class, listener);
    }

    public void setFileHandler(SerializableConsumer<OutputStream> contentWriter) {
        this.contentWriter = contentWriter;
    }

    public void setFileName(String fileName) {
        this.fileNameGenerator = r -> fileName;
    }

    @Deprecated
    protected String getFileName(VaadinSession session, VaadinRequest request) {
        return null;
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public DynamicFileDownloader asButton() {
        String text = this.getText();
        this.setText(null);
        this.button = new Button(text);
        this.add(new Component[]{this.button});
        return this;
    }

    public Button getButton() {
        if (this.button == null) {
            throw new IllegalStateException("asButton() is not called!");
        }
        return this.button;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public DynamicFileDownloader withFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.setFileNameGenerator(fileNameGenerator);
        return this;
    }

    public void setContentTypeGenerator(ContentTypeGenerator contentTypeGenerator) {
        this.contentTypeGenerator = contentTypeGenerator;
    }

    public DynamicFileDownloader withContentTypeGenerator(ContentTypeGenerator contentTypeGenerator) {
        this.setContentTypeGenerator(contentTypeGenerator);
        return this;
    }

    public Tooltip setTooltipText(String text) {
        HasTooltip component = (HasTooltip)this.getChildren().findFirst().get();
        return component.setTooltipText(text);
    }

    public Tooltip getTooltip() {
        HasTooltip component = (HasTooltip)this.getChildren().findFirst().get();
        return component.getTooltip();
    }

    public DynamicFileDownloader inNewWindow() {
        this.newWindow = true;
        return this;
    }

    @FunctionalInterface
    public static interface FileNameGenerator
    extends Serializable {
        public String getFileName(VaadinRequest var1);
    }

    @FunctionalInterface
    public static interface ContentTypeGenerator
    extends Serializable {
        public String getContentType();
    }

    @FunctionalInterface
    public static interface ContentWriter
    extends Serializable {
        public void writeContent(OutputStream var1) throws IOException;
    }

    public static class DownloadFinishedEvent
    extends ComponentEvent<DynamicFileDownloader> {
        public DownloadFinishedEvent(DynamicFileDownloader source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static class DownloadStartedEvent
    extends ComponentEvent<DynamicFileDownloader> {
        public DownloadStartedEvent(DynamicFileDownloader source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static class DownloadFailedEvent
    extends ComponentEvent<DynamicFileDownloader> {
        private final Exception exception;

        public DownloadFailedEvent(DynamicFileDownloader source, Exception e) {
            super((Component)source, false);
            this.exception = e;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

