/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import fr.ird.t3.actions.T3Action;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.T3ActionSupport;
import freemarker.ext.beans.BeansWrapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.StringUtil;

public abstract class AbstractRunAction<C extends T3ActionConfiguration, A extends T3Action<C>>
extends T3ActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractRunAction.class);
    protected transient T3ActionContext<C> t3ActionContext;
    private final Class<A> actionType;
    protected ActionContext ac;

    protected AbstractRunAction(Class<A> actionType) {
        this.actionType = actionType;
    }

    public final Class<A> getActionType() {
        return this.actionType;
    }

    public final T3ActionContext<C> getT3ActionContext() {
        return this.t3ActionContext;
    }

    public final C getConfiguration() {
        return (C)this.t3ActionContext.getConfiguration();
    }

    public void prepare() throws Exception {
        this.t3ActionContext = this.getT3Session().getActionContext();
        this.ac = ActionContext.getContext();
        this.getConfiguration();
        this.injectOnly(new Class[]{InjectDecoratedBeans.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String execute() throws Exception {
        ActionContext.setContext((ActionContext)this.ac);
        this.t3ActionContext.setServiceContext(this.getServiceContext());
        this.t3ActionContext.clearMessages();
        TopiaContext tx = T3EntityHelper.newTransactionFromRootContext((TopiaContext)this.getTransaction());
        this.t3ActionContext.setTransaction(tx);
        try {
            T3Action action = this.getServiceFactory().newT3Action(this.getActionType(), this.t3ActionContext);
            this.executeAction(action);
        }
        finally {
            T3EntityHelper.closeConnection((TopiaContext)tx);
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAction(A action) throws Exception {
        block13: {
            Exception error = null;
            Date startDate = new Date();
            try {
                action.run();
            }
            catch (Exception e) {
                error = e;
                if (log.isErrorEnabled()) {
                    log.error((Object)"An error occurs while action", (Throwable)e);
                }
            }
            finally {
                Date endDate = new Date();
                try {
                    String resume = this.buildActionResume(action, error, startDate, endDate);
                    this.t3ActionContext.setResume(resume);
                    this.addContentInFile(this.getT3Session(), "\n--------------------------------------------------------------------------------\n" + resume);
                }
                finally {
                    if (error == null) break block13;
                    throw error;
                }
            }
        }
    }

    public String getTotalTime() {
        return StringUtil.convertTime((long)this.t3ActionContext.getTotalTime());
    }

    protected <O> O getResult(String name, Class<O> type) {
        Object result = this.t3ActionContext.getResult(name, type);
        return (O)result;
    }

    protected <O> List<O> getResultAsList(String name, Class<O> type) {
        List result = this.t3ActionContext.getResultAsList(name, type);
        return result;
    }

    protected <K, V> Map<K, V> getResultAsMap(String name) {
        Map result = this.t3ActionContext.getResultAsMap(name);
        return result;
    }

    protected String buildActionResume(A action, Exception error, Date startDate, Date endDate) throws Exception {
        String templateName = action.getRenderTemplateName();
        Map parameters = this.prepareResumeParameters(action, error, startDate, endDate);
        String resume = this.getFreeMarkerService().renderTemplate(templateName, this.getLocale(), parameters);
        resume = resume.trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action resume =\n" + resume));
        }
        return resume;
    }

    protected Map<String, Object> prepareResumeParameters(A action, Exception error, Date startDate, Date endDate) {
        TreeMap parameters = Maps.newTreeMap();
        parameters.put("startDate", startDate);
        parameters.put("endDate", endDate);
        parameters.put("action", action);
        parameters.put("error", error);
        parameters.put("configuration", action.getConfiguration());
        parameters.put("showError", true);
        parameters.put("showWarning", true);
        parameters.put("showInfo", false);
        parameters.put("statics", BeansWrapper.getDefaultInstance().getStaticModels());
        return parameters;
    }
}

