/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import com.google.common.base.Charsets;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.dispatcher.DefaultStaticContentLoader;

public class T3StaticContentLoader
extends DefaultStaticContentLoader {
    private final Logger log = LoggerFactory.getLogger(T3StaticContentLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(InputStream is, String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (is != null) {
            Calendar cal = Calendar.getInstance();
            long ifModifiedSince = 0L;
            try {
                ifModifiedSince = request.getDateHeader("If-Modified-Since");
            }
            catch (Exception e) {
                this.log.warn("Invalid If-Modified-Since header value: '" + request.getHeader("If-Modified-Since") + "', ignoring", new String[0]);
            }
            long lastModifiedMillis = this.lastModifiedCal.getTimeInMillis();
            long now = cal.getTimeInMillis();
            cal.add(5, 1);
            long expires = cal.getTimeInMillis();
            if (ifModifiedSince > 0L && ifModifiedSince <= lastModifiedMillis) {
                response.setDateHeader("Expires", expires);
                response.setStatus(304);
                is.close();
                return;
            }
            String contentType = this.getContentType(path);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            if (this.serveStaticBrowserCache) {
                response.setDateHeader("Date", now);
                response.setDateHeader("Expires", expires);
                response.setDateHeader("Retry-After", expires);
                response.setHeader("Cache-Control", "public");
                response.setDateHeader("Last-Modified", lastModifiedMillis);
            } else {
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "-1");
            }
            try {
                this.copy(is, (OutputStream)response.getOutputStream(), path);
            }
            finally {
                is.close();
            }
        }
    }

    protected void copy(InputStream input, OutputStream output, String path) throws IOException {
        if (path.contains(".js")) {
            String content = IOUtils.toString((InputStream)input);
            if (content.indexOf("/") == 1) {
                content = content.substring(1);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Content:\n" + content, new String[0]);
            }
            IOUtils.write((String)content, (OutputStream)output, (Charset)Charsets.ISO_8859_1);
        } else {
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }
}

