/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.data.TripDTO;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.OceanDAO;
import fr.ird.t3.entities.reference.Vessel;
import fr.ird.t3.entities.reference.VesselDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.web.actions.admin.TripListModel;
import fr.ird.t3.web.actions.json.AbstractJSONPaginedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;
import org.nuiton.util.TimeLog;

public class GetTripsAction
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GetTripsAction.class);
    private static final TimeLog TIME_LOG = new TimeLog(GetTripsAction.class);
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    @InjectDAO(entityType=Ocean.class)
    protected transient OceanDAO oceanDAO;
    @InjectDAO(entityType=Country.class)
    protected transient CountryDAO countryDAO;
    @InjectDAO(entityType=Vessel.class)
    protected transient VesselDAO vesselDAO;
    protected List<TripDTO> trips;
    protected TripListModel model;

    public List<TripDTO> getTrips() {
        return this.trips;
    }

    public String execute() throws Exception {
        ArrayList allTripIds;
        this.injectOnly(new Class[]{InjectDAO.class});
        long t0 = TimeLog.getTime();
        this.model = this.getT3Session().getTripListModel();
        TIME_LOG.log(t0, "getTrips (ocean filter)");
        Multimap tripsByOcean = this.model.getTripIdsByOcean();
        if (this.model.isOceanFilter()) {
            List oceanIds = this.model.getOceanIds();
            allTripIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)oceanIds)) {
                for (String oceanId : oceanIds) {
                    Ocean ocean = "null".equals(oceanId) ? null : (Ocean)this.oceanDAO.findByTopiaId(oceanId);
                    Collection allByOcean = tripsByOcean.get(ocean);
                    allTripIds.addAll(allByOcean);
                }
            }
        } else {
            allTripIds = Lists.newArrayList((Iterable)tripsByOcean.values());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Nb total trips : " + allTripIds.size()));
        }
        t0 = TimeLog.getTime();
        List allTrips = CollectionUtils.isEmpty((Collection)allTripIds) ? Lists.newArrayList() : this.tripDAO.findAllByIds((List)allTripIds);
        TIME_LOG.log(t0, "load from ids");
        t0 = TimeLog.getTime();
        if (CollectionUtils.isNotEmpty((Collection)allTrips) && this.model.isYearFilter()) {
            this.filterYears(allTrips);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Nb total trips (after year filter) " + allTrips.size()));
        }
        if (CollectionUtils.isNotEmpty((Collection)allTrips) && this.model.isVesselFilter() || this.model.isFlagFilter() || this.model.isFleetFilter()) {
            this.filterVessels(allTrips);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Nb total trips (after vessel / flag / fleet filter) " + allTrips.size()));
        }
        TIME_LOG.log(t0, "all filter");
        this.initFilter();
        this.pager.setRecords((long)allTrips.size());
        List filteredTrips = this.getPageFromList(allTrips);
        if (log.isInfoEnabled()) {
            log.info((Object)("pager pageSize         : " + this.pager.getPageSize()));
            log.info((Object)("pager pagesNumber      : " + this.pager.getPagesNumber()));
            log.info((Object)("pager pageIndex        : " + this.pager.getPageIndex()));
            log.info((Object)("pager records          : " + this.pager.getRecords()));
            log.info((Object)("pager recordStartIndex : " + this.pager.getRecordStartIndex()));
            log.info((Object)("pager recordEndIndex   : " + this.pager.getRecordEndIndex()));
        }
        this.trips = TripDAO.toDTO((List)filteredTrips);
        return "success";
    }

    private void filterYears(List<Trip> allTrips) {
        List years = this.model.getYears();
        if (CollectionUtils.isEmpty((Collection)years)) {
            allTrips.clear();
        } else {
            TripDAO.retainsDepartureYears(allTrips, (Collection)years);
        }
    }

    private void filterVessels(List<Trip> allTrips) throws TopiaException {
        Set vessels = VesselDAO.getAllVessels(allTrips);
        if (CollectionUtils.isNotEmpty((Collection)vessels) && this.model.isVesselFilter()) {
            List vesselIds = this.model.getVesselIds();
            if (CollectionUtils.isEmpty((Collection)vesselIds)) {
                vessels.clear();
            } else {
                Collection vesselsToFilter = this.loadEntities((TopiaDAO)this.vesselDAO, (Iterable)vesselIds);
                vessels.retainAll(vesselsToFilter);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)vessels) && this.model.isFlagFilter()) {
            List flagIds = this.model.getFlagIds();
            if (CollectionUtils.isEmpty((Collection)flagIds)) {
                vessels.clear();
            } else {
                Collection flags = this.loadEntities((TopiaDAO)this.countryDAO, (Iterable)flagIds);
                VesselDAO.retainsFlagCountries((Collection)vessels, (Collection)flags);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)vessels) && this.model.isFleetFilter()) {
            List fleetIds = this.model.getFleetIds();
            if (CollectionUtils.isEmpty((Collection)fleetIds)) {
                vessels.clear();
            } else {
                Collection fleets = this.loadEntities((TopiaDAO)this.countryDAO, (Iterable)fleetIds);
                VesselDAO.retainsFleetCountries((Collection)vessels, (Collection)fleets);
            }
        }
        if (CollectionUtils.isEmpty((Collection)vessels)) {
            allTrips.clear();
        } else {
            TripDAO.retainsVessels(allTrips, (Collection)vessels);
        }
    }

    public Integer getRows() {
        return this.pager.getPageSize();
    }

    public Integer getPage() {
        return this.pager.getPageIndex();
    }

    public Long getTotal() {
        return this.pager.getPagesNumber();
    }

    public Long getRecords() {
        return this.pager.getRecords();
    }

    protected <E extends TopiaEntity> Collection<E> loadEntities(TopiaDAO<E> dao, Iterable<String> ids) throws TopiaException {
        ArrayList result = Lists.newArrayList();
        for (String id : ids) {
            TopiaEntity e = dao.findByTopiaId(id);
            result.add(e);
        }
        return result;
    }

    protected <E> List<E> getPageFromList(List<E> elements) {
        PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
        List subList = PagerBeanUtil.getPage(elements, (int)this.pager.getPageIndex(), (int)this.pager.getPageSize());
        ArrayList result = new ArrayList(subList);
        return result;
    }
}

