/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.data.level1;

import com.google.common.collect.Multimap;
import fr.ird.t3.actions.data.level1.AbstractLevel1Action;
import fr.ird.t3.actions.data.level1.Level1Configuration;
import fr.ird.t3.actions.data.level1.Level1Step;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.SampleQuality;
import fr.ird.t3.entities.reference.SampleType;
import fr.ird.t3.services.ioc.InjectDecoratedBeans;
import fr.ird.t3.web.actions.AbstractRunAction;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractLevel1RunAction<A extends AbstractLevel1Action>
extends AbstractRunAction<Level1Configuration, A> {
    private static final long serialVersionUID = 1L;
    protected final Level1Step currentStep;
    @InjectDecoratedBeans(beanType=SampleQuality.class, filterById=true, pathIds="sampleQualityIds")
    protected Map<String, String> sampleQualities;
    @InjectDecoratedBeans(beanType=SampleType.class, filterById=true)
    protected Map<String, String> sampleTypes;
    @InjectDecoratedBeans(beanType=Country.class, filterById=true)
    protected Map<String, String> fleets;
    @InjectDecoratedBeans(beanType=Ocean.class, filterById=true, filterBySingleId=true)
    protected Map<String, String> oceans;

    protected AbstractLevel1RunAction(Class<A> actionType, Level1Step currentStep) {
        super(actionType);
        this.currentStep = currentStep;
    }

    protected void executeAction(A action) throws Exception {
        Level1Configuration configuration = (Level1Configuration)this.getConfiguration();
        Set executedSteps = configuration.getExecutedSteps();
        int ordinal = this.currentStep.ordinal();
        Iterator itr = executedSteps.iterator();
        while (itr.hasNext()) {
            Level1Step step = (Level1Step)itr.next();
            if (step.ordinal() < ordinal) continue;
            itr.remove();
        }
        super.executeAction(action);
        configuration.addExecutedStep(this.currentStep);
    }

    public Map<String, String> getSampleQualities() {
        return this.sampleQualities;
    }

    public Map<String, String> getSampleTypes() {
        return this.sampleTypes;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public int getMatchingTripCount() {
        Map tripIds = this.getTripIds().asMap();
        return MapUtils.isEmpty((Map)tripIds) ? 0 : tripIds.size();
    }

    public int getMatchingSampleCount() {
        Map tripIds = this.getTripIds().asMap();
        if (MapUtils.isEmpty((Map)tripIds)) {
            return 0;
        }
        int nbSamples = 0;
        for (Collection sampleIds : tripIds.values()) {
            nbSamples += sampleIds.size();
        }
        return nbSamples;
    }

    public int getNotMatchingSampleCount() {
        return ((Level1Configuration)this.getConfiguration()).getNotTreatedSampleReason().size();
    }

    public Multimap<String, String> getTripIds() {
        Multimap ids = ((Level1Configuration)this.getConfiguration()).getSampleIdsByTripId();
        return ids;
    }

    protected Map<String, Object> prepareResumeParameters(A action, Exception error, Date startDate, Date endDate) {
        Map map = super.prepareResumeParameters(action, error, startDate, endDate);
        map.put("oceans", this.oceans);
        map.put("sampleQualities", this.sampleQualities);
        map.put("sampleTypes", this.sampleTypes);
        map.put("fleets", this.fleets);
        return map;
    }
}

