/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import fr.ird.t3.web.T3ApplicationContext;
import fr.ird.t3.web.actions.T3ActionSupport;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

public class T3InternalTransactionFilter
extends TopiaTransactionFilter {
    private static final Log log = LogFactory.getLog(T3InternalTransactionFilter.class);
    public static final String INTERNAL_TRANSACTION = "internalTransaction";

    public static TopiaContext getTransaction(ServletRequest request) {
        TopiaContext topiaContext = (TopiaContext)request.getAttribute(INTERNAL_TRANSACTION);
        return topiaContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.setRequestAttributeName(INTERNAL_TRANSACTION);
    }

    protected TopiaContext beginTransaction(ServletRequest request) throws TopiaRuntimeException {
        T3ApplicationContext applicationContext = T3ActionSupport.getT3ApplicationContext();
        TopiaContext rootContext = applicationContext.getInternalRootContext();
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starts a new internal transaction " + transaction));
            }
            return transaction;
        }
        catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", (Throwable)eee);
        }
    }
}

