/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import fr.ird.t3.T3Configuration;
import fr.ird.t3.web.T3Session;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class T3ApplicationContext {
    private static final Log log = LogFactory.getLog(T3ApplicationContext.class);
    private static final String APPLICATION_CONTEXT_PARAMETER = "t3ApplicationContext";
    protected T3Configuration configuration;
    protected TopiaContext internalRootContext;
    protected Set<T3Session> t3Sessions;

    public static T3ApplicationContext getT3ApplicationContext(ActionContext actionContext) {
        Map application = actionContext.getApplication();
        T3ApplicationContext result = (T3ApplicationContext)application.get(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static T3ApplicationContext getT3ApplicationContext(ServletContext servletContext) {
        T3ApplicationContext result = (T3ApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static void setT3ApplicationContext(ServletContext servletContext, T3ApplicationContext applicationContext) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, (Object)applicationContext);
    }

    public static void remove3ApplicationContext(ServletContext servletContext) {
        servletContext.removeAttribute(APPLICATION_CONTEXT_PARAMETER);
    }

    public Set<T3Session> getT3Sessions() {
        return this.t3Sessions;
    }

    public synchronized void registerT3Session(T3Session session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        if (this.t3Sessions == null) {
            this.t3Sessions = Sets.newHashSet();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Register user session for [" + session.getUser().getLogin() + "]"));
        }
        this.t3Sessions.add(session);
    }

    public synchronized void destroyT3Session(T3Session session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        Preconditions.checkNotNull((Object)this.t3Sessions);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroy user session for [" + session.getUser().getLogin() + "]"));
        }
        this.t3Sessions.remove(session);
        session.close();
    }

    public T3Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(T3Configuration configuration) {
        this.configuration = configuration;
    }

    public TopiaContext getInternalRootContext() {
        return this.internalRootContext;
    }

    public void setInternalRootContext(TopiaContext internalRootContext) {
        this.internalRootContext = internalRootContext;
    }
}

