/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.entities.reference.CountryDAO;
import fr.ird.t3.entities.reference.VesselDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.web.actions.T3BaseTransactionAction;
import fr.ird.t3.web.actions.admin.TripListModel;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TripListAction
extends T3BaseTransactionAction {
    protected static final Log log = LogFactory.getLog(TripListAction.class);
    private static final long serialVersionUID = 1L;
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    protected Map<String, String> years;
    protected Map<String, String> oceans;
    protected Map<String, String> fleets;
    protected Map<String, String> flags;
    protected Map<String, String> vessels;
    protected TripListModel tripListModel;
    protected boolean back;

    public Map<String, String> getYears() {
        return this.years;
    }

    public Map<String, String> getOceans() {
        return this.oceans;
    }

    public Map<String, String> getFleets() {
        return this.fleets;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public Map<String, String> getVessels() {
        return this.vessels;
    }

    public TripListModel getTripListModel() {
        if (this.tripListModel == null) {
            this.tripListModel = this.getT3Session().getTripListModel();
            if (this.tripListModel == null) {
                this.tripListModel = new TripListModel();
            }
        }
        return this.tripListModel;
    }

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class});
        if (!this.back) {
            this.getT3Session().removeTripListModel();
            this.tripListModel = null;
        } else {
            this.tripListModel = this.getT3Session().getTripListModel();
        }
        if (this.tripListModel == null) {
            this.tripListModel = new TripListModel();
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading tripListModel...");
            }
            this.tripListModel.setTripsByOcean(this.tripDAO.findAllByOcean());
            this.getT3Session().setTripListModel(this.tripListModel);
            if (log.isInfoEnabled()) {
                log.info((Object)("tripListModel loaded ... " + this.tripListModel.getNbTrips()));
            }
        }
        Multimap tripsByOcean = this.tripListModel.getTripsByOcean();
        Set allOceans = tripsByOcean.keySet();
        Collection allTrips = tripsByOcean.values();
        Set allFleets = CountryDAO.getAllFleetCountries((Collection)allTrips);
        Set allFlags = CountryDAO.getAllFlagCountries((Collection)allTrips);
        Set allVessels = VesselDAO.getAllVessels((Collection)allTrips);
        Set allYears = TripDAO.getAllTripsDepartureYear((Collection)allTrips);
        this.years = Maps.newLinkedHashMap();
        for (Integer year : allYears) {
            this.years.put(year + "", year + "");
        }
        this.oceans = this.sortAndDecorate((Collection)allOceans);
        this.fleets = this.sortAndDecorate((Collection)allFleets);
        this.flags = this.sortAndDecorate((Collection)allFlags);
        this.vessels = this.sortAndDecorate((Collection)allVessels);
        return "input";
    }

    public String loadGrid() throws Exception {
        this.tripListModel = this.getT3Session().getTripListModel();
        return "input";
    }

    public String backToTrip() throws Exception {
        this.back = true;
        return this.input();
    }
}

