/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report.model.operations;

import fr.ird.observe.ui.admin.report.model.DataMatrix;
import fr.ird.observe.ui.admin.report.model.Report;
import fr.ird.observe.ui.admin.report.model.ReportOperation;
import fr.ird.observe.ui.admin.report.model.ReportRequest;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ExecuteRequests
extends ReportOperation {
    private static final Log log = LogFactory.getLog(ExecuteRequests.class);
    private static final long serialVersionUID = 1L;
    public static final String OPERATION_NAME = "ExecuteRequests";
    protected Properties params;

    public ExecuteRequests() {
    }

    public ExecuteRequests(Properties params) {
        this.params = params;
    }

    @Override
    public String getOperationName() {
        return OPERATION_NAME;
    }

    public Properties getParams() {
        return this.params;
    }

    public void setParams(Properties params) {
        this.params = params;
    }

    @Override
    public DataMatrix execute(TopiaContext tx, Report report, DataMatrix incoming) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch " + this));
        }
        ReportRequest[] requests = report.getRequests();
        DataMatrix[] requestResults = new DataMatrix[requests.length];
        int i = 0;
        for (ReportRequest request : requests) {
            DataMatrix result = request.execute(tx, this.params);
            requestResults[i++] = result;
        }
        int rows = report.getRows();
        int columns = report.getColumns();
        DataMatrix result = DataMatrix.merge(rows, columns, requestResults);
        return result;
    }

    @Override
    protected Point computeLocation(Report model, DataMatrix incoming) {
        Point result = new Point(0, 0);
        return result;
    }

    @Override
    protected Dimension computeDimension(Report model, DataMatrix incoming) {
        Dimension result = new Dimension(0, 0);
        return result;
    }
}

