/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveConfigOption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.SortedProperties;

public class ObserveResourceManager {
    public static final String OBSERVE_UI_PROPERTIES = "/observe-ui.properties";
    public static final String OBSERVE_APPLICATION_PROPERTIES = "/observe-application.properties";
    public static final String OBSERVE_REPORTS_PROPERTIES = "/observe-reports.properties";
    private static Log log = LogFactory.getLog(ObserveResourceManager.class);
    protected Map<String, Properties> resources;

    public Map<String, Properties> getResources() {
        if (this.resources == null) {
            this.resources = new TreeMap<String, Properties>();
        }
        return this.resources;
    }

    public Properties getResource(Resource resource) throws IOException {
        URL url = resource.getUrl();
        Properties result = this.getResource(url);
        return result;
    }

    public Properties getResource(File file) throws IOException {
        URL url = file.toURI().toURL();
        Properties result = this.load(url);
        return result;
    }

    public Properties getResource(URL url) throws IOException {
        String path = url.toString();
        Properties result = this.getResources().get(path);
        if (result == null) {
            result = this.load(url);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Store configuration [" + path + "]"));
            }
            this.getResources().put(path, result);
        }
        SortedProperties tmp = new SortedProperties();
        tmp.putAll((Map)result);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties load(URL url) throws IOException {
        Properties result;
        InputStream in = ObserveResourceManager.openInternalStream(url);
        try {
            result = new Properties();
            result.load(in);
        }
        finally {
            in.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(Resource resource, File file, String message) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            Properties props = this.getResource(resource);
            props.store(out, "Generated by " + this.getClass().getName() + ".");
            log.info((Object)message);
        }
        finally {
            out.close();
        }
    }

    protected File createDirectory(ObserveConfig config, ObserveConfigOption option) throws IOException {
        File dir = config.getOptionAsFile(option.key);
        this.createDirectory(dir);
        return dir;
    }

    protected void createParentDirectory(ObserveConfig config, ObserveConfigOption ... options) throws IOException {
        for (ObserveConfigOption option : options) {
            File dir = config.getOptionAsFile(option.key).getParentFile();
            this.createDirectory(dir);
        }
    }

    protected void createDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)I18n._((String)"observe.runner.create.directory", (Object[])new Object[]{dir}));
            } else {
                log.info((Object)I18n._((String)"observe.runner.exists.directory", (Object[])new Object[]{dir}));
            }
            boolean b = dir.mkdirs();
            if (!b) {
                throw new IOException(I18n._((String)"observe.error.can.not.create.directory", (Object[])new Object[]{dir}));
            }
        }
    }

    protected static URL getResource(String location) {
        URL resource = ObserveResourceManager.class.getResource(location);
        try {
            InputStream in = ObserveResourceManager.openInternalStream(resource);
            in.close();
            return resource;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not treate internal resource " + location);
        }
    }

    protected static InputStream openInternalStream(URL resource) {
        try {
            InputStream in = resource.openStream();
            if (in == null) {
                throw new IllegalStateException("Could not find internal resource " + resource);
            }
            return in;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not treate internal resource " + resource);
        }
    }

    public static enum Resource {
        ui("/observe-ui.properties"),
        application("/observe-application.properties"),
        report("/observe-reports.properties");

        private final String location;
        private URL url;

        private Resource(String location) {
            this.location = location;
        }

        public URL getUrl() {
            if (this.url == null) {
                this.url = ObserveResourceManager.getResource(this.location);
            }
            return this.url;
        }

        public boolean exists(File directory) {
            File file = this.getFile(directory);
            return file.exists();
        }

        public File getFile(File directory) {
            File file = new File(directory, this.location.substring(1));
            return file;
        }
    }
}

