/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.workgroup.packet.Transcript;
import org.jivesoftware.smackx.workgroup.packet.Transcripts;

public class TranscriptManager {
    private Connection connection;

    public TranscriptManager(Connection connection) {
        this.connection = connection;
    }

    public Transcript getTranscript(String workgroupJID, String sessionID) throws XMPPException {
        Transcript request = new Transcript(sessionID);
        request.setTo(workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        Transcript response = (Transcript)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public Transcripts getTranscripts(String workgroupJID, String userID) throws XMPPException {
        Transcripts request = new Transcripts(userID);
        request.setTo(workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(request.getPacketID()));
        this.connection.sendPacket((Packet)request);
        Transcripts response = (Transcripts)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }
}

