/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class LabellingGenerator
implements RuleMethodProcessor {
    LabellingGenerator() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return !method.hasDontLabelAnnotation();
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        LabelNode isNullLabel = new LabelNode();
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
        instructions.insertBefore(ret, (AbstractInsnNode)new JumpInsnNode(198, isNullLabel));
        instructions.insertBefore(ret, (AbstractInsnNode)new LdcInsnNode((Object)this.getLabelText(method)));
        instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(185, Types.RULE.getInternalName(), "label", "(Ljava/lang/String;)" + Types.RULE_DESC));
        instructions.insertBefore(ret, (AbstractInsnNode)isNullLabel);
    }

    public String getLabelText(RuleMethod method) {
        if (method.visibleAnnotations != null) {
            for (Object annotationObj : method.visibleAnnotations) {
                AnnotationNode annotation = (AnnotationNode)annotationObj;
                if (!annotation.desc.equals(Types.LABEL_DESC) || annotation.values == null) continue;
                Preconditions.checkState((boolean)"value".equals(annotation.values.get(0)));
                String labelValue = (String)annotation.values.get(1);
                return StringUtils.isEmpty((String)labelValue) ? method.name : labelValue;
            }
        }
        return method.name;
    }
}

