/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.io.File;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.core.RAMDirectoryFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.nuiton.wikitty.jdbc.WikittyStorageJDBC;
import org.nuiton.wikitty.services.WikittyServiceStorage;
import org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr;

public class WikittyServiceInMemoryJdbcSolr
extends WikittyServiceStorage {
    private static Log log = LogFactory.getLog(WikittyServiceInMemoryJdbcSolr.class);

    public WikittyServiceInMemoryJdbcSolr() {
        super(null, null, null);
        String dbName = "wikitty-tx-" + UUID.randomUUID().toString();
        ApplicationConfig config = WikittyConfig.getConfig();
        config.setOption(WikittyConfigOption.WIKITTY_STORAGE_JDBC_URL.getKey(), "jdbc:h2:mem:" + dbName);
        config.setOption(WikittyConfigOption.WIKITTY_DATA_DIR.getKey(), config.getOption("java.io.tmpdir") + File.separator + dbName);
        config.setOption(WikittyConfigOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY.getKey(), RAMDirectoryFactory.class.getName());
        this.extensionStorage = new WikittyExtensionStorageJDBC(config);
        this.wikittyStorage = new WikittyStorageJDBC(config, this.extensionStorage);
        this.searchEngine = new WikittySearchEngineSolr(config, this.extensionStorage);
    }
}

