/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.managed.BasicManagedDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikittyManagedDataSource
extends BasicManagedDataSource {
    private static Log log = LogFactory.getLog(WikittyManagedDataSource.class);
    protected int warnConnectionCount = 10;
    protected byte whenExhaustedAction = (byte)2;

    public byte getWhenExhaustedAction() {
        byte result = this.whenExhaustedAction;
        if (this.connectionPool != null) {
            this.connectionPool.getWhenExhaustedAction();
        }
        return result;
    }

    public void setWhenExhaustedAction(byte whenExhaustedAction) {
        this.whenExhaustedAction = whenExhaustedAction;
        if (this.connectionPool != null) {
            this.connectionPool.setWhenExhaustedAction(whenExhaustedAction);
        }
    }

    protected void createConnectionPool() {
        super.createConnectionPool();
        this.connectionPool.setWhenExhaustedAction(this.whenExhaustedAction);
    }

    public Connection getConnection() throws SQLException {
        Connection result = super.getConnection();
        int active = this.connectionPool.getNumActive();
        if (active > this.warnConnectionCount) {
            int idle = this.connectionPool.getNumIdle();
            this.warnConnectionCount *= 2;
            log.warn((Object)String.format("Too many database connection open active:%s idle:%s", active, idle));
        }
        return result;
    }
}

