/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamReader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.XMLLoader;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUpdateRequestHandler
extends ContentStreamHandlerBase {
    public static Logger log = LoggerFactory.getLogger(XmlUpdateRequestHandler.class);
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    public static final String UPDATE_PROCESSOR = "update.processor";
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String OPTIMIZE = "optimize";
    public static final String COMMIT = "commit";
    public static final String ROLLBACK = "rollback";
    public static final String WAIT_SEARCHER = "waitSearcher";
    public static final String WAIT_FLUSH = "waitFlush";
    public static final String OVERWRITE = "overwrite";
    public static final String COMMIT_WITHIN = "commitWithin";
    @Deprecated
    public static final String OVERWRITE_COMMITTED = "overwriteCommitted";
    @Deprecated
    public static final String OVERWRITE_PENDING = "overwritePending";
    @Deprecated
    public static final String ALLOW_DUPS = "allowDups";
    XMLInputFactory inputFactory;

    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = XMLInputFactory.newInstance();
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input chain: " + this.inputFactory);
        }
        this.inputFactory.setXMLReporter((XMLReporter)xmllog);
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new XMLLoader(processor, this.inputFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void doLegacyUpdate(InputStream input, String inputContentType, Writer output) {
        SolrCore core = SolrCore.getSolrCore();
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, new HashMap<String, String[]>());
        try {
            try {
                UpdateRequestProcessorChain processorFactory = core.getUpdateProcessingChain(null);
                SolrQueryResponse rsp = new SolrQueryResponse();
                String charset = ContentStreamBase.getCharsetFromContentType((String)inputContentType);
                XMLStreamReader parser = charset == null ? this.inputFactory.createXMLStreamReader(input) : this.inputFactory.createXMLStreamReader(input, charset);
                UpdateRequestProcessor processor = processorFactory.createProcessor(req, rsp);
                XMLLoader loader = (XMLLoader)this.newLoader(req, processor);
                loader.processUpdate(processor, parser);
                processor.finish();
                output.write("<result status=\"0\"></result>");
            }
            catch (Exception ex) {
                try {
                    SolrException.logOnce((Logger)log, (String)"Error processing \"legacy\" update command", (Throwable)ex);
                    XML.writeXML((Writer)output, (String)"result", (String)SolrException.toStr((Throwable)ex), (Object[])new Object[]{"status", "1"});
                }
                catch (Exception ee) {
                    log.error("Error writing to output stream: " + ee);
                }
                Object var13_15 = null;
                req.close();
            }
            Object var13_14 = null;
            req.close();
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            req.close();
            throw throwable;
        }
    }

    public String getDescription() {
        return "Add documents with XML";
    }

    public String getVersion() {
        return "$Revision: 1079955 $";
    }

    public String getSourceId() {
        return "$Id: XmlUpdateRequestHandler.java 1079955 2011-03-09 19:36:54Z uschindler $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_1/solr/src/java/org/apache/solr/handler/XmlUpdateRequestHandler.java $";
    }
}

