/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Payload;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.SorterTemplate;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysisRequestHandlerBase
extends RequestHandlerBase {
    static Map<String, String> ATTRIBUTE_MAPPING = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(OffsetAttribute.class.getName() + "#startOffset", "start");
            this.put(OffsetAttribute.class.getName() + "#endOffset", "end");
            this.put(TypeAttribute.class.getName() + "#type", "type");
        }
    });

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("analysis", this.doAnalysis(req));
    }

    protected abstract NamedList doAnalysis(SolrQueryRequest var1) throws Exception;

    protected NamedList<List<NamedList>> analyzeValue(String value, AnalysisContext context) {
        Analyzer analyzer = context.getAnalyzer();
        if (!TokenizerChain.class.isInstance(analyzer)) {
            TokenStream tokenStream = null;
            try {
                tokenStream = analyzer.reusableTokenStream(context.getFieldName(), (Reader)new StringReader(value));
                tokenStream.reset();
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            NamedList namedList = new NamedList();
            namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(this.analyzeTokenStream(tokenStream), context));
            return namedList;
        }
        TokenizerChain tokenizerChain = (TokenizerChain)analyzer;
        CharFilterFactory[] cfiltfacs = tokenizerChain.getCharFilterFactories();
        TokenizerFactory tfac = tokenizerChain.getTokenizerFactory();
        TokenFilterFactory[] filtfacs = tokenizerChain.getTokenFilterFactories();
        NamedList namedList = new NamedList();
        if (cfiltfacs != null) {
            String source = value;
            for (CharFilterFactory cfiltfac : cfiltfacs) {
                CharStream reader = CharReader.get((Reader)new StringReader(source));
                reader = cfiltfac.create(reader);
                source = this.writeCharStream(namedList, reader);
            }
        }
        Tokenizer tokenStream = tfac.create(tokenizerChain.charStream(new StringReader(value)));
        List<AttributeSource> tokens = this.analyzeTokenStream((TokenStream)tokenStream);
        namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(tokens, context));
        ListBasedTokenStream listBasedTokenStream = new ListBasedTokenStream(tokens);
        for (TokenFilterFactory tokenFilterFactory : filtfacs) {
            tokenStream = tokenFilterFactory.create(listBasedTokenStream);
            List<AttributeSource> tokenList = this.analyzeTokenStream((TokenStream)tokenStream);
            namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(tokenList, context));
            listBasedTokenStream = new ListBasedTokenStream(tokenList);
        }
        return namedList;
    }

    @Deprecated
    protected List<AttributeSource> analyzeValue(String value, Analyzer analyzer) {
        TokenStream tokenStream = analyzer.tokenStream("", (Reader)new StringReader(value));
        return this.analyzeTokenStream(tokenStream);
    }

    protected Set<String> getQueryTokenSet(String query, Analyzer analyzer) {
        HashSet<String> tokens = new HashSet<String>();
        TokenStream tokenStream = analyzer.tokenStream("", (Reader)new StringReader(query));
        CharTermAttribute termAtt = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        try {
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                tokens.add(termAtt.toString());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error occured while iterating over tokenstream", ioe);
        }
        return tokens;
    }

    private List<AttributeSource> analyzeTokenStream(TokenStream tokenStream) {
        ArrayList<AttributeSource> tokens = new ArrayList<AttributeSource>();
        tokenStream.addAttribute(CharTermAttribute.class);
        tokenStream.addAttribute(PositionIncrementAttribute.class);
        tokenStream.addAttribute(OffsetAttribute.class);
        tokenStream.addAttribute(TypeAttribute.class);
        try {
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                tokens.add(tokenStream.cloneAttributes());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error occured while iterating over tokenstream", ioe);
        }
        return tokens;
    }

    private List<NamedList> convertTokensToNamedLists(final List<AttributeSource> tokens, AnalysisContext context) {
        ArrayList<NamedList> tokensNamedLists = new ArrayList<NamedList>();
        final int[] positions = new int[tokens.size()];
        int position = 0;
        int c = tokens.size();
        for (int i = 0; i < c; ++i) {
            AttributeSource token = tokens.get(i);
            positions[i] = position += ((PositionIncrementAttribute)token.addAttribute(PositionIncrementAttribute.class)).getPositionIncrement();
        }
        new SorterTemplate(){
            private int pivot;

            protected void swap(int i, int j) {
                int p = positions[i];
                positions[i] = positions[j];
                positions[j] = p;
                Collections.swap(tokens, i, j);
            }

            protected int compare(int i, int j) {
                return positions[i] - positions[j];
            }

            protected void setPivot(int i) {
                this.pivot = positions[i];
            }

            protected int comparePivot(int j) {
                return this.pivot - positions[j];
            }
        }.mergeSort(0, tokens.size() - 1);
        FieldType fieldType = context.getFieldType();
        int c2 = tokens.size();
        for (int i = 0; i < c2; ++i) {
            AttributeSource token = tokens.get(i);
            SimpleOrderedMap tokenNamedList = new SimpleOrderedMap();
            String rawText = ((CharTermAttribute)token.addAttribute(CharTermAttribute.class)).toString();
            String text = fieldType.indexedToReadable(rawText);
            tokenNamedList.add("text", (Object)text);
            if (!text.equals(rawText)) {
                tokenNamedList.add("raw_text", (Object)rawText);
            }
            if (context.getTermsToMatch().contains(rawText)) {
                tokenNamedList.add("match", (Object)true);
            }
            tokenNamedList.add("position", (Object)positions[i]);
            token.reflectWith(new AttributeReflector((NamedList)tokenNamedList){
                final /* synthetic */ NamedList val$tokenNamedList;
                {
                    this.val$tokenNamedList = namedList;
                }

                public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                    if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                        return;
                    }
                    if (PositionIncrementAttribute.class.isAssignableFrom(attClass)) {
                        return;
                    }
                    String k = attClass.getName() + '#' + key;
                    if (ATTRIBUTE_MAPPING.containsKey(k)) {
                        k = ATTRIBUTE_MAPPING.get(k);
                    }
                    if (value instanceof Payload) {
                        Payload p = (Payload)value;
                        if (null != p) {
                            BigInteger bi = new BigInteger(p.getData());
                            String ret = bi.toString(16);
                            if (ret.length() % 2 != 0) {
                                ret = "0" + ret;
                            }
                            value = ret;
                        } else {
                            value = null;
                        }
                    }
                    this.val$tokenNamedList.add(k, value);
                }
            });
            tokensNamedLists.add((NamedList)tokenNamedList);
        }
        return tokensNamedLists;
    }

    private String writeCharStream(NamedList out, CharStream input) {
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        int len = 0;
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        out.add(input.getClass().getName(), (Object)sb.toString());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AnalysisContext {
        private final String fieldName;
        private final FieldType fieldType;
        private final Analyzer analyzer;
        private final Set<String> termsToMatch;

        public AnalysisContext(FieldType fieldType, Analyzer analyzer, Set<String> termsToMatch) {
            this(null, fieldType, analyzer, termsToMatch);
        }

        public AnalysisContext(String fieldName, FieldType fieldType, Analyzer analyzer) {
            this(fieldName, fieldType, analyzer, Collections.EMPTY_SET);
        }

        public AnalysisContext(String fieldName, FieldType fieldType, Analyzer analyzer, Set<String> termsToMatch) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.analyzer = analyzer;
            this.termsToMatch = termsToMatch;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Set<String> getTermsToMatch() {
            return this.termsToMatch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ListBasedTokenStream
    extends TokenStream {
        private final List<AttributeSource> tokens;
        private Iterator<AttributeSource> tokenIterator;

        ListBasedTokenStream(List<AttributeSource> tokens) {
            this.tokens = tokens;
            this.tokenIterator = tokens.iterator();
        }

        public boolean incrementToken() throws IOException {
            if (this.tokenIterator.hasNext()) {
                AttributeSource next = this.tokenIterator.next();
                Iterator atts = next.getAttributeClassesIterator();
                while (atts.hasNext()) {
                    this.addAttribute((Class)atts.next());
                }
                next.copyTo((AttributeSource)this);
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            super.reset();
            this.tokenIterator = this.tokens.iterator();
        }
    }
}

