/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.shrinking;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.event.ElementEvent;
import org.apache.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.jcs.engine.memory.MemoryCache;

public class ShrinkerThread
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread == null ? (class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread = ShrinkerThread.class$("org.apache.jcs.engine.memory.shrinking.ShrinkerThread")) : class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread));
    private final MemoryCache cache;
    private final long maxMemoryIdleTime;
    private int maxSpoolPerRun;
    private boolean spoolLimit = false;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread;

    public ShrinkerThread(MemoryCache cache) {
        this.cache = cache;
        long maxMemoryIdleTimeSeconds = cache.getCacheAttributes().getMaxMemoryIdleTimeSeconds();
        this.maxMemoryIdleTime = maxMemoryIdleTimeSeconds < 0L ? -1L : maxMemoryIdleTimeSeconds * 1000L;
        this.maxSpoolPerRun = cache.getCacheAttributes().getMaxSpoolPerRun();
        if (this.maxSpoolPerRun != -1) {
            this.spoolLimit = true;
        }
    }

    public void run() {
        this.shrink();
    }

    protected void shrink() {
        if (log.isDebugEnabled() && this.cache.getCompositeCache() != null) {
            log.debug((Object)("Shrinking memory cache for: " + this.cache.getCompositeCache().getCacheName()));
        }
        try {
            Object[] keys = this.cache.getKeyArray();
            int size = keys.length;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keys size: " + size));
            }
            int spoolCount = 0;
            for (int i = 0; i < size; ++i) {
                Serializable key = (Serializable)keys[i];
                ICacheElement cacheElement = this.cache.getQuiet(key);
                if (cacheElement == null) continue;
                IElementAttributes attributes = cacheElement.getElementAttributes();
                boolean remove = false;
                long now = System.currentTimeMillis();
                if (!cacheElement.getElementAttributes().getIsEternal() && (remove = this.checkForRemoval(cacheElement, now))) {
                    this.cache.remove(cacheElement.getKey());
                }
                if (remove || this.maxMemoryIdleTime == -1L) continue;
                if (!this.spoolLimit || spoolCount < this.maxSpoolPerRun) {
                    long lastAccessTime = attributes.getLastAccessTime();
                    if (lastAccessTime + this.maxMemoryIdleTime >= now) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exceeded memory idle time: " + cacheElement.getKey()));
                    }
                    ++spoolCount;
                    this.cache.remove(cacheElement.getKey());
                    this.cache.waterfal(cacheElement);
                    key = null;
                    cacheElement = null;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("spoolCount = '" + spoolCount + "'; " + "maxSpoolPerRun = '" + this.maxSpoolPerRun + "'"));
                }
                if (!this.spoolLimit || spoolCount < this.maxSpoolPerRun) continue;
                keys = null;
                return;
            }
            keys = null;
        }
        catch (Throwable t) {
            log.info((Object)"Unexpected trouble in shrink cycle", t);
            return;
        }
    }

    private boolean checkForRemoval(ICacheElement cacheElement, long now) throws IOException {
        IElementAttributes attributes = cacheElement.getElementAttributes();
        long maxLifeSeconds = attributes.getMaxLifeSeconds();
        long createTime = attributes.getCreateTime();
        if (maxLifeSeconds != -1L && now - createTime > maxLifeSeconds * 1000L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Exceeded maxLifeSeconds: " + cacheElement.getKey()));
            }
            this.handleElementEvents(cacheElement, 0);
            return true;
        }
        long idleTime = attributes.getIdleTime();
        long lastAccessTime = attributes.getLastAccessTime();
        if (idleTime != -1L && now - lastAccessTime > idleTime * 1000L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Exceeded maxIdleTime " + cacheElement.getKey()));
            }
            this.handleElementEvents(cacheElement, 2);
            return true;
        }
        return false;
    }

    private void handleElementEvents(ICacheElement cacheElement, int eventType) throws IOException {
        IElementAttributes attributes = cacheElement.getElementAttributes();
        ArrayList eventHandlers = attributes.getElementEventHandlers();
        if (eventHandlers != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handlers are registered, type: " + eventType));
            }
            ElementEvent event = new ElementEvent(cacheElement, eventType);
            Iterator handlerIter = eventHandlers.iterator();
            while (handlerIter.hasNext()) {
                IElementEventHandler hand = (IElementEventHandler)handlerIter.next();
                if (this.cache.getCompositeCache() == null) continue;
                this.cache.getCompositeCache().addElementEvent(hand, event);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

