/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCacheAbstractFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheManager;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryManager;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryService;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;

public class LateralTCPCacheFactory
extends LateralCacheAbstractFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheFactory == null ? (class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheFactory = LateralTCPCacheFactory.class$("org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory")) : class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheFactory));
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheFactory;

    public AuxiliaryCache createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr) {
        ITCPLateralCacheAttributes lac = (ITCPLateralCacheAttributes)iaca;
        ArrayList<AuxiliaryCache> noWaits = new ArrayList<AuxiliaryCache>();
        if (lac.getTcpServers() != null) {
            StringTokenizer it = new StringTokenizer(lac.getTcpServers(), ",");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configured for [" + it.countTokens() + "]  servers."));
            }
            while (it.hasMoreElements()) {
                String server = (String)it.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("tcp server = " + server));
                }
                ITCPLateralCacheAttributes lacC = (ITCPLateralCacheAttributes)lac.copy();
                lacC.setTcpServer(server);
                LateralTCPCacheManager lcm = LateralTCPCacheManager.getInstance(lacC, cacheMgr);
                AuxiliaryCache ic = lcm.getCache(lacC.getCacheName());
                if (ic != null) {
                    noWaits.add(ic);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"noWait is null, no lateral connection made");
            }
        }
        this.createListener((ILateralCacheAttributes)iaca, cacheMgr);
        LateralCacheNoWaitFacade lcnwf = new LateralCacheNoWaitFacade(noWaits.toArray(new LateralCacheNoWait[0]), (ILateralCacheAttributes)iaca);
        this.createDiscoveryService(lac, lcnwf, cacheMgr);
        return lcnwf;
    }

    public void createListener(ILateralCacheAttributes lac, ICompositeCacheManager cacheMgr) {
        ITCPLateralCacheAttributes attr = (ITCPLateralCacheAttributes)lac;
        if (attr.isReceive()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating listener for " + lac));
            }
            try {
                LateralTCPListener.getInstance(attr, cacheMgr);
            }
            catch (Exception e) {
                log.error((Object)"Problem creating lateral listener", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Not creating a listener since we are not receiving.");
        }
    }

    private UDPDiscoveryService createDiscoveryService(ITCPLateralCacheAttributes lac, LateralCacheNoWaitFacade lcnwf, ICompositeCacheManager cacheMgr) {
        UDPDiscoveryService discovery = null;
        if (lac.isUdpDiscoveryEnabled()) {
            discovery = UDPDiscoveryManager.getInstance().getService(lac, cacheMgr);
            discovery.addNoWaitFacade(lcnwf, lac.getCacheName());
            if (log.isInfoEnabled()) {
                log.info((Object)"Created UDPDiscoveryService for TCP lateral cache.");
            }
        }
        return discovery;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

