/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: FullTreeCallback.java 173 2011-05-27 08:32:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/skills/FullTreeCallback.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.skills;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.entities.Skill;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.web.gwt.misc.LoaderNotification;

/**
 * User: couteau
 * Date: 07/03/11
 */
public class FullTreeCallback extends RefcompCallBack<List<Skill>>
        implements AsyncCallback<List<Skill>> {

    protected Map<String, TreeItem> items = null;

    protected Tree tree;

    public FullTreeCallback(Tree tree) {
        this.tree = tree;
    }

    @Override
    public void onSuccess(List<Skill> result) {

        items = new HashMap<String, TreeItem>();

        tree.removeItems();

        //Populate map with items
        for (Skill skill:result) {
            if (skill != null) {
                if (skill.getParent() != null) {
                    TreeItem ti = new TreeItem(skill.getName());
                    ti.addStyleName("child");

                    items.put(skill.getWikittyId(), ti);

                } else {
                    TreeItem ti = new TreeItem(skill.getName());
                    ti.addStyleName("first");

                    items.put(skill.getWikittyId(), ti);
                }
            }
        }

        //Attach items to tree
        for (Skill skill : result) {
            if (skill != null) {
                if (skill.getParent() != null) {
                    TreeItem ti = items.get(skill.getWikittyId());
                    TreeItem parent = items.get(skill.getParent());
                    if (parent != null) {
                        parent.addItem(ti);
                        parent.setState(true, true);
                    }
                } else {
                    TreeItem ti = items.get(skill.getWikittyId());
                    tree.addItem(ti);
                }
            }
        }

        LoaderNotification.closeLoader();
    }
}
