/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: DepartmentForm.java 264 2012-02-20 16:07:24Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/departments/DepartmentForm.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.departments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.*;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.services.AlreadyExistingException;
import fr.inra.refcomp.services.InvalidEntityException;
import org.nuiton.web.gwt.misc.BlindedPopup;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 2 déc. 2010
 */
public class DepartmentForm extends Composite implements FormContent {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("DepartmentForm.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, DepartmentForm> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    @UiField
    TextBox departmentBox;

    @UiField
    TextBox fullNameDepartmentBox;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    Label errorLabel;

    Department bean;

    public DepartmentForm() {
        initWidget(binder.createAndBindUi(this));
        departmentBox.setEnabled(false);
        fullNameDepartmentBox.setEnabled(false);
    }

    @Override
    public void setContent(BusinessEntity bean) {
        if ((bean != null) && (bean instanceof Department)) {
            this.bean = (Department) bean;

            departmentBox.setText(this.bean.getName());
            departmentBox.setEnabled(true);

            fullNameDepartmentBox.setText(this.bean.getFullName());
            fullNameDepartmentBox.setEnabled(true);

            errorPanel.setVisible(false);
        }
    }

    @Override
    public void clearContent() {
        bean = null;

        departmentBox.setText("");
        departmentBox.setEnabled(false);

        fullNameDepartmentBox.setText("");
        fullNameDepartmentBox.setEnabled(false);

        errorPanel.setVisible(false);
    }

    @Override
    public BusinessEntity getContent() {
        bean.setName(departmentBox.getText());
        bean.setFullName(fullNameDepartmentBox.getText());
        return bean;
    }

    @Override
    public void saveContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            errorPanel.setVisible(false);

            service.saveDepartment((Department) getContent(),
                    new RefcompCallBack<Department>() {
                        @Override
                        public void onSuccess(Department result) {
                            setContent(result);
                            AdminDepartments.refresh();
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof InvalidEntityException) {
                                new BlindedPopup(new ErrorPanel(caught.getMessage()));
                            } else {
                                Window.alert(messages.exception());
                            }
                        }
                    });
        }
    }

    @Override
    public void cancelContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            clearContent();
        }
    }

    @Override
    public void deleteContent() {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            service.deleteDepartment((Department) getContent(),
                    new RefcompCallBack<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            clearContent();
                            AdminDepartments.refresh();
                        }
                    });
        }
    }
}
