/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObservationType;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceContact;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.services.BeanModelSource;

public class SampleRowModelFactory {
    protected BeanModelSource beanModelSource;
    protected ComponentResources resources;
    protected ConnectedUser connectedUser;
    protected Messages messages;
    protected BeanModel<SampleRow> model;
    protected ServiceContact serviceContact;

    public SampleRowModelFactory(BeanModelSource beanModelSource, ComponentResources resources, ConnectedUser connectedUser, Messages messages, ServiceContact serviceContact) {
        this.beanModelSource = beanModelSource;
        this.resources = resources;
        this.connectedUser = connectedUser;
        this.messages = messages;
        this.serviceContact = serviceContact;
    }

    protected void add(String property, PropertyConduit conduit) {
        this.model.add(property, conduit);
        this.model.get(property).sortable(false);
    }

    protected void add(String property) {
        this.model.add(property);
        this.model.get(property).sortable(false);
    }

    protected void initModel() {
        this.add("code");
        this.add("company", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("year", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("week", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("dayOfWeek", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("day", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("subPopulation", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("observationUnit");
        this.add("boat");
        this.add("actual", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("comment");
        this.add("observers", (PropertyConduit)new /* Unavailable Anonymous Inner Class!! */);
        this.add("substitutes", null);
        this.add("actions", null);
    }

    protected void filterModel(ObservationType observationType) {
        if (!this.connectedUser.isAdmin()) {
            this.model.exclude(new String[]{"company"});
        }
        if (!this.connectedUser.isObserver()) {
            this.model.exclude(new String[]{"subPopulation", "dayOfWeek"});
        }
        if (observationType == ObservationType.PHONE_CALL) {
            this.model.exclude(new String[]{"dayOfWeek", "day", "subPopulation", "observationUnit"});
        } else {
            this.model.exclude(new String[]{"boat", "substitutes"});
        }
    }

    public BeanModel<SampleRow> newModel(ObservationType observationType) {
        this.model = this.beanModelSource.createDisplayModel(SampleRow.class, this.resources.getMessages());
        this.model.include(new String[0]);
        this.initModel();
        this.filterModel(observationType);
        return this.model;
    }
}

