/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterImpl;
import fr.ifremer.wao.bean.CompanyBoatInfos;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.BoatInfos;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ElligibleBoat;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BoatDataSource;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.BoatActivityCalendar;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER, UserRole.PROFESSIONAL})
@Import(stylesheet={"context:css/boats.css"})
public class Boats
extends AbstractFilteredPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private PropertyAccess propertyAccess;
    @Property
    private String sampleRowContextId;
    @Persist(value="flash")
    private Integer boatSelectedImmatriculation;
    @InjectComponent
    private FeedBack filterFeedback;
    @Persist
    private BoatFilter boatFilter;
    @Persist
    private SampleRow sampleRow;
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;
    @Property
    private String professionId;
    @Persist
    private boolean filtersHidden;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private BoatDataSource boats;
    @Property
    private Boat boat;
    private boolean even = true;
    @InjectComponent
    private Zone boatsZone;
    @Persist
    private CompanyBoatInfos companyBoatInfos;
    @InjectComponent
    private Zone boatInfosZone;
    @Inject
    private Block displayBoatInfos;
    @Inject
    private Block editBoatInfos;
    @Property
    private ElligibleBoat elligibleBoat;
    @Property
    private String boatInfosSampleRowId;
    private boolean boatInfosEditable;
    private Date boardingFromDate;
    private GenericSelectModel<Company> companies;
    @Inject
    private ServiceUser serviceUser;
    @Property
    @Persist(value="flash")
    private String companySelectedId;
    private Company company;
    @Inject
    private WaoManager manager;
    @InjectPage
    private Contacts contacts;
    @Inject
    private PageRenderLinkSource renderLink;
    @Inject
    private Messages messages;

    public Integer getBoatSelectedImmatriculation() {
        return this.boatSelectedImmatriculation;
    }

    public void setBoatSelectedImmatriculation(Integer boatSelectedImmatriculation) {
        this.boatSelectedImmatriculation = boatSelectedImmatriculation;
    }

    void setupRender() throws WaoException {
        if (this.boatSelectedImmatriculation != null && this.getBoatSelected() == null) {
            this.layout.addFatal("L'immatriculation " + this.boatSelectedImmatriculation + " ne correspond \u00e0 aucun navire affichable. " + "Veuillez \u00e0 enlever cette immatriculation de l'url puis" + " rechargez la page.");
            this.boatSelectedImmatriculation = null;
        }
        this.sampleRow = null;
        this.getSampleRow();
        if (this.isSampleRowExists()) {
            this.getFilter().setSampleRow(this.sampleRow);
            this.filtersHidden = false;
            this.boats = null;
            this.filterFeedback.addInfo("Vous \u00eates en cours de s\u00e9lection d'un navire pour la ligne du plan " + this.sampleRow.getCode());
            this.professionId = this.getSampleRow().getProfession().getTopiaId();
        }
        this.initSelectFilters(false, false, false);
        this.initCompanyFilter();
        this.companyBoatInfos = null;
    }

    void onActivate(EventContext ec) {
        this.sampleRowContextId = (String)ec.get(String.class, 0);
        if (ec.getCount() > 1) {
            this.boatSelectedImmatriculation = (Integer)ec.get(Integer.class, 1);
        }
    }

    String onPassivate() {
        return this.sampleRowContextId;
    }

    public SamplingFilter getFilter() throws WaoException {
        return this.getBoatFilter();
    }

    public BoatFilter getBoatFilter() throws WaoException {
        if (this.boatFilter == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Create filter");
            }
            this.boatFilter = new BoatFilterImpl();
            this.boatFilter.setNbMonthFinishedFromToday(Integer.valueOf(-1));
            this.boatFilter.setObsProgram(this.user.getProfile().getObsProgram());
        }
        return this.boatFilter;
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return true;
    }

    public SampleRow getSampleRow() throws WaoException {
        if (this.sampleRow == null && !StringUtils.isEmpty((String)this.sampleRowContextId)) {
            this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowContextId);
        }
        return this.sampleRow;
    }

    public boolean isSampleRowExists() throws WaoException {
        return this.getSampleRow() != null;
    }

    public boolean isFiltersHidden() {
        return this.filtersHidden;
    }

    public String getHiddenStyle() {
        return this.isFiltersHidden() ? "hidden" : "";
    }

    Block onActionFromShowFilters() {
        this.filtersHidden = false;
        return this.filtersZone.getBody();
    }

    Block onActionFromHideFilters() {
        this.filtersHidden = true;
        return this.filtersZone.getBody();
    }

    public String[] onProvideCompletionsFromShipOwnerName(String input) {
        List results = this.serviceBoat.getShipOwnerNamesContains(input);
        return results.toArray(new String[results.size()]);
    }

    void onSelectedFromReset() {
        this.boatFilter = null;
        this.sampleRowContextId = null;
    }

    public void onSelectedFromSearch() throws WaoException {
        super.onSelectedFromSearch();
        if (this.log.isDebugEnabled()) {
            this.log.debug("FILTER : facadeName=" + this.boatFilter.getFacadeName());
            this.log.debug("FILTER : sectorName=" + this.boatFilter.getSectorName());
            this.log.debug("FILTER : sampleRow=" + this.boatFilter.getSampleRow());
            this.log.debug("FILTER : boatName=" + this.boatFilter.getBoatName());
            this.log.debug("FILTER : boatImmatriculation=" + this.boatFilter.getBoatImmatriculation());
            this.log.debug("FILTER : boatDistrictCode=" + this.boatFilter.getBoatDistrictCode());
            this.log.debug("FILTER : company=" + this.boatFilter.getCompany());
        }
    }

    Object onSuccessFromFiltersForm() throws WaoException {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        this.boats = null;
        this.boatSelectedImmatriculation = null;
        this.companyBoatInfos = null;
        return this;
    }

    public BoatDataSource getBoats() throws WaoException {
        if (this.boats == null) {
            this.boats = new BoatDataSource(this.getBoatFilter(), this.serviceBoat);
        }
        return this.boats;
    }

    public String getRowStyle() {
        String result = "";
        boolean bl = this.even = !this.even;
        result = this.boatSelectedImmatriculation != null && this.boat.getImmatriculation() == this.boatSelectedImmatriculation.intValue() ? "selected" : (!this.boat.getActive() ? "refused" : (this.even ? "even" : "odd"));
        return result;
    }

    public String getBoatInactive() {
        return !this.boat.getActive() ? "(inactif)" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean canCreateNewContactFromList() throws WaoException {
        if (!this.user.isAdmin() && !this.user.isProfessional() && !this.user.isReadOnly() && this.isSampleRowExists()) {
            return this.boat.canCreateContact(this.user.getProfile().getObsProgram(), this.user.getCompany());
        }
        return false;
    }

    StreamResponse onActionFromExportShowBoats() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Block onActionFromShowBoatInfos(Integer boatImma) throws WaoException {
        this.boatSelectedImmatriculation = boatImma;
        this.companyBoatInfos = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Show infos for boat : " + boatImma);
        }
        if (this.user.isAdmin() && this.getCompany() != null) {
            this.companySelectedId = this.getCompany().getTopiaId();
        }
        return this.boatsZone.getBody();
    }

    public boolean isActivityCalendarImportRun() {
        return this.manager.isActivityCalendarImportRun();
    }

    public Block getActiveBoatInfosBlock() {
        if (this.boatInfosEditable) {
            return this.editBoatInfos;
        }
        return this.displayBoatInfos;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws WaoException {
        if (this.companyBoatInfos == null && this.boatSelectedImmatriculation != null && this.getCompany() != null) {
            this.companyBoatInfos = this.serviceBoat.getCompanyBoatInfos(this.user.getProfile().getObsProgram(), this.boatSelectedImmatriculation.intValue(), this.getCompany());
        }
        return this.companyBoatInfos;
    }

    public GenericSelectModel<Company> getCompanies() throws WaoException {
        if (this.companies == null) {
            List results = this.serviceUser.getCompanies(true);
            this.companies = new GenericSelectModel(results, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companies;
    }

    public Company getCompany() throws WaoException {
        if (this.company == null) {
            if (StringUtils.isNotEmpty((String)this.companySelectedId)) {
                this.company = (Company)this.getCompanies().findObject(this.companySelectedId);
            } else if (!this.user.isAdmin()) {
                this.company = this.user.getCompany();
            }
        }
        return this.company;
    }

    public Boat getBoatSelected() throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("selected imma : " + this.boatSelectedImmatriculation);
            this.log.debug("exist boat ? : " + this.getBoats().contains((Object)this.boatSelectedImmatriculation));
        }
        return (Boat)this.getBoats().get((Object)this.boatSelectedImmatriculation);
    }

    public Date getBoardingFromDate() {
        if (this.boardingFromDate == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(2, -12);
            this.boardingFromDate = calendar.getTime();
        }
        return this.boardingFromDate;
    }

    public void setBoardingFromDate(Date boardingFromDate) {
        this.boardingFromDate = boardingFromDate;
    }

    public BoatInfos getBoatInfos() throws WaoException {
        if (this.getCompanyBoatInfos() == null) {
            return null;
        }
        return this.getCompanyBoatInfos().getBoatInfos();
    }

    public String getlastContactStyle() throws WaoException {
        Contact contact = this.getCompanyBoatInfos().getLastContact();
        return this.manager.getContactStyle(contact, this.user.isAdmin());
    }

    public String getElligibleRowInfos() {
        return this.manager.getTooltipSampleRow(this.elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse((Boolean)this.elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws WaoException {
        if (!(this.user.isAdmin() || this.user.isReadOnly() || this.isElligibleBoatCompanyActiveFalse())) {
            Boat currentBoat = this.getBoatInfos().getBoat();
            return currentBoat.canCreateContact(this.user.getProfile().getObsProgram(), this.user.getCompany());
        }
        return false;
    }

    public boolean isSampleRowFinished() {
        boolean result = this.elligibleBoat.getSampleRow().isFinished(0);
        return result;
    }

    public String getElligibleRowStyle() {
        boolean condition1 = this.elligibleBoat.getCompanyActive() == null && !this.elligibleBoat.getGlobalActive();
        return condition1 || this.isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    public boolean canEditBoatInfos() {
        return !this.user.isReadOnly();
    }

    void onSuccess() throws WaoException {
        if (this.getBoatInfos() != null) {
            this.boatSelectedImmatriculation = this.getBoatInfos().getBoat().getImmatriculation();
        }
    }

    Block onSuccessFromCompanySelectForm() throws WaoException {
        this.companyBoatInfos = null;
        this.getCompanyBoatInfos();
        return this.boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() throws WaoException {
        if (this.canEditBoatInfos()) {
            this.boatInfosEditable = true;
            this.getFilter().setNbMonthFinishedFromToday(null);
            this.resetSampleRowSelect();
            this.getFilter().setNbMonthFinishedFromToday(Integer.valueOf(-1));
        }
        return this.boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws WaoException {
        this.boatSelectedImmatriculation = this.getBoatInfos().getBoat().getImmatriculation();
        this.companyBoatInfos = null;
        return this.boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws WaoException {
        this.boatInfosEditable = true;
        if (StringUtils.isNotEmpty((String)this.boatInfosSampleRowId)) {
            SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.boatInfosSampleRowId);
            this.companyBoatInfos.setNewElligibleBoat(row);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws WaoException {
        if (!this.boatInfosEditable && this.canEditBoatInfos()) {
            this.serviceBoat.createUpdateCompanyBoatInfos(this.companyBoatInfos);
        }
        return this.boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws WaoException {
        return this.boatInfosZone.getBody();
    }

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws WaoException {
        this.sampleRow = this.getSampleRow();
        this.boat = (Boat)this.getBoats().get((Object)boatImmatriculation);
        Contact newContact = this.serviceContact.getNewContact(this.user.getUser(), this.sampleRow, this.boat);
        this.contacts.setContactSelectedId(newContact.getTopiaId());
        return this.contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws WaoException {
        ElligibleBoat elligible = this.getCompanyBoatInfos().getElligibleBoat(sampleRowCode);
        this.sampleRow = elligible.getSampleRow();
        Contact newContact = this.serviceContact.getNewContact(this.user.getUser(), this.sampleRow, this.getBoatSelected());
        this.contacts.setContactSelectedId(newContact.getTopiaId());
        return this.contacts;
    }

    public boolean hasActivityCalendar() throws WaoException {
        return this.getBoatSelected() != null && this.getBoatSelected().sizeActivityCalendar() != 0;
    }

    Link onActionFromShowLastActivityCalendar() throws WaoException {
        Link result = this.renderLink.createPageRenderLinkWithContext(BoatActivityCalendar.class, new Object[]{this.getBoatSelected().getImmatriculation()});
        return result;
    }

    public String getLabelForEnum(Enum value) {
        return this.messages.get(value.getDeclaringClass().getSimpleName() + "." + value.name());
    }

    static /* synthetic */ Logger access$000(Boats x0) {
        return x0.log;
    }

    static /* synthetic */ ServiceBoat access$100(Boats x0) {
        return x0.serviceBoat;
    }
}

